package caslayout.ui.db;

import java.util.Date;

/**
 * @hibernate.class table="nc_humansubject"
 * @author I. Burak Ozyurt
 * @version $Id: Subject.java,v 1.2 2007/10/08 18:00:42 bozyurt Exp $
 */

public class Subject extends AbstractVO {
	protected Long uniqueID;
	protected String subjectID;
	protected String extensionName;
	protected String name;
	protected Date birthDate;
	protected String localID;
	protected Long siteID;
	protected Boolean remote;
	protected AnimalSpecies animalSpecies;

	/**
	 * @hibernate.id column="uniqueid" generator-class="sequence" 
	 * @return
	 */
	public Long getUniqueID() {
		return uniqueID;
	}

	/**
	 * @hibernate.property column="subjectid" length="64" not-null="true"
	 * @return
	 */
	public String getSubjectID() {
		return subjectID;
	}

	/**
	 * @hibernate.property column="extensionname" length="64" not-null="true"
	 * @return
	 */
	public String getExtensionName() {
		return extensionName;
	}

	/**
	 * @hibernate.property column="name" length="128"
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * @hibernate.property column="birthdate"
	 * @return
	 */
	public Date getBirthDate() {
		return birthDate;
	}

	/**
	 * @hibernate.property column="localid"
	 * @return
	 */
	public String getLocalID() {
		return localID;
	}

	/**
	 * @hibernate.property column="siteid"
	 * @return
	 */
	public Long getSiteID() {
		return siteID;
	}

	/**
	 * @hibernate.property column="isremote"
	 * @return
	 */
	public Boolean isRemote() {
		return remote;
	}

	/**
	 * @hibernate.many-to-one column="nc_animalspecies_uniqueid"
	 * class="caslayout.ui.db.AnimalSpecies" 
	 * not-null="true" outer-join="true"
	 * @return
	 */
	public AnimalSpecies getAnimalSpecies() {
		return animalSpecies;
	}

	public void setUniqueID(Long uniqueID) {
		this.uniqueID = uniqueID;
	}

	public void setSubjectID(String subjectID) {
		this.subjectID = subjectID;
	}

	public void setExtensionName(String extensionName) {
		this.extensionName = extensionName;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setBirthDate(Date birthDate) {
		this.birthDate = birthDate;
	}

	public void setLocalID(String localID) {
		this.localID = localID;
	}

	public void setSiteID(Long siteID) {
		this.siteID = siteID;
	}

	public void setRemote(Boolean remote) {
		this.remote = remote;
	}

	public void setAnimalSpecies(AnimalSpecies animalSpecies) {
		this.animalSpecies = animalSpecies;
	}

}
