package caslayout.ui.db;

/**
 * 
 * @hibernate.class table="nc_tableid"
 * 
 * @author I. Burak Ozyurt
 * @version $Id: TableID.java,v 1.2 2007/10/08 18:00:42 bozyurt Exp $
 */
public class TableID extends AbstractVO {
	protected String tableName;
	protected Long tableID;
	protected Long uniqueID;
	protected Long majorVersion;
	protected Long minorVersion;
	protected String description;

	/**
	 * @hibernate.property column="tableid" not-null="true"
	 * @return
	 */
	public Long getTableID() {
		return tableID;
	}

	public void setTableID(Long tableID) {
		this.tableID = tableID;
	}

	/**
	 * @hibernate.id column="tablename" generator-class="assigned" length="200"
	 * @return
	 */
	public String getTableName() {
		return tableName;
	}

	/**
	 * @hibernate.property column="uniqueid" not-null="true"
	 * @return
	 */
	public Long getUniqueID() {
		return uniqueID;
	}

	/**
	 * @hibernate.property column="majorversion" not-null="true"
	 * @return
	 */
	public Long getMajorVersion() {
		return majorVersion;
	}

	/**
	 * @hibernate.property column="minorversion" not-null="true"
	 * @return
	 */
	public Long getMinorVersion() {
		return minorVersion;
	}

	/**
	 * @hibernate.property column="description" type="text"
	 * @return
	 */
	public String getDescription() {
		return description;
	}

	public void setTableName(String tableName) {
		this.tableName = tableName;
	}

	public void setUniqueID(Long uniqueID) {
		this.uniqueID = uniqueID;
	}

	public void setMajorVersion(Long majorVersion) {
		this.majorVersion = majorVersion;
	}

	public void setMinorVersion(Long minorVersion) {
		this.minorVersion = minorVersion;
	}

	public void setDescription(String description) {
		this.description = description;
	}

}
