package caslayout.ui.db;

/**
 * @hibernate.class table="nc_userclass"
 * 
 * @author I. Burak Ozyurt
 * @version $Id: UserClass.java,v 1.2 2007/10/08 18:00:42 bozyurt Exp $
 */
public class UserClass extends AbstractVO {
	protected Long uniqueID;
	protected String userClass;
	protected String name;
	protected String description;

	/**
	 * @hibernate.id column="uniqueid" generator-class="sequence"
	 * @return
	 */
	public Long getUniqueID() {
		return uniqueID;
	}

	/**
	 * @hibernate.property column="name"
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * @hibernate.property column="description" type="text"
	 * @return
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @hibernate.property column="userclass"
	 * @return
	 */
	public String getUserClass() {
		return userClass;
	}
	
	public void setUniqueID(Long uniqueID) {
		this.uniqueID = uniqueID;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setDescription(String description) {
		this.description = description;
	}
	

	public void setUserClass(String userClass) {
		this.userClass = userClass;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("UserClass::[");
		buf.append("uniqueID=").append(uniqueID);
		buf.append(",userClass=").append(userClass);
		buf.append(']');
		return buf.toString();
	}
}
