package caslayout.ui.db;

/**
 * @hibernate.class table="nc_userstatus"
 * 
 * @author I. Burak Ozyurt
 * @version $Id: UserStatus.java,v 1.2 2007/10/08 18:00:42 bozyurt Exp $
 */
public class UserStatus extends AbstractVO {
	protected Long uniqueID;
	protected String userStatus;
	protected String name;
	protected String description;

	/**
	 * @hibernate.id column="uniqueid" generator-class="sequence"
	 * @return
	 */
	public Long getUniqueID() {
		return uniqueID;
	}

	/**
	 * @hibernate.property column="name"
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * @hibernate.property column="description" type="text"
	 * @return
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @hibernate.property column="userstatus"
	 * @return
	 */
	public String getUserStatus() {
		return userStatus;
	}
	
	public void setUniqueID(Long uniqueID) {
		this.uniqueID = uniqueID;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setDescription(String description) {
		this.description = description;
	}
	

	public void setUserStatus(String userStatus) {
		this.userStatus = userStatus;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("UserStatus::[");
		buf.append("uniqueID=").append(uniqueID);
		buf.append(",userStatus=").append(userStatus);
		buf.append(']');
		return buf.toString();
	}

}
