package caslayout.ui.db;

import java.sql.Timestamp;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

/**
 * @hibernate.class table="nc_expcomponent"
 *
 * @author I. Burak Ozyurt
 * @version $Id: Visit.java,v 1.3 2008/10/13 23:58:08 bozyurt Exp $
 */
public class Visit extends AbstractVO {
	protected VisitKey visitKey;
	protected Long uniqueID;
	protected Timestamp timeStamp;
	protected String description;
	protected String visitType;
	protected String name;
	protected Float timeInterval;
	protected Boolean isTimeInterval;

	protected Set<Study> studies = new LinkedHashSet<Study>(3);
	protected Set<Segment> segments = new LinkedHashSet<Segment>(3);


	/**
	 * @hibernate.id generator-class="assigned"
	 * @return
	 */
	public VisitKey getVisitKey() {
		return visitKey;
	}

	public void setVisitKey(VisitKey visitKey) {
		this.visitKey = visitKey;
	}

	/**
	 * @hibernate.property column="uniqueid" not-null="true"
	 * @return
	 */
	public Long getUniqueID() {
		return uniqueID;
	}

	/**
	 * @hibernate.property column="time_stamp" not-null="true"
	 * @return
	 */
	public Timestamp getTimeStamp() {
		return timeStamp;
	}

	/**
	 * @hibernate.property column="description" type="text"
	 * @return
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * @hibernate.property column="name" length="128"
	 * @return
	 */
	public String getName() {
		return name;
	}

	/**
	 * @hibernate.property column="timeinterval"
	 * @return
	 */
	public Float getTimeInterval() {
		return timeInterval;
	}

	/**
	 * @hibernate.property column="istimeinterval" not-null="true"
	 * @return
	 */
	public Boolean getIsTimeInterval() {
		return isTimeInterval;
	}

	/**
	 * @hibernate.property column="visittype" not-null="true" length="64"
	 * @return
	 */
	public String getVisitType() {
		return visitType;
	}


	public Set<Study> getStudies() {
		return studies;
	}

	public Set<Segment> getSegments() {
		return segments;
	}


	public void setUniqueID(Long uniqueID) {
		this.uniqueID = uniqueID;
	}

	public void setTimeStamp(Timestamp timeStamp) {
		this.timeStamp = timeStamp;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setTimeInterval(Float timeInterval) {
		this.timeInterval = timeInterval;
	}

	public void setIsTimeInterval(Boolean isTimeInterval) {
		this.isTimeInterval = isTimeInterval;
	}

	public void setStudies(Set<Study> studies) {
		this.studies = studies;
	}

	public void setSegments(Set<Segment> segments) {
		this.segments = segments;
	}

	public void setVisitType(String visitType) {
		this.visitType = visitType;
	}

	public void addStudy(Study study) {
		studies.add(study);
	}


	public String toString() {
		StringBuffer buf = new StringBuffer();
		buf.append("Visit::[");
		buf.append(visitKey.toString());
		buf.append(",visitType=").append(visitType);
		buf.append(",timeStamp=").append(timeStamp);
		for (Iterator<Study> it = studies.iterator(); it.hasNext();) {
			Study study = it.next();
			buf.append("\n").append(study.toString());
		}

		buf.append(']');
		return buf.toString();
	}


}
