package caslayout.ui.db.oracle;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.LinkedList;
import java.util.List;

import caslayout.exception.ValidationException;
import caslayout.ui.db.AssessmentItem;
import caslayout.ui.db.IAssessmentItemDAO;

public class AssessmentItemDAO implements IAssessmentItemDAO {
   public AssessmentItemDAO() {}

   public void insert(Connection con, AssessmentItem bean) throws Exception {
      PreparedStatement ps = null;
      StringBuffer buf = new StringBuffer(200);

      if (bean == null)
         return;
      try {
         buf.append("INSERT INTO NC_ASSESSMENTITEM VALUES ");
         buf.append('(');
         for (int i = 0; i < 9; ++i) {
            buf.append('?');
            if (i < 8)
               buf.append(',');
         }
         buf.append(")");
         ps = con.prepareStatement(buf.toString());
         ps.clearParameters();
         ps.setObject(1, toBigDecimal(bean.getAssessmentID()), Types.NUMERIC);
         ps.setObject(2, bean.getScoreName(), Types.VARCHAR);
         ps.setObject(3, toBigDecimal(bean.getTableID()), Types.NUMERIC);
         ps.setObject(4, toBigDecimal(bean.getUniqueID()), Types.NUMERIC);
         ps.setObject(5, toBigDecimal(bean.getOwner()), Types.NUMERIC);
         ps.setObject(6, new java.sql.Date(bean.getModTime().getTime()));
         ps.setObject(7, toBigDecimal(bean.getModUser()), Types.NUMERIC);
         ps.setObject(8, bean.getItemLeadingText(), Types.VARCHAR);
         ps.setObject(9, bean.getItemTrailingText(), Types.VARCHAR);
         ps.executeUpdate();

      } finally {
         if (ps != null)
            try {
               ps.close();
            } catch (Exception x) { /* ignore */}
      }
   }

   protected BigDecimal toBigDecimal(int value) {
      return new BigDecimal(String.valueOf(value));
   }

   protected BigDecimal toBigDecimal(Long value) {
      return new BigDecimal(value.toString());
   }

   protected String prepareColList(AssessmentItem bean) {
      StringBuffer buf = new StringBuffer(200);

      buf.append("ASSESSMENTID");
      buf.append(',');
      buf.append("SCORENAME");
      buf.append(',');
      buf.append("TABLEID");
      buf.append(',');
      buf.append("UNIQUEID");
      buf.append(',');
      buf.append("OWNER");
      buf.append(',');
      buf.append("MODTIME");
      buf.append(',');
      buf.append("MODUSER");
      buf.append(',');
      buf.append("ITEMLEADINGTEXT");
      buf.append(',');
      buf.append("ITEMTRAILINGTEXT");
      buf.append(' ');
      return buf.toString();
   }

   protected QueryInfo prepareWhereClause(AssessmentItem bean) {
      StringBuffer buf = new StringBuffer(200);
      QueryInfo qi = new QueryInfo();
      boolean valueSet = false;
      buf.append("WHERE ");
      if (bean.getAssessmentID() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("ASSESSMENTID=?");
         qi.values.add(toBigDecimal(bean.getAssessmentID()));
         valueSet = true;
      }
      if (bean.getScoreName() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("SCORENAME=?");
         qi.values.add(bean.getScoreName());
         valueSet = true;
      }
      if (bean.getTableID() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("TABLEID=?");
         qi.values.add(toBigDecimal(bean.getTableID()));
         valueSet = true;
      }
      if (bean.getUniqueID() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("UNIQUEID=?");
         qi.values.add(toBigDecimal(bean.getUniqueID()));
         valueSet = true;
      }
      if (bean.getOwner() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("OWNER=?");
         qi.values.add(toBigDecimal(bean.getOwner()));
         valueSet = true;
      }
      if (bean.getModTime() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("MODTIME=?");
         qi.values.add(new java.sql.Date(bean.getModTime().getTime()));
         valueSet = true;
      }
      if (bean.getModUser() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("MODUSER=?");
         qi.values.add(toBigDecimal(bean.getModUser()));
         valueSet = true;
      }
      if (bean.getItemLeadingText() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("ITEMLEADINGTEXT=?");
         qi.values.add(bean.getItemLeadingText());
         valueSet = true;
      }
      if (bean.getItemTrailingText() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("ITEMTRAILINGTEXT=?");
         qi.values.add(bean.getItemTrailingText());
         valueSet = true;
      }
      qi.whereClause = (!valueSet) ? "" : buf.toString();
      return qi;
   }

   protected UpdateQueryInfo prepareUpdateQuery(AssessmentItem bean,
         AssessmentItem criteria) throws ValidationException {
      StringBuffer buf = new StringBuffer(200);
      UpdateQueryInfo uqi = new UpdateQueryInfo();
      boolean valueSet = false;
      buf.append("UPDATE NC_ASSESSMENTITEM SET ");

      if (bean.getAssessmentID() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("ASSESSMENTID=? ");
         uqi.setValues.add(toBigDecimal(bean.getAssessmentID()));
         valueSet = true;
      }
      if (bean.getScoreName() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("SCORENAME=? ");
         uqi.setValues.add(bean.getScoreName());
         valueSet = true;
      }
      if (bean.getTableID() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("TABLEID=? ");
         uqi.setValues.add(toBigDecimal(bean.getTableID()));
         valueSet = true;
      }
      if (bean.getUniqueID() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("UNIQUEID=? ");
         uqi.setValues.add(toBigDecimal(bean.getUniqueID()));
         valueSet = true;
      }
      if (bean.getOwner() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("OWNER=? ");
         uqi.setValues.add(toBigDecimal(bean.getOwner()));
         valueSet = true;
      }
      if (bean.getModTime() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("MODTIME=? ");
         uqi.setValues.add(new java.sql.Date(bean.getModTime().getTime()));
         valueSet = true;
      }
      if (bean.getModUser() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("MODUSER=? ");
         uqi.setValues.add(toBigDecimal(bean.getModUser()));
         valueSet = true;
      }
      if (bean.getItemLeadingText() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("ITEMLEADINGTEXT=? ");
         uqi.setValues.add(bean.getItemLeadingText());
         valueSet = true;
      }
      if (bean.getItemTrailingText() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("ITEMTRAILINGTEXT=? ");
         uqi.setValues.add(bean.getItemTrailingText());
         valueSet = true;
      }
      if (!valueSet)
         throw new ValidationException(
               "At least one field needs to be set for update!");

      uqi.query = buf.toString();
      QueryInfo qi = prepareWhereClause(criteria);
      uqi.query += qi.whereClause;
      uqi.whereValues = qi.values;
      return uqi;
   }

   public AssessmentItem createObject(ResultSet rs) throws SQLException {
      AssessmentItem obj = new AssessmentItem();
      obj.setAssessmentID(new Long(rs.getLong(1)));
      obj.setScoreName(rs.getString(2));
      obj.setTableID(new Long(rs.getInt(3)));
      obj.setUniqueID(new Long(rs.getInt(4)));
      obj.setOwner(new Long(rs.getInt(5)));
      obj.setModTime((java.util.Date) rs.getObject(6));
      obj.setModUser(new Long(rs.getInt(7)));
      obj.setItemLeadingText(rs.getString(8));
      obj.setItemTrailingText(rs.getString(9));
      return obj;
   }

   public List<AssessmentItem> find(Connection con, AssessmentItem criteria) throws Exception {

      PreparedStatement ps = null;
      ResultSet rs = null;
      List<AssessmentItem> results = new LinkedList<AssessmentItem>();
      StringBuffer buf = new StringBuffer(200);

      if (criteria == null)
         return null;
      buf.append("SELECT ");
      buf.append(prepareColList(criteria));
      buf.append(" FROM NC_ASSESSMENTITEM ");
      QueryInfo qi = prepareWhereClause(criteria);
      buf.append(qi.whereClause);
      try {
         ps = con.prepareStatement(buf.toString());
         ps.clearParameters();
         int i = 0;
         for (Object element : qi.values) {
            ps.setObject(++i, element);
         }
         rs = ps.executeQuery();
         while (rs.next()) {
            AssessmentItem item = createObject(rs);
            results.add(item);
         }
      } finally {
         if (rs != null)
            try {
               rs.close();
            } catch (Exception x) { /* ignore */}
         if (ps != null)
            try {
               ps.close();
            } catch (Exception x) { /* ignore */}
      }
      return results;
   }

   public void update(Connection con, AssessmentItem bean,
         AssessmentItem criteria) throws Exception {

      PreparedStatement ps = null;

      if (bean == null)
         return;

      UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
      try {
         ps = con.prepareStatement(uqi.query);
         ps.clearParameters();
         int i = 0;
         for (Object element : uqi.setValues) {
            ps.setObject(++i, element);
         }
         // for where part
         for (Object element : uqi.whereValues) {
            ps.setObject(++i, element);
         }
         ps.executeUpdate();
      } finally {
         if (ps != null)
            try {
               ps.close();
            } catch (Exception x) { /* ignore */}
      }
   }

   public void delete(Connection con, AssessmentItem criteria) throws Exception {
      PreparedStatement ps = null;
      StringBuffer buf = new StringBuffer(200);
      buf.append("DELETE FROM NC_ASSESSMENTITEM ");

      QueryInfo qi = prepareWhereClause(criteria);
      buf.append(qi.whereClause);
      try {
         ps = con.prepareStatement(buf.toString());
         ps.clearParameters();
         int i = 0;
         for (Object element : qi.values) {
            ps.setObject(++i, element);
         }
         ps.executeUpdate();

      } finally {
         if (ps != null)
            try {
               ps.close();
            } catch (Exception x) { /* ignore */}
      }
   }

   public static class QueryInfo {
      String whereClause;
      List<? super Object> values = new LinkedList<Object>();

      public QueryInfo() {}

      public QueryInfo(String whereClause) {
         this.whereClause = whereClause;
      }
   }

   public static class UpdateQueryInfo {
      String query;
      List<? super Object> setValues = new LinkedList<Object>();
      List<? super Object> whereValues = new LinkedList<Object>();

      public UpdateQueryInfo() {}
   }

}