package caslayout.ui.db.oracle;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

import caslayout.exception.ValidationException;
import caslayout.ui.db.AssessmentScore;
import caslayout.ui.db.IAssessmentScoreDAO;

public class AssessmentScoreDAO implements IAssessmentScoreDAO {

   public AssessmentScoreDAO() {}

   public void insert(Connection con, AssessmentScore bean) throws Exception {
      PreparedStatement ps = null;
      StringBuffer buf = new StringBuffer(200);

      if (bean == null)
         return;
      try {
         buf.append("INSERT INTO NC_ASSESSMENTSCORE ");
         buf
               .append(" (ASSESSMENTID,SCORENAME,SCORESEQUENCE,SCORETYPE,TABLEID,UNIQUEID,OWNER,MODTIME,MODUSER,DEFAULTVALUE,NULLABLE,SCORELEVEL,PARENTASID,PARENTSCORE,ASSESSMENTONTOLOGY,ASSESSMENTCONCEPT,SECURITYCLASSIFICATION,MINANSWERS,MAXANSWERS,ISREQUIRED,ISEXCLUDED,ISNEW,ISMODIFIED,DESCRIPTION) ");
         buf.append("VALUES ");
         buf.append('(');
         for (int i = 0; i < 24; ++i) {
            buf.append('?');
            if (i < 23)
               buf.append(',');
         }
         buf.append(")");
         System.out.println("query=" + buf.toString());
         System.out.println("Assessmet score bean - " + bean.toString());

         ps = con.prepareStatement(buf.toString());
         ps.clearParameters();
         ps.setObject(1, toBigDecimal(bean.getAssessmentID()), Types.NUMERIC);
         ps.setObject(2, bean.getScoreName(), Types.VARCHAR);
         ps.setObject(3, toBigDecimal(bean.getScoreSequence()), Types.NUMERIC);
         ps.setObject(4, bean.getScoreType(), Types.VARCHAR);
         ps.setObject(5, toBigDecimal(bean.getTableID()), Types.NUMERIC);
         ps.setObject(6, toBigDecimal(bean.getUniqueID()), Types.NUMERIC);
         ps.setObject(7, toBigDecimal(bean.getOwner()), Types.NUMERIC);
         ps.setObject(8, new java.sql.Date(bean.getModTime().getTime()));
         ps.setObject(9, toBigDecimal(bean.getModUser()), Types.NUMERIC);
         ps.setObject(10, bean.getDefaultValue(), Types.VARCHAR);
         ps
               .setObject(
                     11,
                     bean.getNullable().booleanValue() ? new java.math.BigDecimal(
                           "1")
                           : new java.math.BigDecimal("0"));

         ps.setObject(12, toBigDecimal(bean.getScoreLevel()), Types.NUMERIC);
         ps.setObject(13, toBigDecimal(bean.getParentAsID()), Types.NUMERIC);
         ps.setObject(14, bean.getParentScore(), Types.VARCHAR);
         ps.setObject(15, bean.getAssessmentOntology(), Types.VARCHAR);
         ps.setObject(16, bean.getAssessmentConcept(), Types.VARCHAR);
         ps.setObject(17, bean.getSecurityClassification(), Types.VARCHAR);

         ps.setObject(18, toBigDecimal(bean.getMinAnswers()), Types.NUMERIC);
         ps.setObject(19, toBigDecimal(bean.getMaxAnswers()), Types.NUMERIC);
         ps.setObject(20, boolean2Number(bean.getIsRequired()));
         ps.setObject(21, boolean2Number(bean.getIsExcluded()));
         ps.setObject(22, boolean2Number(bean.getIsNew()));
         ps.setObject(23, boolean2Number(bean.getIsModified()));
         ps.setObject(24, OracleUtils.getCLOB(con, bean.getDescription()),
               Types.CLOB);

         ps.executeUpdate();

      } finally {
         if (ps != null)
            try {
               ps.close();
            } catch (Exception x) { /* ignore */
            }
      }
   }

   protected BigDecimal toBigDecimal(Long value) {
      return new BigDecimal(value.toString());
   }

   protected BigDecimal boolean2Number(Boolean value) {
      if (value == null) {
         // use default (false )
         /**
          * @todo null boolean values are not allowed need to be explicitly
          *       specified
          */
         return new java.math.BigDecimal("0");
      }
      return ((Boolean) value).booleanValue() ? new java.math.BigDecimal("1")
            : new java.math.BigDecimal("0");
   }

   protected String prepareColList(AssessmentScore bean) {
      StringBuffer buf = new StringBuffer(200);
      buf.append("ASSESSMENTID");
      buf.append(',');
      buf.append("SCORENAME");
      buf.append(',');
      buf.append("SCORESEQUENCE");
      buf.append(',');
      buf.append("SCORETYPE");
      buf.append(',');
      buf.append("TABLEID");
      buf.append(',');
      buf.append("UNIQUEID");
      buf.append(',');
      buf.append("OWNER");
      buf.append(',');
      buf.append("MODTIME");
      buf.append(',');
      buf.append("MODUSER");
      buf.append(',');
      buf.append("DEFAULTVALUE");
      buf.append(',');
      buf.append("NULLABLE");
      buf.append(',');
      buf.append("SCORELEVEL");
      buf.append(',');
      buf.append("PARENTASID");
      buf.append(',');
      buf.append("PARENTSCORE");
      buf.append(',');
      buf.append("ASSESSMENTONTOLOGY");
      buf.append(',');
      buf.append("ASSESSMENTCONCEPT");
      buf.append(',');
      buf.append("SECURITYCLASSIFICATION");
      buf.append(',');
      buf.append("MINANSWERS");
      buf.append(',');
      buf.append("MAXANSWERS");
      buf.append(',');
      buf.append("ISREQUIRED");
      buf.append(',');
      buf.append("ISEXCLUDED");
      buf.append(',');
      buf.append("ISNEW");
      buf.append(',');
      buf.append("ISMODIFIED");
      buf.append(',');
      buf.append("DESCRIPTION");

      buf.append(' ');
      return buf.toString();
   }

   protected BigDecimal toBigDecimal(int value) {
      return new BigDecimal(String.valueOf(value));
   }

   protected BigDecimal toBigDecimal(Integer value) {
      if (value == null)
         return null;
      return new BigDecimal(String.valueOf(value.intValue()));
   }

   protected QueryInfo prepareWhereClause(AssessmentScore bean) {
      StringBuffer buf = new StringBuffer(200);
      QueryInfo qi = new QueryInfo();
      boolean valueSet = false;
      buf.append("WHERE ");

      if (bean.getAssessmentID() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("ASSESSMENTID=?");
         qi.values.add(toBigDecimal(bean.getAssessmentID()));
         valueSet = true;
      }
      if (bean.getScoreName() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("SCORENAME=?");
         qi.values.add(bean.getScoreName());
         valueSet = true;
      }
      if (bean.getScoreSequence() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("SCORESEQUENCE=?");
         qi.values.add(toBigDecimal(bean.getScoreSequence()));
         valueSet = true;
      }
      if (bean.getScoreType() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("SCORETYPE=?");
         qi.values.add(bean.getScoreType());
         valueSet = true;
      }
      if (bean.getTableID() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("TABLEID=?");
         qi.values.add(toBigDecimal(bean.getTableID()));
         valueSet = true;
      }
      if (bean.getUniqueID() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("UNIQUEID=?");
         qi.values.add(toBigDecimal(bean.getUniqueID()));
         valueSet = true;
      }
      if (bean.getOwner() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("OWNER=?");
         qi.values.add(toBigDecimal(bean.getOwner()));
         valueSet = true;
      }
      if (bean.getModTime() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("MODTIME=?");
         qi.values.add(new java.sql.Date(bean.getModTime().getTime()));
         valueSet = true;
      }
      if (bean.getModUser() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("MODUSER=?");
         qi.values.add(toBigDecimal(bean.getModUser()));
         valueSet = true;
      }
      if (bean.getDefaultValue() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("DEFAULTVALUE=?");
         qi.values.add(bean.getDefaultValue());
         valueSet = true;
      }
      if (bean.getNullable() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("NULLABLE=?");
         qi.values
               .add(bean.getNullable().booleanValue() ? new java.math.BigDecimal(
                     "1")
                     : new java.math.BigDecimal("0"));
         valueSet = true;
      }
      if (bean.getScoreLevel() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("SCORELEVEL=?");
         qi.values.add(toBigDecimal(bean.getScoreLevel()));
         valueSet = true;
      }
      if (bean.getParentAsID() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("PARENTASID=?");
         qi.values.add(toBigDecimal(bean.getParentAsID().intValue()));
         valueSet = true;
      }
      if (bean.getParentScore() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("PARENTSCORE=?");
         qi.values.add(bean.getParentScore());
         valueSet = true;
      }
      if (bean.getAssessmentOntology() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("ASSESSMENTONTOLOGY=?");
         qi.values.add(bean.getAssessmentOntology());
         valueSet = true;
      }
      if (bean.getAssessmentConcept() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("ASSESSMENTCONCEPT=?");
         qi.values.add(bean.getAssessmentConcept());
         valueSet = true;
      }
      if (bean.getSecurityClassification() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("SECURITYCLASSIFICATION=?");
         qi.values.add(bean.getSecurityClassification());
         valueSet = true;
      }

      if (bean.getMinAnswers() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("MINANSWERS=?");
         qi.values.add(toBigDecimal(bean.getMinAnswers()));
         valueSet = true;
      }
      if (bean.getMaxAnswers() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("MAXANSWERS=?");
         qi.values.add(toBigDecimal(bean.getMaxAnswers()));
         valueSet = true;
      }
      if (bean.getIsRequired() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("ISREQUIRED=?");
         qi.values.add(boolean2Number(bean.getIsRequired()));
         valueSet = true;
      }
      if (bean.getIsExcluded() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("ISEXCLUDED=?");
         qi.values.add(boolean2Number(bean.getIsExcluded()));
         valueSet = true;
      }
      if (bean.getIsNew() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("ISNEW=?");
         qi.values.add(boolean2Number(bean.getIsNew()));
         valueSet = true;
      }
      if (bean.getIsModified() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("ISMODIFIED=?");
         qi.values.add(boolean2Number(bean.getIsModified()));
         valueSet = true;
      }
      if (bean.getDescription() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("DESCRIPTION=?");
         qi.values.add(bean.getDescription());
         valueSet = true;
      }

      qi.whereClause = (!valueSet) ? "" : buf.toString();
      return qi;
   }

   protected UpdateQueryInfo prepareUpdateQuery(AssessmentScore bean,
         AssessmentScore criteria) throws ValidationException {
      StringBuffer buf = new StringBuffer(200);
      UpdateQueryInfo uqi = new UpdateQueryInfo();
      boolean valueSet = false;
      buf.append("UPDATE NC_ASSESSMENTSCORE SET ");

      if (bean.getAssessmentID() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("ASSESSMENTID=? ");
         uqi.setValues.add(toBigDecimal(bean.getAssessmentID()));
         valueSet = true;
      }
      if (bean.getScoreName() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("SCORENAME=? ");
         uqi.setValues.add(bean.getScoreName());
         valueSet = true;
      }
      if (bean.getScoreSequence() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("SCORESEQUENCE=? ");
         uqi.setValues.add(toBigDecimal(bean.getScoreSequence()));
         valueSet = true;
      }
      if (bean.getScoreType() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("SCORETYPE=? ");
         uqi.setValues.add(bean.getScoreType());
         valueSet = true;
      }
      if (bean.getTableID() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("TABLEID=? ");
         uqi.setValues.add(toBigDecimal(bean.getTableID()));
         valueSet = true;
      }
      if (bean.getUniqueID() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("UNIQUEID=? ");
         uqi.setValues.add(toBigDecimal(bean.getUniqueID()));
         valueSet = true;
      }
      if (bean.getOwner() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("OWNER=? ");
         uqi.setValues.add(toBigDecimal(bean.getOwner()));
         valueSet = true;
      }
      if (bean.getModTime() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("MODTIME=? ");
         uqi.setValues.add(new java.sql.Date(bean.getModTime().getTime()));
         valueSet = true;
      }
      if (bean.getModUser() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("MODUSER=? ");
         uqi.setValues.add(toBigDecimal(bean.getModUser()));
         valueSet = true;
      }
      if (bean.getDefaultValue() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("DEFAULTVALUE=? ");
         uqi.setValues.add(bean.getDefaultValue());
         valueSet = true;
      }
      if (bean.getNullable() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("NULLABLE=? ");
         uqi.setValues
               .add(bean.getNullable().booleanValue() ? new java.math.BigDecimal(
                     "1")
                     : new java.math.BigDecimal("0"));
         valueSet = true;
      }
      if (bean.getScoreLevel() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("SCORELEVEL=? ");
         uqi.setValues.add(toBigDecimal(bean.getScoreLevel()));
         valueSet = true;
      }

      if (bean.getParentAsID() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("PARENTASID=? ");
         uqi.setValues.add(toBigDecimal(bean.getParentAsID().intValue()));
         valueSet = true;
      }
      if (bean.getParentScore() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("PARENTSCORE=? ");
         uqi.setValues.add(bean.getParentScore());
         valueSet = true;
      }
      if (bean.getAssessmentOntology() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("ASSESSMENTONTOLOGY=? ");
         uqi.setValues.add(bean.getAssessmentOntology());
         valueSet = true;
      }
      if (bean.getAssessmentConcept() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("ASSESSMENTCONCEPT=? ");
         uqi.setValues.add(bean.getAssessmentConcept());
         valueSet = true;
      }
      if (bean.getSecurityClassification() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("SECURITYCLASSIFICATION=? ");
         uqi.setValues.add(bean.getSecurityClassification());
         valueSet = true;
      }

      if (bean.getMinAnswers() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("MINANSWERS=? ");
         uqi.setValues.add(toBigDecimal(bean.getMinAnswers()));
         valueSet = true;
      }
      if (bean.getMaxAnswers() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("MAXANSWERS=? ");
         uqi.setValues.add(toBigDecimal(bean.getMaxAnswers()));
         valueSet = true;
      }

      if (bean.getIsRequired() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("ISREQUIRED=? ");
         uqi.setValues.add(boolean2Number(bean.getIsRequired()));
         valueSet = true;
      }

      if (bean.getIsExcluded() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("ISEXCLUDED=? ");
         uqi.setValues.add(boolean2Number(bean.getIsExcluded()));
         valueSet = true;
      }

      if (bean.getIsNew() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("ISNEW=? ");
         uqi.setValues.add(boolean2Number(bean.getIsNew()));
         valueSet = true;
      }

      if (bean.getIsModified() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("ISMODIFIED=? ");
         uqi.setValues.add(boolean2Number(bean.getIsModified()));
         valueSet = true;
      }

      if (bean.getDescription() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("DESCRIPTION=? ");
         uqi.setValues.add(bean.getDescription());
         valueSet = true;
      }

      if (!valueSet)
         throw new ValidationException(
               "At least one field needs to be set for update!");

      uqi.query = buf.toString();
      QueryInfo qi = prepareWhereClause(criteria);
      uqi.query += qi.whereClause;
      uqi.whereValues = qi.values;
      return uqi;
   }

   protected Boolean convert2Boolean(Object columnValue) {
      if (columnValue == null)
         return null;
      return ((java.math.BigDecimal) columnValue).intValue() > 0 ? new Boolean(
            true) : new Boolean(false);
   }

   public AssessmentScore createObject(ResultSet rs) throws SQLException {
      AssessmentScore obj = new AssessmentScore(new Long(
            ((java.math.BigDecimal) rs.getObject(1)).longValue()),

      (String) rs.getObject(2));

      obj.setScoreSequence(new Integer(rs.getInt(3)));
      obj.setScoreType((String) rs.getObject(4));
      obj.setTableID(new Long(rs.getInt(5)));
      obj.setUniqueID(new Long(rs.getInt(6)));
      obj.setOwner(new Long(rs.getInt(7)));
      obj.setModTime((java.util.Date) rs.getObject(8));
      obj.setModUser(new Long(rs.getInt(9)));
      obj.setDefaultValue((String) rs.getObject(10));
      // TODO boolean
      obj.setNullable(new Boolean(rs.getInt(11) > 0));
      obj.setScoreLevel(new Integer(rs.getInt(12)));
      obj.setParentAsID(new Long(rs.getLong(13)));
      obj.setParentScore((String) rs.getObject(14));
      obj.setAssessmentOntology((String) rs.getObject(15));
      obj.setAssessmentConcept((String) rs.getObject(16));
      obj.setSecurityClassification((String) rs.getObject(17));

      obj.setMinAnswers(new Integer(rs.getInt(18)));
      obj.setMaxAnswers(new Integer(rs.getInt(19)));
      obj.setIsRequired(convert2Boolean(rs.getObject(20)));
      obj.setIsExcluded(convert2Boolean(rs.getObject(21)));
      obj.setIsNew(convert2Boolean(rs.getObject(22)));
      obj.setIsModified(convert2Boolean(rs.getObject(23)));
      obj.setDescription(OracleUtils.readCLOB((oracle.sql.CLOB) rs
            .getObject(24)));

      return obj;
   }

   public List<AssessmentScore> find(Connection con, AssessmentScore criteria) throws Exception {

      PreparedStatement ps = null;
      ResultSet rs = null;
      List<AssessmentScore> results = new LinkedList<AssessmentScore>();
      StringBuffer buf = new StringBuffer(200);

      if (criteria == null)
         return null;
      buf.append("SELECT ");
      buf.append(prepareColList(criteria));
      buf.append(" FROM NC_ASSESSMENTSCORE ");
      QueryInfo qi = prepareWhereClause(criteria);
      buf.append(qi.whereClause);
      try {
         ps = con.prepareStatement(buf.toString());
         ps.clearParameters();
         int i = 0;
         for (Object element : qi.values) {
            ps.setObject(++i, element);
         }
         rs = ps.executeQuery();
         while (rs.next()) {
            AssessmentScore item = createObject(rs);
            results.add(item);
         }

         Map<String,AssessmentScore> scoreMap = new HashMap<String, AssessmentScore>();
         for (Iterator<AssessmentScore> iter = results.iterator(); iter.hasNext();) {
            AssessmentScore as = iter.next();
            scoreMap.put(as.getScoreName(), as);
         }
         for (Iterator<AssessmentScore> iter = results.iterator(); iter.hasNext();) {
            AssessmentScore as = iter.next();
            if (as.getParentScore() == null)
               continue;
            AssessmentScore parent = scoreMap.get(as
                  .getParentScore());
            as.setParent(parent);
         }

      } finally {
         if (rs != null)
            try {
               rs.close();
            } catch (Exception x) { /* ignore */
            }
         if (ps != null)
            try {
               ps.close();
            } catch (Exception x) { /* ignore */
            }
      }
      return results;
   }

   public void update(Connection con, AssessmentScore bean,
         AssessmentScore criteria) throws Exception {

      PreparedStatement ps = null;

      if (bean == null)
         return;

      UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
      try {
         ps = con.prepareStatement(uqi.query);
         ps.clearParameters();
         int i = 0;
         for (Object element : uqi.setValues) {
            ps.setObject(++i, element);
         }
         // for where part
         for (Object element : uqi.whereValues) {
            ps.setObject(++i, element);
         }
         ps.executeUpdate();
      } finally {
         if (ps != null)
            try {
               ps.close();
            } catch (Exception x) { /* ignore */
            }
      }
   }

   public void delete(Connection con, AssessmentScore criteria)
         throws Exception {
      PreparedStatement ps = null;
      StringBuffer buf = new StringBuffer(200);
      buf.append("DELETE FROM NC_ASSESSMENTSCORE ");

      QueryInfo qi = prepareWhereClause(criteria);
      buf.append(qi.whereClause);
      try {
         ps = con.prepareStatement(buf.toString());
         ps.clearParameters();
         int i = 0;
         for (Object element : qi.values) {
            ps.setObject(++i, element);
         }
         ps.executeUpdate();

      } finally {
         if (ps != null)
            try {
               ps.close();
            } catch (Exception x) { /* ignore */
            }
      }
   }

   public static class QueryInfo {
      String whereClause;
      List<? super Object> values = new LinkedList<Object>();

      public QueryInfo() {}

      public QueryInfo(String whereClause) {
         this.whereClause = whereClause;
      }
   }

   public static class UpdateQueryInfo {
      String query;
      List<? super Object> setValues = new LinkedList<Object>();
      List<? super Object> whereValues = new LinkedList<Object>();

      public UpdateQueryInfo() {}
   }

   /* +++ */
   // Enter your code here
   /* +++ */
}// ;

