package caslayout.ui.db.oracle;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import caslayout.ui.db.AbstractCommonQueryHelper;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: CommonQueryHelper.java,v 1.6 2007/10/08 18:00:42 bozyurt Exp $
 */

public class CommonQueryHelper extends AbstractCommonQueryHelper {

	public CommonQueryHelper() {
		super();
	}

	public int getNextSequenceNumber(Connection con) throws SQLException {
		Statement st = null;
		try {
			st = con.createStatement();
			ResultSet rs = st.executeQuery("select uid_seq.nextval from dual");
			if (rs.next()) {
				return rs.getInt(1);
			}
			rs.close();
		} finally {
			if (st != null)
				try {
					st.close();
				} catch (Exception x) {
				}
		}
		return -1;
	}

}
