package caslayout.ui.db.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.LinkedList;
import java.util.List;

import caslayout.exception.ValidationException;
import caslayout.ui.db.Assessment;
import caslayout.ui.db.DBUtils;
import caslayout.ui.db.IAssessmentDAO;

public class AssessmentDAO implements IAssessmentDAO {

	public AssessmentDAO() {
	}

	public void insert(Connection con, Assessment bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_ASSESSMENT ");
			buf
					.append(" (ASSESSMENTID,TABLEID,OWNER,MODTIME,MODUSER,NAME,DESCRIPTION,UNIQUEID,PREVIOUSASSESSMENTID) ");
			buf.append("VALUES ");

			buf.append('(');

			for (int i = 0; i < 9; ++i) {
				buf.append('?');
				if (i < 8)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, DBUtils.toBigDecimal(bean.getID()), Types.NUMERIC);
			ps.setObject(2, DBUtils.toBigDecimal(bean.getTableID()),
					Types.NUMERIC);
			ps.setObject(3, DBUtils.toBigDecimal(bean.getOwner()),
					Types.NUMERIC);
			ps.setObject(4, new java.sql.Date(bean.getModTime().getTime()));
			ps.setObject(5, DBUtils.toBigDecimal(bean.getModUser()),
					Types.NUMERIC);
			ps.setObject(6, bean.getName(), Types.VARCHAR);
			ps.setObject(7, bean.getDescription(), Types.CLOB);
			ps.setObject(8, DBUtils.toBigDecimal(bean.getUniqueID()),
					Types.NUMERIC);
			ps.setObject(9, bean.getPreviousAssessmentID() != null ? DBUtils
					.toBigDecimal(bean.getPreviousAssessmentID().intValue())
					: null, Types.NUMERIC);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(Assessment bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("ASSESSMENTID");
		buf.append(',');
		buf.append("TABLEID");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MODTIME");
		buf.append(',');
		buf.append("MODUSER");
		buf.append(',');
		buf.append("NAME");
		buf.append(',');
		buf.append("DESCRIPTION");
		buf.append(',');
		buf.append("UNIQUEID");
		buf.append(',');
		buf.append("PREVIOUSASSESSMENTID");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Assessment bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getID() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ASSESSMENTID=?");
			qi.values.add(DBUtils.toBigDecimal(bean.getID()));
			valueSet = true;
		}
		if (bean.getTableID() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TABLEID=?");
			qi.values.add(DBUtils.toBigDecimal(bean.getTableID()));
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(DBUtils.toBigDecimal(bean.getOwner()));
			valueSet = true;
		}
		if (bean.getModTime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODTIME=?");
			qi.values.add(new java.sql.Date(bean.getModTime().getTime()));
			valueSet = true;
		}
		if (bean.getModUser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODUSER=?");
			qi.values.add(DBUtils.toBigDecimal(bean.getModUser()));
			valueSet = true;
		}
		if (bean.getName() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("NAME=?");
			qi.values.add(bean.getName());
			valueSet = true;
		}
		if (bean.getDescription() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("DESCRIPTION=?");
			qi.values.add(bean.getDescription());
			valueSet = true;
		}

		if (bean.getUniqueID() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UNIQUEID=?");
			qi.values.add(DBUtils.toBigDecimal(bean.getUniqueID()));
			valueSet = true;
		}
		if (bean.getPreviousAssessmentID() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("PREVIOUSASSESSMENTID=?");
			qi.values.add(DBUtils.toBigDecimal(bean.getPreviousAssessmentID()
					.intValue()));
			valueSet = true;
		}

		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Assessment bean,
			Assessment criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_ASSESSMENT SET ");

		if (bean.getID() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("ASSESSMENTID=? ");
			uqi.setValues.add(DBUtils.toBigDecimal(bean.getID()));
			valueSet = true;
		}
		if (bean.getTableID() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("TABLEID=? ");
			uqi.setValues.add(DBUtils.toBigDecimal(bean.getTableID()));
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(DBUtils.toBigDecimal(bean.getOwner()));
			valueSet = true;
		}
		if (bean.getModTime() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODTIME=? ");
			uqi.setValues.add(new java.sql.Date(bean.getModTime().getTime()));
			valueSet = true;
		}
		if (bean.getModUser() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODUSER=? ");
			uqi.setValues.add(DBUtils.toBigDecimal(bean.getModUser()));
			valueSet = true;
		}
		if (bean.getName() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("NAME=? ");
			uqi.setValues.add(bean.getName());
			valueSet = true;
		}
		if (bean.getDescription() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("DESCRIPTION=? ");
			uqi.setValues.add(bean.getDescription());
			valueSet = true;
		}

		if (bean.getUniqueID() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("UNIQUEID=? ");
			uqi.setValues.add(DBUtils.toBigDecimal(bean.getUniqueID()));
			valueSet = true;
		}
		if (bean.getPreviousAssessmentID() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("PREVIOUSASSESSMENTID=? ");
			uqi.setValues.add(DBUtils.toBigDecimal(bean
					.getPreviousAssessmentID().intValue()));
			valueSet = true;
		}

		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	public Assessment createObject(ResultSet rs) throws SQLException {
		Assessment obj = new Assessment(new Long(rs.getLong(1)), rs
				.getString(6));
		obj.setTableID( new Long( rs.getLong(2) ));
		obj.setOwner( new Long(rs.getLong(3) ));
		obj.setModTime((java.util.Date) rs.getObject(4));
		obj.setModUser( new Long(rs.getLong(5)));
		// obj.setName( (String ) rs.getObject(6) );
		obj.setDescription((String) rs.getObject(7));
		obj.setUniqueID( new Long(rs.getInt(8)) );
		int prevAsID = rs.getInt(9);
		if (!rs.wasNull()) {
			obj.setPreviousAssessmentID(new Long(prevAsID));
		}
		return obj;
	}

	public List<Assessment> find(Connection con, Assessment criteria) throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Assessment> results = new LinkedList<Assessment>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_ASSESSMENT ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Object element : qi.values) {
				ps.setObject(++i, element);
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Assessment item = createObject(rs);
				results.add(item);
			}
		} finally {
			if (rs != null)
				try {
					rs.close();
				} catch (Exception x) { /* ignore */
				}
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
		return results;
	}

	public void update(Connection con, Assessment bean, Assessment criteria)
			throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			for (Object element : uqi.setValues) {
				ps.setObject(++i, element);
			}
			// for where part
			for (Object element : uqi.whereValues) {
				ps.setObject(++i, element);
			}
			ps.executeUpdate();
		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	public void delete(Connection con, Assessment criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_ASSESSMENT ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Object element : qi.values) {
				ps.setObject(++i, element);
			}
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

}// ;

