package caslayout.ui.db.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.LinkedList;
import java.util.List;

import caslayout.exception.ValidationException;
import caslayout.ui.db.AssessmentScoreCode;
import caslayout.ui.db.DBUtils;
import caslayout.ui.db.IAssessmentScoreCodeDAO;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentScoreCodeDAO.java,v 1.4 2005/09/09 01:30:26 bozyurt
 *          Exp $
 */
public class AssessmentScoreCodeDAO implements IAssessmentScoreCodeDAO {

   public AssessmentScoreCodeDAO() {}

   public void insert(Connection con, AssessmentScoreCode bean)
         throws Exception {
      PreparedStatement ps = null;
      StringBuffer buf = new StringBuffer(200);

      if (bean == null)
         return;
      try {
         buf.append("INSERT INTO NC_ASSESSMENTSCORECODE ");
         buf
               .append(" (ASSESSMENTID,SCORENAME,SCORECODE,TABLEID,UNIQUEID,OWNER,MODTIME,MODUSER,SCORECODEVALUE,SCORECODETYPE,DESCRIPTION,ONTOLOGYSOURCE,CONCEPTID,SCORECODELABEL) ");
         buf.append("VALUES ");
         buf.append('(');
         for (int i = 0; i < 14; ++i) {
            buf.append('?');
            if (i < 13)
               buf.append(',');
         }
         buf.append(")");
         ps = con.prepareStatement(buf.toString());
         ps.clearParameters();
         ps.setObject(1, DBUtils.toBigDecimal(bean.getAssessmentID()),
               Types.NUMERIC);
         ps.setObject(2, bean.getScoreName(), Types.VARCHAR);
         ps.setObject(3, bean.getScoreCode(), Types.VARCHAR);
         ps
               .setObject(4, DBUtils.toBigDecimal(bean.getTableID()),
                     Types.NUMERIC);
         ps.setObject(5, DBUtils.toBigDecimal(bean.getUniqueID()),
               Types.NUMERIC);
         ps.setObject(6, DBUtils.toBigDecimal(bean.getOwner()), Types.NUMERIC);
         ps.setObject(7, new java.sql.Date(bean.getModTime().getTime()));
         ps
               .setObject(8, DBUtils.toBigDecimal(bean.getModUser()),
                     Types.NUMERIC);
         ps.setObject(9, bean.getScoreCodeValue(), Types.VARCHAR);
         ps.setObject(10, bean.getScoreCodeType(), Types.VARCHAR);
         ps.setObject(11, bean.getDescription(), Types.VARCHAR);
         ps.setObject(12, bean.getOntologySource(), Types.VARCHAR);
         ps.setObject(13, bean.getConceptID(), Types.VARCHAR);
         ps.setObject(14, bean.getScoreCodeLabel(), Types.VARCHAR);
         ps.executeUpdate();

      } finally {
         if (ps != null)
            try {
               ps.close();
            } catch (Exception x) { /* ignore */
            }
      }
   }

   protected String prepareColList(AssessmentScoreCode bean) {
      StringBuffer buf = new StringBuffer(200);
      buf.append("ASSESSMENTID");
      buf.append(',');
      buf.append("SCORENAME");
      buf.append(',');
      buf.append("SCORECODE");
      buf.append(',');
      buf.append("TABLEID");
      buf.append(',');
      buf.append("UNIQUEID");
      buf.append(',');
      buf.append("OWNER");
      buf.append(',');
      buf.append("MODTIME");
      buf.append(',');
      buf.append("MODUSER");
      buf.append(',');
      buf.append("SCORECODEVALUE");
      buf.append(',');
      buf.append("SCORECODETYPE");
      buf.append(',');
      buf.append("DESCRIPTION");
      buf.append(',');
      buf.append("ONTOLOGYSOURCE");
      buf.append(',');
      buf.append("CONCEPTID");
      buf.append(',');
      buf.append("\"SCORECODELABEL\"");

      buf.append(' ');
      return buf.toString();
   }

   protected QueryInfo prepareWhereClause(AssessmentScoreCode bean) {
      StringBuffer buf = new StringBuffer(200);
      QueryInfo qi = new QueryInfo();
      boolean valueSet = false;
      buf.append("WHERE ");

      if (bean.getAssessmentID() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("ASSESSMENTID=?");
         qi.values.add(DBUtils.toBigDecimal(bean.getAssessmentID()));
         valueSet = true;
      }
      if (bean.getScoreName() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("SCORENAME=?");
         qi.values.add(bean.getScoreName());
         valueSet = true;
      }
      if (bean.getScoreCode() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("SCORECODE=?");
         qi.values.add(bean.getScoreCode());
         valueSet = true;
      }
      if (bean.getTableID() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("TABLEID=?");
         qi.values.add(DBUtils.toBigDecimal(bean.getTableID()));
         valueSet = true;
      }
      if (bean.getUniqueID() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("UNIQUEID=?");
         qi.values.add(DBUtils.toBigDecimal(bean.getUniqueID()));
         valueSet = true;
      }
      if (bean.getOwner() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("OWNER=?");
         qi.values.add(DBUtils.toBigDecimal(bean.getOwner()));
         valueSet = true;
      }
      if (bean.getModTime() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("MODTIME=?");
         qi.values.add(new java.sql.Date(bean.getModTime().getTime()));
         valueSet = true;
      }
      if (bean.getModUser() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("MODUSER=?");
         qi.values.add(DBUtils.toBigDecimal(bean.getModUser()));
         valueSet = true;
      }
      if (bean.getScoreCodeValue() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("SCORECODEVALUE=?");
         qi.values.add(bean.getScoreCodeValue());
         valueSet = true;
      }
      if (bean.getScoreCodeType() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("SCORECODETYPE=?");
         qi.values.add(bean.getScoreCodeType());
         valueSet = true;
      }
      if (bean.getDescription() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("DESCRIPTION=?");
         qi.values.add(bean.getDescription());
         valueSet = true;
      }
      if (bean.getOntologySource() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("ONTOLOGYSOURCE=?");
         qi.values.add(bean.getOntologySource());
         valueSet = true;
      }
      if (bean.getConceptID() != null) {
         if (valueSet)
            buf.append(" AND ");
         buf.append("CONCEPTID=?");
         qi.values.add(bean.getConceptID());
         valueSet = true;
      }

      if (bean.getScoreCodeLabel() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("\"SCORECODELABEL\"=? ");
         qi.values.add(bean.getScoreCodeLabel());
         valueSet = true;
      }

      qi.whereClause = (!valueSet) ? "" : buf.toString();
      return qi;
   }

   protected UpdateQueryInfo prepareUpdateQuery(AssessmentScoreCode bean,
         AssessmentScoreCode criteria) throws ValidationException {
      StringBuffer buf = new StringBuffer(200);
      UpdateQueryInfo uqi = new UpdateQueryInfo();
      boolean valueSet = false;
      buf.append("UPDATE NC_ASSESSMENTSCORECODE SET ");

      if (bean.getAssessmentID() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("ASSESSMENTID=? ");
         uqi.setValues.add(DBUtils.toBigDecimal(bean.getAssessmentID()));
         valueSet = true;
      }
      if (bean.getScoreName() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("SCORENAME=? ");
         uqi.setValues.add(bean.getScoreName());
         valueSet = true;
      }
      if (bean.getScoreCode() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("SCORECODE=? ");
         uqi.setValues.add(bean.getScoreCode());
         valueSet = true;
      }
      if (bean.getTableID() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("TABLEID=? ");
         uqi.setValues.add(DBUtils.toBigDecimal(bean.getTableID()));
         valueSet = true;
      }
      if (bean.getUniqueID() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("UNIQUEID=? ");
         uqi.setValues.add(DBUtils.toBigDecimal(bean.getUniqueID()));
         valueSet = true;
      }
      if (bean.getOwner() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("OWNER=? ");
         uqi.setValues.add(DBUtils.toBigDecimal(bean.getOwner()));
         valueSet = true;
      }
      if (bean.getModTime() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("MODTIME=? ");
         uqi.setValues.add(new java.sql.Date(bean.getModTime().getTime()));
         valueSet = true;
      }
      if (bean.getModUser() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("MODUSER=? ");
         uqi.setValues.add(DBUtils.toBigDecimal(bean.getModUser()));
         valueSet = true;
      }
      if (bean.getScoreCodeValue() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("SCORECODEVALUE=? ");
         uqi.setValues.add(bean.getScoreCodeValue());
         valueSet = true;
      }
      if (bean.getScoreCodeType() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("SCORECODETYPE=? ");
         uqi.setValues.add(bean.getScoreCodeType());
         valueSet = true;
      }

      if (bean.getDescription() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("DESCRIPTION=? ");
         uqi.setValues.add(bean.getDescription());
         valueSet = true;
      }
      if (bean.getOntologySource() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("ONTOLOGYSOURCE=? ");
         uqi.setValues.add(bean.getOntologySource());
         valueSet = true;
      }
      if (bean.getConceptID() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("CONCEPTID=? ");
         uqi.setValues.add(bean.getConceptID());
         valueSet = true;
      }
      if (bean.getScoreCodeLabel() != null) {
         if (valueSet)
            buf.append(", ");
         buf.append("\"SCORECODELABEL\"=? ");
         uqi.setValues.add(bean.getScoreCodeLabel());
         valueSet = true;
      }

      if (!valueSet)
         throw new ValidationException(
               "At least one field needs to be set for update!");

      uqi.query = buf.toString();
      QueryInfo qi = prepareWhereClause(criteria);
      uqi.query += qi.whereClause;
      uqi.whereValues = qi.values;
      return uqi;
   }

   public AssessmentScoreCode createObject(ResultSet rs) throws SQLException {
      AssessmentScoreCode obj = new AssessmentScoreCode();
      obj.setAssessmentID(new Long(rs.getLong(1)));
      obj.setScoreName((String) rs.getObject(2));
      obj.setScoreCode((String) rs.getObject(3));
      obj.setTableID(new Long(rs.getInt(4)));
      obj.setUniqueID(new Long(rs.getInt(5)));
      obj.setOwner(new Long(rs.getInt(6)));
      obj.setModTime((java.util.Date) rs.getObject(7));
      obj.setModUser(new Long(rs.getInt(8)));
      obj.setScoreCodeValue((String) rs.getObject(9));
      obj.setScoreCodeType((String) rs.getObject(10));
      obj.setDescription((String) rs.getObject(11));
      obj.setOntologySource((String) rs.getObject(12));
      obj.setConceptID((String) rs.getObject(13));
      obj.setScoreCodeLabel((String) rs.getObject(14));

      return obj;
   }

   public List<AssessmentScoreCode> find(Connection con, AssessmentScoreCode criteria)
         throws Exception {

      PreparedStatement ps = null;
      ResultSet rs = null;
      List<AssessmentScoreCode> results = new LinkedList<AssessmentScoreCode>();
      StringBuffer buf = new StringBuffer(200);

      if (criteria == null)
         return null;
      buf.append("SELECT ");
      buf.append(prepareColList(criteria));
      buf.append(" FROM NC_ASSESSMENTSCORECODE ");
      QueryInfo qi = prepareWhereClause(criteria);
      buf.append(qi.whereClause);
      try {
         ps = con.prepareStatement(buf.toString());
         ps.clearParameters();
         int i = 0;
         for (Object element : qi.values) {
            ps.setObject(++i, element);
         }
         rs = ps.executeQuery();
         while (rs.next()) {
            AssessmentScoreCode item = createObject(rs);
            results.add(item);
         }
      } finally {
         if (rs != null)
            try {
               rs.close();
            } catch (Exception x) { /* ignore */
            }
         if (ps != null)
            try {
               ps.close();
            } catch (Exception x) { /* ignore */
            }
      }
      return results;
   }

   public void update(Connection con, AssessmentScoreCode bean,
         AssessmentScoreCode criteria) throws Exception {

      PreparedStatement ps = null;

      if (bean == null)
         return;

      UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
      try {
         ps = con.prepareStatement(uqi.query);
         ps.clearParameters();
         int i = 0;
         for (Object element : uqi.setValues) {
            ps.setObject(++i, element);
         }
         // for where part
         for (Object element : uqi.whereValues) {
            ps.setObject(++i, element);
         }
         ps.executeUpdate();
      } finally {
         if (ps != null)
            try {
               ps.close();
            } catch (Exception x) { /* ignore */
            }
      }
   }

   public void delete(Connection con, AssessmentScoreCode criteria)
         throws Exception {
      PreparedStatement ps = null;
      StringBuffer buf = new StringBuffer(200);
      buf.append("DELETE FROM NC_ASSESSMENTSCORECODE ");

      QueryInfo qi = prepareWhereClause(criteria);
      buf.append(qi.whereClause);
      try {
         ps = con.prepareStatement(buf.toString());
         ps.clearParameters();
         int i = 0;
         for (Object element : qi.values) {
            ps.setObject(++i, element);
         }
         ps.executeUpdate();

      } finally {
         if (ps != null)
            try {
               ps.close();
            } catch (Exception x) { /* ignore */
            }
      }
   }

   public static class QueryInfo {
      String whereClause;
      List<? super Object> values = new LinkedList<Object>();

      public QueryInfo() {}

      public QueryInfo(String whereClause) {
         this.whereClause = whereClause;
      }
   }

   public static class UpdateQueryInfo {
      String query;
      List<? super Object> setValues = new LinkedList<Object>();
      List<? super Object> whereValues = new LinkedList<Object>();

      public UpdateQueryInfo() {}
   }
}// ;

