package caslayout.ui.db.postgres;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import caslayout.ui.db.AbstractCommonQueryHelper;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: CommonQueryHelper.java,v 1.4 2007/10/08 18:00:42 bozyurt Exp $
 */

public class CommonQueryHelper extends AbstractCommonQueryHelper {

	public CommonQueryHelper() {
		super();
	}

	public int getNextSequenceNumber(Connection con) throws SQLException
	{
		Statement st = null;
		try {
			st = con.createStatement();
			ResultSet rs = st.executeQuery("select nextval('uid_seq')");
			if (rs.next()) {
				return rs.getInt(1);
			}
			rs.close();
		} finally {
			if (st != null)
				try {
					st.close();
				} catch (Exception x) {
				}
		}
		return -1;
	}

	public Long getDatabaseUser(Connection con, String name) throws SQLException
	{
		Statement st = null;
		try {
			st = con.createStatement();
			ResultSet rs = st
					.executeQuery("select uniqueid from nc_databaseuser where name='"
							+ name.toUpperCase() + "'");
			if (rs.next()) {
				return new Long(rs.getLong(1));
			}
			rs.close();
		} finally {
			if (st != null)
				try {
					st.close();
				} catch (Exception x) {
				}
		}
		return null;
	}

	public Long getTableID(Connection con, String tableName) throws SQLException
	{
		Statement st = null;
		try {
			st = con.createStatement();
			ResultSet rs = st
					.executeQuery("select tableid from nc_tableid where tablename='"
							+ tableName + "'");
			if (rs.next()) {
				return new Long(rs.getLong(1));
			}
			rs.close();
		} finally {
			if (st != null)
				try {
					st.close();
				} catch (Exception x) {
				}
		}
		return null;
	}

}
