package caslayout.ui.db.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.LinkedList;
import java.util.List;

import caslayout.exception.ValidationException;
import caslayout.ui.db.DBUtils;
import caslayout.ui.db.IOntologyConceptDAO;
import caslayout.ui.db.OntologyConcept;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: OntologyConceptDAO.java,v 1.4 2008/10/14 23:21:16 bozyurt Exp $
 */
public class OntologyConceptDAO implements IOntologyConceptDAO {

	public OntologyConceptDAO() {
	}

	public void insert(Connection con, OntologyConcept bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null) {
			return;
		}
		try {
			buf.append("INSERT INTO NC_ONTOLOGYCONCEPT VALUES ");
			buf.append('(');
			for (int i = 0; i < 9; ++i) {
				buf.append('?');
				if (i < 8) {
					buf.append(',');
				}
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getOntologySource(), Types.VARCHAR);
			ps.setObject(2, bean.getConceptID(), Types.VARCHAR);
			ps.setObject(3, bean.getConcept(), Types.VARCHAR);
			ps.setObject(4, DBUtils.toBigDecimal(bean.getUniqueID()),
					Types.NUMERIC);
			ps.setObject(5, DBUtils.toBigDecimal(bean.getTableID()),
					Types.NUMERIC);
			ps.setObject(6, DBUtils.toBigDecimal(bean.getOwner()),
					Types.NUMERIC);
			ps.setObject(7, new java.sql.Date(bean.getModTime().getTime()));
			ps.setObject(8, DBUtils.toBigDecimal(bean.getModUser()),
					Types.NUMERIC);
			ps.setObject(9, bean.getOntologyPath(), Types.VARCHAR);
			ps.executeUpdate();

		} finally {
			if (ps != null) {
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
			}
		}
	}

	protected String prepareColList(OntologyConcept bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("ONTOLOGYSOURCE");
		buf.append(',');
		buf.append("CONCEPTID");
		buf.append(',');
		buf.append("CONCEPT");
		buf.append(',');
		buf.append("UNIQUEID");
		buf.append(',');
		buf.append("TABLEID");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MODTIME");
		buf.append(',');
		buf.append("MODUSER");
		buf.append(',');
		buf.append("ONTOLOGYPATH");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(OntologyConcept bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getOntologySource() != null) {
			if (valueSet) {
				buf.append(" AND ");
			}
			buf.append("ONTOLOGYSOURCE=?");
			qi.values.add(bean.getOntologySource());
			valueSet = true;
		}
		if (bean.getConceptID() != null) {
			if (valueSet) {
				buf.append(" AND ");
			}
			buf.append("CONCEPTID=?");
			qi.values.add(bean.getConceptID());
			valueSet = true;
		}
		if (bean.getConcept() != null) {
			if (valueSet) {
				buf.append(" AND ");
			}
			buf.append("CONCEPT=?");
			qi.values.add(bean.getConcept());
			valueSet = true;
		}
		if (bean.getUniqueID() != null) {
			if (valueSet) {
				buf.append(" AND ");
			}
			buf.append("UNIQUEID=?");
			qi.values.add(DBUtils.toBigDecimal(bean.getUniqueID()));
			valueSet = true;
		}
		if (bean.getTableID() != null) {
			if (valueSet) {
				buf.append(" AND ");
			}
			buf.append("TABLEID=?");
			qi.values.add(DBUtils.toBigDecimal(bean.getTableID()));
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet) {
				buf.append(" AND ");
			}
			buf.append("OWNER=?");
			qi.values.add(DBUtils.toBigDecimal(bean.getOwner()));
			valueSet = true;
		}
		if (bean.getModTime() != null) {
			if (valueSet) {
				buf.append(" AND ");
			}
			buf.append("MODTIME=?");
			qi.values.add(new java.sql.Date(bean.getModTime().getTime()));
			valueSet = true;
		}
		if (bean.getModUser() != null) {
			if (valueSet) {
				buf.append(" AND ");
			}
			buf.append("MODUSER=?");
			qi.values.add(DBUtils.toBigDecimal(bean.getModUser()));
			valueSet = true;
		}
		if (bean.getOntologyPath() != null) {
			if (valueSet) {
				buf.append(" AND ");
			}
			buf.append("ONTOLOGYPATH=?");
			qi.values.add(bean.getOntologyPath());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(OntologyConcept bean,
			OntologyConcept criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_ONTOLOGYCONCEPT SET ");

		if (bean.getOntologySource() != null) {
			if (valueSet) {
				buf.append(", ");
			}
			buf.append("ONTOLOGYSOURCE=? ");
			uqi.setValues.add(bean.getOntologySource());
			valueSet = true;
		}
		if (bean.getConceptID() != null) {
			if (valueSet) {
				buf.append(", ");
			}
			buf.append("CONCEPTID=? ");
			uqi.setValues.add(bean.getConceptID());
			valueSet = true;
		}
		if (bean.getConcept() != null) {
			if (valueSet) {
				buf.append(", ");
			}
			buf.append("CONCEPT=? ");
			uqi.setValues.add(bean.getConcept());
			valueSet = true;
		}
		if (bean.getUniqueID() != null) {
			if (valueSet) {
				buf.append(", ");
			}
			buf.append("UNIQUEID=? ");
			uqi.setValues.add(DBUtils.toBigDecimal(bean.getUniqueID()));
			valueSet = true;
		}
		if (bean.getTableID() != null) {
			if (valueSet) {
				buf.append(", ");
			}
			buf.append("TABLEID=? ");
			uqi.setValues.add(DBUtils.toBigDecimal(bean.getTableID()));
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet) {
				buf.append(", ");
			}
			buf.append("OWNER=? ");
			uqi.setValues.add(DBUtils.toBigDecimal(bean.getOwner()));
			valueSet = true;
		}
		if (bean.getModTime() != null) {
			if (valueSet) {
				buf.append(", ");
			}
			buf.append("MODTIME=? ");
			uqi.setValues.add(new java.sql.Date(bean.getModTime().getTime()));
			valueSet = true;
		}
		if (bean.getModUser() != null) {
			if (valueSet) {
				buf.append(", ");
			}
			buf.append("MODUSER=? ");
			uqi.setValues.add(DBUtils.toBigDecimal(bean.getModUser()));
			valueSet = true;
		}
		if (bean.getOntologyPath() != null) {
			if (valueSet) {
				buf.append(", ");
			}
			buf.append("ONTOLOGYPATH=? ");
			uqi.setValues.add(bean.getOntologyPath());
			valueSet = true;
		}
		if (!valueSet) {
			throw new ValidationException(
					"At least one field needs to be set for update!");
		}

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	public OntologyConcept createObject(ResultSet rs) throws SQLException {
		OntologyConcept obj = new OntologyConcept();
		obj.setOntologySource((String) rs.getObject(1));
		obj.setConceptID((String) rs.getObject(2));
		obj.setConcept((String) rs.getObject(3));
		obj.setUniqueID(new Long(rs.getInt(4)));
		obj.setTableID(new Long(rs.getInt(5)));
		obj.setOwner(new Long(rs.getInt(6)));
		obj.setModTime((java.util.Date) rs.getObject(7));
		obj.setModUser(new Long(rs.getInt(8)));
		obj.setOntologyPath((String) rs.getObject(9));
		return obj;
	}

	public List<OntologyConcept> find(Connection con, OntologyConcept criteria) throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<OntologyConcept> results = new LinkedList<OntologyConcept>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null) {
			return null;
		}
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_ONTOLOGYCONCEPT ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Object element : qi.values) {
				ps.setObject(++i, element);
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				OntologyConcept item = createObject(rs);
				results.add(item);
			}
		} finally {
			if (rs != null) {
				try {
					rs.close();
				} catch (Exception x) { /* ignore */
				}
			}
			if (ps != null) {
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
			}
		}
		return results;
	}

	public void update(Connection con, OntologyConcept bean,
			OntologyConcept criteria) throws Exception {

		PreparedStatement ps = null;

		if (bean == null) {
			return;
		}

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			for (Object element : uqi.setValues) {
				ps.setObject(++i, element);
			}
			// for where part
			for (Object element : uqi.whereValues) {
				ps.setObject(++i, element);
			}
			ps.executeUpdate();
		} finally {
			if (ps != null) {
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
			}
		}
	}

	public void delete(Connection con, OntologyConcept criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_ONTOLOGYCONCEPT ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Object element : qi.values) {
				ps.setObject(++i, element);
			}
			ps.executeUpdate();

		} finally {
			if (ps != null) {
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
			}
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

} // ;
