package caslayout.ui.model;

/**
 * represents a difference from the reference assessment
 * (the one loaded into CALM).
 *
 * @author I. Burak Ozyurt
 * @version $Id: AsDiffInfo.java,v 1.1 2005/12/01 00:59:34 bozyurt Exp $
 */
public class AsDiffInfo {
  protected int type;
  protected String refDesc;
  protected String otherDesc;
  protected String id;

  public final static int AS_ITEM_REMOVED = 10;
  public final static int AS_ITEM_DIFFER = 11;
  public final static int AS_ITEM_ADDED = 12;

  public final static int AS_SCORE_REMOVED = 20;
  public final static int AS_SCORE_DIFFER = 21;
  public final static int AS_SCORE_ADDED = 22;

  public final static int AS_SCORECODE_REMOVED = 30;
  public final static int AS_SCORECODE_DIFFER = 31;
  public final static int AS_SCORECODE_ADDED = 32;

  public AsDiffInfo() {}

  public AsDiffInfo(String id, int type, String refDesc, String otherDesc) {
    this.id = id;
    this.type = type;
    this.refDesc = refDesc;
    this.otherDesc = otherDesc;
  }

//---------------------- setters --------------
  public void setType(int newType) {
    this.type = newType;
  }

  public void setRefDesc(String newRefDesc) {
    this.refDesc = newRefDesc;
  }

  public void setOtherDesc(String newOtherDesc) {
    this.otherDesc = newOtherDesc;
  }

//---------------------- getters --------------
  public int getType() {
    return this.type;
  }

  public String getRefDesc() {
    return this.refDesc;
  }

  public String getOtherDesc() {
    return this.otherDesc;
  }

  public String getId() {
    return this.id;
  }

  public String prepareMessage() {
    StringBuffer buf = new StringBuffer();
    switch(type) {
      case AS_ITEM_ADDED:
        buf.append("Score ").append(id).append(" has a new assessment item '");
        buf.append( otherDesc).append("'");
        break;
      case AS_ITEM_DIFFER:
        buf.append("Assessment item for score ").append(id);
        buf.append(" differs from whats in db. New one:'");
        buf.append(otherDesc).append("'");
        break;
      case AS_SCORE_ADDED:
        buf.append("New score added: ").append(otherDesc);
        break;
      case AS_SCORECODE_ADDED:
        buf.append("Score ").append(id).append(" has a new score code added:");
        buf.append(otherDesc);
        break;
      case AS_SCORECODE_REMOVED:
        buf.append("Score code '").append(refDesc).append("' has been removed from score '");
        buf.append(id).append("'");
        break;
    }
    return buf.toString();
  }

  public String toString() {
    StringBuffer buf = new StringBuffer(104);
    buf.append("AsDiffInfo::[");
    buf.append("id=").append(id);
    buf.append(", type=").append(type);
    buf.append(", refDesc=").append(refDesc);
    buf.append(", otherDesc=").append(otherDesc);
    buf.append(']');
    return buf.toString();
  }

}
