package caslayout.ui.model;

import java.util.*;

import org.jdom.*;

import caslayout.ui.Document;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: AssessmentAssociation.java,v 1.4 2007/10/08 18:00:42 bozyurt Exp $
 */
public class AssessmentAssociation extends Association
{
  AssessmentInfo left;
  Document right;


  public AssessmentAssociation(String name, int type, AssessmentInfo left, Document right)
  {
    super(name, type);
    this.left = left;
    this.right = right;
  }

  //---------------------- setters --------------
  public void setLeft(AssessmentInfo newLeft) { this.left = newLeft; }
  public void setRight(Document newRight) { this.right = newRight; }
//---------------------- getters --------------
  public AssessmentInfo getLeft() { return this.left; }
  public Document getRight() { return this.right; }




  public void update(Observable o, Object arg) {
    /** no op */
  }

   public static AssessmentAssociation initializeFromXML(Element e, AssessmentInfo ai, Document doc) {
     AssessmentAssociation aa = null;
     String name = e.getAttributeValue("name");
     /** @todo can it be initialized from the current state XML info just for validation? */
     aa = new AssessmentAssociation(name, Association.BIDIRECTIONAL, ai, doc);

     return aa;
   }

  public Element toXML(Element root) {
    Element e = super.toXML(root);
    e.setName("assessment-binding");
    // e.setAttribute("type","assessment");
    Element leftElem = new Element("left");
    leftElem.setAttribute("assessment-name", left.getName());
    e.addContent(leftElem);
    Element rightElem = new Element("right");
    rightElem.setAttribute("doc-name", right.getName());
    e.addContent(rightElem);

    return e;
  }

}
