package caslayout.ui.model;

import java.util.*;

import org.jdom.*;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: Association.java,v 1.1 2004/04/29 02:42:45 bozyurt Exp $
 */
public abstract class Association implements Observer
{
  protected String name;
  protected int type;
  public final static int FROM_LEFT_TO_RIGHT = 1;
  public final static int FROM_RIGHT_TO_LEFT = 2;
  public final static int BIDIRECTIONAL = 3;


  public Association(String name, int type)
  {
    this.name = name;
    this.type = type;
  }


  //---------------------- setters --------------
  public void setName(String newName) { this.name = newName; }
  public void setType(int newType) { this.type = newType; }
  //---------------------- getters --------------
  public String getName() { return this.name; }
  public int getType() { return this.type; }

  /**
   *  depending of the type of association synchs the end(s) of the
   * association
   */
  public abstract void update(Observable o, Object arg);


  public Element toXML(Element root) {
    Element e = new Element("binding");
    e.setAttribute("id","");
    e.setAttribute("name", name);
    return e;
  }

}