package caslayout.ui.model;

import java.util.*;

import caslayout.ui.*;

import org.jdom.Element;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: AssociationHelper.java,v 1.18 2008/10/13 23:58:08 bozyurt Exp $
 */
public class AssociationHelper extends Observable {
   protected Map<ScoreInfo, ScoreAssociation> assocMap = new HashMap<ScoreInfo, ScoreAssociation>();
   protected Map<String, MandatoryFieldAssociation> mandatoryFieldsMap = new HashMap<String, MandatoryFieldAssociation>(
         7);
   protected AssessmentAssociation asAssoc;
   protected Map<String, Association> assocMapByID;
   protected static AssociationHelper instance;

   protected AssociationHelper() {}

   public synchronized static AssociationHelper getInstance() {
      if (instance == null)
         instance = new AssociationHelper();
      return instance;
   }

   public synchronized void reset() {
      assocMap.clear();
      mandatoryFieldsMap.clear();
      if (assocMapByID != null)
         assocMapByID.clear();
      asAssoc = null;
   }

   public AssessmentAssociation getAsAssoc() {
      return this.asAssoc;
   }

   public void addScoreAssociation(ScoreAssociation sa) {
      assocMap.put(sa.getLeft(), sa);
   }

   public void removeScoreAssociation(ScoreAssociation sa) {
      assocMap.remove(sa.getLeft());
      if (assocMapByID != null) {
         assocMapByID.remove(sa.getRHSID());
      }
      this.notifyObservers();
   }

   public Map<ScoreInfo, ScoreAssociation> getAssocMap() {
      return assocMap;
   }

   public Map<String, MandatoryFieldAssociation> getMandatoryFieldsMap() {
      return mandatoryFieldsMap;
   }

   public void addMandatoryFieldAssociation(MandatoryFieldAssociation mfa) {
      mandatoryFieldsMap.put(mfa.getLeft(), mfa);
   }

   public MandatoryFieldAssociation findMandatoryFieldAssociation(
         String property) {
      return mandatoryFieldsMap.get(property.toLowerCase());
   }

   public void associateScore(String assocName, AbstractDisplayComponent adc,
         ScoreInfo si) {
      ScoreAssociation sa = new ScoreAssociation(assocName,
            Association.BIDIRECTIONAL, si, adc);
      assocMap.put(si, sa);
   }

   public void associateAssessment(String assocName, Document document,
         AssessmentInfo as) {
      asAssoc = new AssessmentAssociation(assocName, Association.BIDIRECTIONAL,
            as, document);
   }

   public ScoreAssociation findScoreAssociation(ScoreInfo si) {
      return assocMap.get(si);
   }

   public Association findScoreAssociation(String id) {
      if (assocMapByID == null || assocMap.size() != assocMapByID.size()) {
         if (assocMapByID == null) {
            assocMapByID = new HashMap<String, Association>();
         }
         for (Iterator<ScoreAssociation> iter = assocMap.values().iterator(); iter
               .hasNext();) {
            ScoreAssociation sa = iter.next();
            if (assocMapByID.get(sa.getRHSID()) == null) {
               assocMapByID.put(sa.getRHSID(), sa);
            }
         }

         for (Iterator<MandatoryFieldAssociation> iter = mandatoryFieldsMap
               .values().iterator(); iter.hasNext();) {
            MandatoryFieldAssociation mfa = iter.next();
            if (assocMapByID.get(mfa.getRight().getId()) == null) {
               assocMapByID.put(mfa.getRight().getId(), mfa);
            }
         }
      }
      return assocMapByID.get(id);
   }

   public List<ScoreInfo> getAssociatedScores() {
      List<ScoreInfo> scoreList = new ArrayList<ScoreInfo>(assocMap.keySet());
      return scoreList;
   }

   public Association findScoreAssociationForDisplayComponent(
         IDisplayComponent ic) {
      if (ic == null)
         return null;
      if (ic instanceof TextDisplayComponent
            || ic instanceof ButtonDisplayComponent)
         return null;
      AbstractDisplayComponent adc = (AbstractDisplayComponent) ic;

      for (Iterator<ScoreAssociation> iter = assocMap.values().iterator(); iter
            .hasNext();) {
         ScoreAssociation sa = iter.next();
         if (sa.getRight() == null)
            continue;
         if (sa.getRight() instanceof LogicalGroup) {
            LogicalGroup lg = (LogicalGroup) sa.getRight();
            if (lg.findComponent(adc.getId()) != null) {
               return sa;
            }
         } else {
            if (sa.getRHSID().equals(adc.getId()))
               return sa;
         }
      }
      for (Iterator<MandatoryFieldAssociation> iter = mandatoryFieldsMap
            .values().iterator(); iter.hasNext();) {
         MandatoryFieldAssociation mfa = iter.next();
         if (mfa.getRight().getId().equals(adc.getId())) {
            return mfa;
         }
      }
      return null;
   }

   public void componentRemoved(AbstractDisplayComponent adc) {
      List<Association> removedAssocs = new LinkedList<Association>();
      handleComponentRemoved(adc, removedAssocs);
      if (!removedAssocs.isEmpty()) {
         // notify all registered listeners about the dropped association(s)
         this.notifyObservers();
      }
   }

   protected void handleComponentRemoved(AbstractDisplayComponent adc,
         List<Association> removedAssocs) {
      if (adc instanceof CAContainer) {
         CAContainer container = (CAContainer) adc;
         for (Iterator<IDisplayComponent> iter = container.getComponents().iterator(); iter
               .hasNext();) {
            AbstractDisplayComponent child = (AbstractDisplayComponent) iter
                  .next();
            if (child != null)
               handleComponentRemoved(child, removedAssocs);
         }
      } else {
         Association assoc = findScoreAssociationForDisplayComponent(adc);
         if (assoc != null && assoc instanceof ScoreAssociation) {
            ScoreAssociation sa = (ScoreAssociation) assoc;
            if (sa.getRHSID().equals(adc.getId())) {
               findAndRemoveScoreAssociation(sa);
               removedAssocs.add(sa);
            } else {
               findAndCleanAssociation(sa);
               removedAssocs.add(sa);
            }
         } else {
            MandatoryFieldAssociation mfa = (MandatoryFieldAssociation) assoc;
            findAndRemoveMadatoryFieldAssociation(mfa);
            removedAssocs.add(mfa);
         }
      }
   }

   protected void findAndRemoveScoreAssociation(ScoreAssociation theSa) {
      for (Iterator<ScoreAssociation> iter = assocMap.values().iterator(); iter
            .hasNext();) {
         ScoreAssociation sa = iter.next();
         if (sa == theSa) {
            iter.remove();
            break;
         }
      }
      if (assocMapByID != null) {
         assocMapByID.remove(theSa.getRHSID());
      }
   }

   protected void findAndRemoveMadatoryFieldAssociation(
         MandatoryFieldAssociation theMfa) {
      for (Iterator<MandatoryFieldAssociation> iter = mandatoryFieldsMap
            .values().iterator(); iter.hasNext();) {
         MandatoryFieldAssociation mfa = iter.next();
         if (mfa == theMfa) {
            iter.remove();
            break;
         }
      }
   }

   protected void findAndCleanAssociation(ScoreAssociation sa) {
      if (sa.getRight() instanceof LogicalGroup) {
         LogicalGroup lg = (LogicalGroup) sa.getRight();
         LogicalGroupRepository.getInstance().removeGroup(lg.getId());
      }
      findAndRemoveScoreAssociation(sa);
   }

   public static AssociationHelper initializeFromXML(Element e,
         AssessmentInfo ai, Document doc) {
      AssociationHelper ah = AssociationHelper.getInstance();
      ah.reset();
      List<?> elemList = e.getChildren("assessment-binding");
      for (Iterator<?> iter = elemList.iterator(); iter.hasNext();) {
         Element bindingElem = (Element) iter.next();
         ah.asAssoc = AssessmentAssociation.initializeFromXML(bindingElem, ai,
               doc);
      }

      elemList = e.getChildren("score-binding");
      if (elemList != null) {
         for (Iterator<?> iter = elemList.iterator(); iter.hasNext();) {
            Element bindingElem = (Element) iter.next();
            ScoreAssociation sa = ScoreAssociation.initializeFromXML(
                  bindingElem, ai, doc);
            if (sa != null) {
               ah.assocMap.put(sa.getLeft(), sa);
            }
         }
      }
      elemList = e.getChildren("mandatory-binding");
      if (elemList != null) {
         for (Iterator<?> iter = elemList.iterator(); iter.hasNext();) {
            Element bindingElem = (Element) iter.next();
            MandatoryFieldAssociation mfa = MandatoryFieldAssociation
                  .initializeFromXML(bindingElem, ai, doc);
            if (mfa != null) {
               ah.mandatoryFieldsMap.put(mfa.getLeft(), mfa);
            }
         }
      }

      return ah;
   }

   public Element toXML(Element root) {
      Element e = new Element("bindings");
      if (asAssoc != null) {
         Element aaElem = asAssoc.toXML(root);
         e.addContent(aaElem);
      }
      for (Iterator<ScoreAssociation> iter = assocMap.values().iterator(); iter
            .hasNext();) {
         ScoreAssociation sa = iter.next();
         // System.out.println(sa.toString());
         Element saElem = sa.toXML(root);
         if (saElem != null) {
            e.addContent(saElem);
         } else {
            System.out.println("Bad Association " + sa.toString());
         }
      }

      for (Iterator<MandatoryFieldAssociation> iter = mandatoryFieldsMap
            .values().iterator(); iter.hasNext();) {
         MandatoryFieldAssociation mfa = iter.next();
         Element mfaElem = mfa.toXML(root);
         e.addContent(mfaElem);
      }
      return e;
   }
}
