package caslayout.ui.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.jdom.Element;
import org.jdom.Namespace;

import caslayout.util.XMLUtils;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: FieldInfo.java,v 1.4 2008/10/13 23:58:08 bozyurt Exp $
 */
public class FieldInfo {
   protected String name;
   /** field Java type currently only <code>string</code> is supported */
   protected String type;
   protected Map<String, String> metaDataMap = new LinkedHashMap<String, String>(
         3);

   public FieldInfo(String name, String type) {
      this.name = name;
      this.type = type;
   }

   public String getName() {
      return name;
   }

   public String getType() {
      return type;
   }

   public void addMetadata(String name, String value) {
      metaDataMap.put(name, value);
   }

   public String getMetaDataValue(String key) {
      return metaDataMap.get(key);
   }

   public List<String> getMetaDataVarNames() {
      return new ArrayList<String>(metaDataMap.keySet());
   }

   public boolean hasMetaData() {
      return !metaDataMap.isEmpty();
   }

   public int hashCode() {
      return name.hashCode();
   }

   public boolean equals(Object other) {
      if (other == this) {
         return true;
      }
      if (!(other instanceof FieldInfo)) {
         return false;
      }
      FieldInfo that = (FieldInfo) other;
      return name.equals(that.name);
   }

   public static FieldInfo initializeFromXML(Element e) {
      String name = e.getAttributeValue("name");
      String type = e.getAttributeValue("type");

      FieldInfo fi = new FieldInfo(name, type);

      // add the meta data also
      List<?> children = e.getChildren("meta");
      for (Iterator<?> iter = children.iterator(); iter.hasNext();) {
         Element child = (Element) iter.next();
         String vname = child.getAttributeValue("name");
         String value = XMLUtils.decodeXML(child.getAttributeValue("value"));
         fi.addMetadata(vname, value);
      }
      return fi;
   }

   public Element toXML(Element root) {
      Element e = new Element("field");
      e.setAttribute("name", name);
      e.setAttribute("type", type);
      // add meta data (if any)
      for(Map.Entry<String, String> entry : metaDataMap.entrySet()) {
         Element me = new Element("meta");
         me.setAttribute("name",  entry.getKey());
         me.setAttribute("value", XMLUtils.toXML( entry.getValue()));
         e.addContent(me);
      }
      return e;
   }

   public Element toXFormsXML(Namespace ns, MandatoryFieldAssociation mfa) {
      Element e = new Element("field", ns);
      String id = "";
      if (mfa != null && mfa.getRight() != null)
         id = mfa.getRight().getId();
      e.setAttribute("id", id);
      e.setAttribute("name", name);
      e.setAttribute("type", type);

      return e;
   }
}
