package caslayout.ui.model;

import org.jdom.Element;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: ItemInfo.java,v 1.3 2007/10/08 18:00:42 bozyurt Exp $
 */
public class ItemInfo {
	protected Long assessmentID;
	protected String scoreName;
	protected String itemLeadingText;
	protected String itemTrailingText;

	public ItemInfo() {
	}

	public ItemInfo(Long asID, String scoreName) {
		this.assessmentID = asID;
		this.scoreName = scoreName;
	}

	// ---------------------- setters --------------
	public void setAssessmentID(Long newAssessmentID) {
		this.assessmentID = newAssessmentID;
	}

	public void setScoreName(String newScoreName) {
		this.scoreName = newScoreName;
	}

	public void setItemLeadingText(String newItemLeadingText) {
		this.itemLeadingText = newItemLeadingText;
	}

	public void setItemTrailingText(String newItemTrailingText) {
		this.itemTrailingText = newItemTrailingText;
	}

	// ---------------------- getters --------------
	public Long getAssessmentID() {
		return this.assessmentID;
	}

	public String getScoreName() {
		return this.scoreName;
	}

	public String getItemLeadingText() {
		return this.itemLeadingText;
	}

	public String getItemTrailingText() {
		return this.itemTrailingText;
	}

	public Element toXML(Element root) {
		Element e = new Element("as-item");
		e.setAttribute("assessment_id", String.valueOf(assessmentID));
		e.setAttribute("score_name", scoreName);
		if (itemLeadingText != null) {
			Element lElem = new Element("leading_text");
			lElem.addContent(itemLeadingText);
			e.addContent(lElem);
		}

		if (itemTrailingText != null) {
			Element tElem = new Element("trailing_text");
			tElem.addContent(itemTrailingText);
			e.addContent(tElem);
		}
		return e;
	}

	public static ItemInfo initializeFromXML(Element e) {
		Long asID = new Long( e.getAttributeValue("assessment_id"));

		String scoreName = e.getAttributeValue("score_name");

		ItemInfo ii = new ItemInfo(asID, scoreName);

		Element lElem = e.getChild("leading_text");
		if (lElem != null) {
			ii.setItemLeadingText(lElem.getTextTrim());
		}
		Element tElem = e.getChild("trailing_text");
		if (tElem != null) {
			ii.setItemTrailingText(tElem.getTextTrim());
		}

		return ii;
	}

	public String toString() {
		StringBuffer buf = new StringBuffer(128);
		buf.append("ItemInfo::[");
		buf.append("assessmentID=").append(assessmentID);
		buf.append(", scoreName=").append(scoreName);
		buf.append(", itemLeadingText=").append(itemLeadingText);
		buf.append(", itemTrailingText=").append(itemTrailingText);
		buf.append(']');
		return buf.toString();
	}

	public boolean equals(Object other) {
		if (other == null)
			return false;
		if (other == this)
			return true;
		if (!(other instanceof ItemInfo)) {
			return false;
		}
		ItemInfo that = (ItemInfo) other;
		if (assessmentID == that.assessmentID
				&& (scoreName != null && that.scoreName != null && scoreName
						.equals(that.scoreName))) {
			return true;
		}
		return false;
	}

	public int hashCode() {
		StringBuffer buf = new StringBuffer();
		buf.append(assessmentID).append(scoreName);
		return buf.toString().hashCode();
	}

}
