package caslayout.ui.model;

import java.util.*;

import caslayout.ui.*;

import org.jdom.Element;
import caslayout.util.GenUtils;
import caslayout.ui.DropdownDisplayComponent;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: MandatoryFieldAssociation.java,v 1.6 2007/10/08 18:00:42 bozyurt Exp $
 */
public class MandatoryFieldAssociation extends Association
{
  protected String left;
  protected AbstractDisplayComponent right;

  public MandatoryFieldAssociation(String name, int type, String left, AbstractDisplayComponent right) {
    super(name, type);
    // allways all lowercase
    this.left = left.toLowerCase();
    this.right = right;
  }

  public String getLeft() { return this.left; }
  public AbstractDisplayComponent getRight() { return this.right; }

  public void setRight(AbstractDisplayComponent newValue) {
    if ( newValue instanceof TextFieldDisplayComponent ||
         newValue instanceof DropdownDisplayComponent ) {
      this.right = newValue;
    } else {
      throw new RuntimeException("Only text field or a dropdown is accepted for mandatory field data input!");
    }
  }

  public void update(Observable o, Object arg)
  {
    /**@todo Implement this java.util.Observer abstract method*/
  }

  public static MandatoryFieldAssociation initializeFromXML(Element e, AssessmentInfo ai, Document doc) {
     String name = e.getAttributeValue("name");
     Element leftElem = e.getChild("left");
     // always lower case
     String property = leftElem.getAttributeValue("property").toLowerCase();
     Element rightElem = e.getChild("right");
     String id = rightElem.getAttributeValue("id");
     AbstractDisplayComponent right = (AbstractDisplayComponent) GenUtils.findDisplayComponent(id, doc);
     if ( right == null) {
       doc.handleMissingCompInAssociation(id);
       return null;
     }
     MandatoryFieldAssociation mfa = new MandatoryFieldAssociation(name, Association.BIDIRECTIONAL, property , right);

     return mfa;
   }


  public Element toXML(Element root) {
    Element e = super.toXML(root);
    e.setName("mandatory-binding");

    // e.setAttribute("type","mandatory");
    Element leftElem = new Element("left");
    leftElem.setAttribute("property", left);
    e.addContent( leftElem);
    Element rightElem = new Element("right");
    rightElem.setAttribute("id", right.getId() );
    e.addContent( rightElem);

    Element valueBindingElem = new Element("value-binding");
    valueBindingElem.setAttribute("id", right.getId());
    e.addContent( valueBindingElem );

    return e;
  }

}
