package caslayout.ui.model;

import org.jdom.*;

public class ScoreCodeInfo {
  protected String scoreName;
  protected String scoreCode;
  protected String scoreCodeValue;
  protected String scoreCodeType;
  protected String scoreCodeTypeFormat;

  public ScoreCodeInfo(String scoreName, String scoreCode,
                       String scoreCodeValue, String scoreCodeType,
                       String scoreCodeTypeFormat) {
    this.scoreName = scoreName;
    this.scoreCode = scoreCode;
    this.scoreCodeValue = scoreCodeValue;
    this.scoreCodeType = scoreCodeType;
    if (scoreCodeTypeFormat == null) {
      this.scoreCodeTypeFormat = "";
    } else {
      this.scoreCodeTypeFormat = scoreCodeTypeFormat;
    }
  }

//---------------------- setters --------------
  public void setScoreName(String newScoreName) {
    this.scoreName = newScoreName;
  }

  public void setScoreCode(String newScoreCode) {
    this.scoreCode = newScoreCode;
  }

  public void setScoreCodeValue(String newScoreCodeValue) {
    this.scoreCodeValue = newScoreCodeValue;
  }

  public void setScoreCodeType(String newScoreCodeType) {
    this.scoreCodeType = newScoreCodeType;
  }

  public void setScoreCodeTypeFormat(String newScoreCodeTypeFormat) {
    if (newScoreCodeTypeFormat == null) {
      this.scoreCodeTypeFormat = "";
    } else {
      this.scoreCodeTypeFormat = newScoreCodeTypeFormat;
    }
  }

//---------------------- getters --------------
  public String getScoreName() {
    return this.scoreName;
  }

  public String getScoreCode() {
    return this.scoreCode;
  }

  public String getScoreCodeValue() {
    return this.scoreCodeValue;
  }

  public String getScoreCodeType() {
    return this.scoreCodeType;
  }

  public String getScoreCodeTypeFormat() {
    return this.scoreCodeTypeFormat;
  }

  public static ScoreCodeInfo initializeFromXML(Element e) {
    String scoreName = e.getAttributeValue("score-name");
    String scoreCode = e.getAttributeValue("code");
    String scoreType = e.getAttributeValue("type");
    String scoreTypeFormat = e.getAttributeValue("type-format");
    String scoreCodeValue = e.getAttributeValue("code-value");
    ScoreCodeInfo sci = new ScoreCodeInfo(scoreName, scoreCode, scoreCodeValue,
        scoreType, scoreTypeFormat);

    return sci;
  }

  public Element toXML(Element root) {
    Element e = new Element("scorecode");
    e.setAttribute("score-name", getScoreName());
    e.setAttribute("code", getScoreCode());
    e.setAttribute("code-value", scoreCodeValue);
    e.setAttribute("type", getScoreCodeType());
    e.setAttribute("type-format", getScoreCodeTypeFormat());
    return e;
  }

  public boolean equals(Object other) {
    if (other == null) {
      return false;
    }
    if (other == this) {
      return true;
    }
    if (! (other instanceof ScoreCodeInfo)) {
      return false;
    }
    ScoreCodeInfo that = (ScoreCodeInfo) other;
    if ( (scoreName != null && that.scoreName != null &&
          scoreName.equals(that.scoreName)) &&
        (scoreCode != null && that.scoreCode != null &&
         scoreCode.equals(that.scoreCode)) &&
        (scoreCodeValue != null && that.scoreCodeValue != null &&
         scoreCodeValue.equals(that.scoreCodeValue)) &&
        (scoreCodeType != null && that.scoreCodeType != null &&
         scoreCodeType.equals(that.scoreCodeType)) &&
        (scoreCodeTypeFormat != null && that.scoreCodeTypeFormat != null &&
         scoreCodeTypeFormat.equals(that.scoreCodeTypeFormat))) {
      return true;
    }
    return false;
  }

  public int hashCode() {
    if ( scoreName != null && scoreCode != null &&
         scoreCodeValue != null && scoreCodeType != null &&
         scoreCodeTypeFormat != null)
    {
      int result = 14;
      result = 29 * result + scoreName.hashCode();
      result = 29 * result + scoreCode.hashCode();
      result = 29 * result + scoreCodeValue.hashCode();
      result = 29 * result + scoreCodeType.hashCode();
      result = 29 * result + scoreCodeTypeFormat.hashCode();
      return result;
    } else {
      return System.identityHashCode(this);
    }
  }

  public String toString() {
    StringBuffer buf = new StringBuffer();
    buf.append("ScoreCodeInfo ::[");
    buf.append("ScoreName=").append(scoreName).append(",scoreCode=").append(
        scoreCode).append(",scoreTypeFormat=").append(scoreCodeTypeFormat);
    buf.append(",scoreCodeValue=").append(scoreCodeValue);
    buf.append(']');
    return buf.toString();
  }

}
