package caslayout.ui.model;

import java.util.*;

import org.jdom.*;
import caslayout.util.*;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: ScoreInfo.java,v 1.14 2008/10/13 23:58:08 bozyurt Exp $
 */
public class ScoreInfo implements Observer {
   protected String scoreName;
   protected int scoreSequence;
   protected String scoreType;
   protected String scoreTypeFormat;
   protected ScoreInfo parent;
   protected AssessmentInfo assessment;
   protected int scoreLevel;
   protected String securityClassification;

   protected List<ScoreCodeInfo> scoreCodes = new LinkedList<ScoreCodeInfo>();

   public ScoreInfo(String scoreName) {
      this.scoreName = scoreName;
   }

   // ---------------------- setters --------------
   public void setScoreName(String newScoreName) {
      this.scoreName = newScoreName;
   }

   public void setScoreSequence(int newScoreSequence) {
      this.scoreSequence = newScoreSequence;
   }

   public void setScoreType(String newScoreType) {
      this.scoreType = newScoreType;
   }

   public void setScoreTypeFormat(String newScoreTypeFormat) {
      this.scoreTypeFormat = newScoreTypeFormat;
   }

   public void setParent(ScoreInfo newParent) {
      this.parent = newParent;
   }

   public void setAssessment(AssessmentInfo newAssessment) {
      this.assessment = newAssessment;
   }

   public void addScoreCode(ScoreCodeInfo sci) {
      scoreCodes.add(sci);
   }

   public void setScoreLevel(int newScoreLevel) {
      this.scoreLevel = newScoreLevel;
   }

   public void setSecurityClassification(String newSecurityClassification) {
      this.securityClassification = newSecurityClassification;
   }

   // ---------------------- getters --------------
   public String getScoreName() {
      return this.scoreName;
   }

   public int getScoreSequence() {
      return this.scoreSequence;
   }

   public String getScoreType() {
      return this.scoreType;
   }

   public String getScoreTypeFormat() {
      return this.scoreTypeFormat;
   }

   public ScoreInfo getParent() {
      return this.parent;
   }

   public AssessmentInfo getAssessment() {
      return this.assessment;
   }

   public String getSecurityClassification() {
      return this.securityClassification;
   }

   public int getScoreLevel() {
      return this.scoreLevel;
   }

   public List<ScoreCodeInfo> getScoreCodes() {
      return scoreCodes;
   }

   public ScoreCodeInfo findScoreCode(String scoreCodeValue) {
      for (Iterator<ScoreCodeInfo> iter = scoreCodes.iterator(); iter.hasNext();) {
         ScoreCodeInfo sci = iter.next();
         if (sci.getScoreCodeValue().equals(scoreCodeValue))
            return sci;
      }
      return null;
   }

   public ScoreCodeInfo findScoreCodeInfo(String scoreCode) {
      for (Iterator<ScoreCodeInfo> iter = scoreCodes.iterator(); iter.hasNext();) {
         ScoreCodeInfo sci = iter.next();
         if (sci.getScoreCode().equals(scoreCode))
            return sci;
      }
      return null;
   }

   public int hashCode() {
      return scoreName.hashCode();
   }

   public boolean equals(Object other) {
      if (other == this) {
         return true;
      }
      if (!(other instanceof ScoreInfo)) {
         return false;
      }
      ScoreInfo that = (ScoreInfo) other;
      return scoreName.equals(that.scoreName);
   }

   public void update(Observable o, Object arg) {
      if (!o.hasChanged())
         return;
      /** @todo */
   }

   public static ScoreInfo initializeFromXML(Element e,
         AssessmentInfo assessment, Map<String,ScoreInfo> availableScoreInfoMap) {
      // String asName = e.getAttributeValue("assessment");
      String scoreName = e.getAttributeValue("name");
      String scoreType = e.getAttributeValue("type");
      String scoreTypeFormat = e.getAttributeValue("typeFormat");
      int scoreSequence = Integer.parseInt(e.getAttributeValue("sequence"));
      String securityClass = e.getAttributeValue("sec-class");
      int level = 0;
      if (e.getAttribute("level") != null)
         level = Integer.parseInt(e.getAttributeValue("level"));
      ScoreInfo si = new ScoreInfo(scoreName);
      si.setScoreType(scoreType);
      if (scoreTypeFormat == null)
         scoreTypeFormat = "";
      si.setScoreTypeFormat(scoreTypeFormat);
      si.setScoreSequence(scoreSequence);
      si.setAssessment(assessment);
      si.setScoreLevel(level);
      si.setSecurityClassification(securityClass);

      Element parentElem = e.getChild("parent");
      if (parentElem != null) {
         String parentScoreName = parentElem.getAttributeValue("name");
         // ScoreInfo parentProxy = new ScoreInfo(parentScoreName);
         ScoreInfo parentScore = (ScoreInfo) availableScoreInfoMap
               .get(parentScoreName);
         if (parentScore != null) {
            si.setParent(parentScore);
         } else {
            System.err.println("parent is not loaded for score " + scoreName);
         }
      }
      Element scListElem = e.getChild("scorecodes");
      if (scListElem != null) {
         List<?> scElems = scListElem.getChildren("scorecode");
         for (Iterator<?> iter = scElems.iterator(); iter.hasNext();) {
            Element sce = (Element) iter.next();
            ScoreCodeInfo sci = ScoreCodeInfo.initializeFromXML(sce);
            si.addScoreCode(sci);
         }
      }

      return si;
   }

   public Element toXML(Element root) {
      Element e = new Element("score");
      e.setAttribute("assessment", assessment.getName());
      e.setAttribute("name", scoreName);
      e.setAttribute("sequence", String.valueOf(scoreSequence));
      e.setAttribute("type", scoreType);
      e.setAttribute("typeFormat", scoreTypeFormat);
      e.setAttribute("level", String.valueOf(scoreLevel));
      if (securityClassification != null)
         e.setAttribute("sec-class", securityClassification);

      if (parent != null) {
         Element parentElem = new Element("parent");
         parentElem.setAttribute("assessment", assessment.getName());
         parentElem.setAttribute("name", parent.getScoreName());
         e.addContent(parentElem);
      }

      if (scoreCodes != null) {
         Element scListElem = new Element("scorecodes");
         e.addContent(scListElem);

         for (Iterator<ScoreCodeInfo> iter = scoreCodes.iterator(); iter
               .hasNext();) {
            ScoreCodeInfo sci = iter.next();
            scListElem.addContent(sci.toXML(null));
         }
      }
      return e;
   }

   public Element toXFormsXML(Namespace ns, ScoreAssociation sa) {
      Element e = new Element("score", ns);
      String id = "";
      if (sa != null && sa.getRight() != null) {
         id = sa.getRHSID();
      }

      e.setAttribute("id", id);
      e.setAttribute("name", scoreName);
      e.setAttribute("sequence", String.valueOf(scoreSequence));
      e.setAttribute("type", scoreType);
      e.setAttribute("typeFormat", scoreTypeFormat);
      // mainly variable name
      Element displayNameElem = new Element("display-name", ns);
      if (sa != null && sa.getScoreName() != null) {
         displayNameElem.setText(GenUtils.convertToJavaVariableName(sa
               .getScoreName().getLabel().getText()));
      } else {
         displayNameElem.setText(GenUtils.convertToJavaVariableName(scoreName));
      }
      e.addContent(displayNameElem);
      return e;
   }

   public String toString() {
      StringBuffer buf = new StringBuffer();
      buf.append("ScoreInfo ::[");
      buf.append("ScoreName=").append(scoreName).append(",scoreType=").append(
            scoreType).append(",scoreTypeFormat=").append(scoreTypeFormat);
      buf.append(']');
      return buf.toString();
   }
}
