package caslayout.ui.wizard;

import guilib.common.BaseDialog;

import java.awt.Frame;
import java.awt.event.ActionEvent;

import javax.swing.JButton;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: WizardDialog.java,v 1.2 2007/10/08 18:00:42 bozyurt Exp $
 */
public class WizardDialog extends BaseDialog implements IWizardListener {
	protected IWizardUsable[] screens;
	protected IWizardUsable curScreen;
	protected int curScreenIdx;
	private static final long serialVersionUID = 1L;

	public WizardDialog(Frame owner, String title, IWizardUsable[] screens) {
		super(owner, title, new String[] {"Previous", "Next"});
		this.screens = screens;
		assert( screens.length > 0);
		curScreen = screens[0];
		curScreenIdx = 0;
		handleButtonLabels4FirstPage();
		
	    getContentPane().add( curScreen.getMainPanel() );
	    pack();
	}
	
	public void actionPerformed(ActionEvent e)
	{
		this.returnCode = BaseDialog.NONE;
		if (e.getSource() instanceof JButton) {
			JButton button = (JButton) e.getSource();
			if (button.getText().equalsIgnoreCase("finish")) {
				curScreen.beforeLeave();
				this.returnCode = OK_PRESSED;
				setVisible(false);
			} else if ( button.getText().equalsIgnoreCase("next")) {
				getContentPane().remove(curScreen.getMainPanel() );
				curScreen.beforeLeave();				
				curScreenIdx++;
				curScreen = screens[curScreenIdx];
				handleButtonLabels();
				getContentPane().add(curScreen.getMainPanel() );
				Object payload = screens[curScreenIdx - 1].getPayload();
				curScreen.setPayload(payload);
				repaint();
		        System.out.println(curScreen.getMainPanel());
			} else if ( button.getText().equalsIgnoreCase("previous")) {
				getContentPane().remove( curScreen.getMainPanel() );
				curScreen.beforeLeave();								
				curScreenIdx--;
				curScreen = screens[curScreenIdx];
				handleButtonLabels();
				getContentPane().add( curScreen.getMainPanel() );
				repaint();
		        System.out.println(curScreen.getMainPanel());					
			} else if (button.getText().equalsIgnoreCase("cancel")) {
				this.returnCode = CANCEL_PRESSED;
				setVisible(false);
			}
		}	
	}
	
	public Object getPayload() {
		return this.screens[ screens.length - 1].getPayload();
	}
	
	protected void handleButtonLabels() {
		JButton prevButton = super.getButton("Previous");
		if ( curScreen.hasPrevious()) {
			prevButton.setText("Previous");
		} else {
			prevButton.setText("Cancel");
		}
		prevButton.setEnabled( curScreen.hasPrevious());
		
		JButton nextButton = super.getButton("Next");
	    if ( !curScreen.hasNext()) {
	    	nextButton.setText("Finish");
	    } else {
	    	nextButton.setText("Next");
	    }
	}
	
	protected void handleButtonLabels4FirstPage() {
		JButton prevButton = super.getButton("Previous");
		prevButton.setText("Cancel");
		prevButton.setEnabled( true );
		
		JButton nextButton = super.getButton("Next");
	    if ( !curScreen.hasNext()) {
	    	nextButton.setText("Finish");
	    } else {
	    	nextButton.setText("Next");
	    }
	}

	public void disableNext(IWizardUsable screen) {
		JButton nextButton = super.getButton("Next");
		if ( nextButton != null) {
			nextButton.setEnabled(false);
		} else {
			nextButton = super.getButton("Finish");
			nextButton.setEnabled(false);
		}		
	}

	public void enableNext(IWizardUsable screen) {
		JButton nextButton = super.getButton("Next");
		if ( nextButton != null) {
			nextButton.setEnabled(true);
		} else {
			nextButton = super.getButton("Finish");
			nextButton.setEnabled(true);
		}
	}

}
