package caslayout.util;

import guilib.AppFrame;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.Iterator;
import java.util.List;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;

import caslayout.ui.AbstractDisplayComponent;
import caslayout.ui.CAPanel;
import caslayout.ui.IDisplayComponent;
import caslayout.ui.Justification;
import caslayout.ui.RadioButtonDisplayComponent;
import caslayout.ui.ScoreLayoutPanel;
import caslayout.ui.TextDisplayComponent;
import caslayout.ui.model.Association;
import caslayout.ui.model.AssociationHelper;
import caslayout.ui.model.MandatoryFieldAssociation;
import caslayout.ui.model.ScoreAssociation;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: GUIUtils.java,v 1.15 2008/10/13 23:58:08 bozyurt Exp $
 */

public class GUIUtils {

   protected GUIUtils() {}

   public static String prepareTemplateScreenName(String filePath,
         String commonPath) {
      if (filePath.startsWith(commonPath)) {
         File f = new File(filePath);
         String name = f.getName();
         int idx = name.lastIndexOf('.');
         return (idx != -1) ? name.substring(0, idx) : name;
      }
      return null;
   }

   public static String prepareTemplateFilename(String templateScreenName,
         String templateDir) {
      StringBuffer buf = new StringBuffer(templateDir.length()
            + templateScreenName.length() + 8);
      buf.append(templateDir).append(File.separator).append(templateScreenName)
            .append(".xml");
      return buf.toString();
   }

   public static void showStatusMessage(JComponent component, String msg) {
      if (component == null)
         return;
      if (component instanceof ScoreLayoutPanel) {
         ScoreLayoutPanel slPanel = (ScoreLayoutPanel) component;
         AppFrame frame = (AppFrame) slPanel.getOwner();
         frame.getStatusBar().setText(msg);
      }
   }

   /**
    *
    * @param path
    *           the the path to the image file
    * @return
    */
   public static ImageIcon createImageIcon(String path) {
      java.net.URL imageURL = GUIUtils.class.getResource(path);
      if (imageURL != null) {
         return new ImageIcon(imageURL);
      } else {
         System.err.println("Can not find image:" + path);
         return null;
      }
   }

   public static boolean areAllTextDisplayComponents(List<IDisplayComponent> comps) {
      if (comps == null || comps.isEmpty())
         return false;
      for (Iterator<IDisplayComponent> iter = comps.iterator(); iter.hasNext();) {
         AbstractDisplayComponent adc = (AbstractDisplayComponent) iter.next();
         if (!(adc instanceof TextDisplayComponent))
            return false;
      }
      return true;
   }

   public static boolean areAllTextOrRadioDisplayComponents(List<IDisplayComponent> comps) {
      if (comps == null || comps.isEmpty())
         return false;
      for (Iterator<IDisplayComponent> iter = comps.iterator(); iter.hasNext();) {
         AbstractDisplayComponent adc = (AbstractDisplayComponent) iter.next();
         // ignore any containers selected
         if (adc instanceof CAPanel) {
            continue;
         }
         if (!(adc instanceof TextDisplayComponent)
               && !(adc instanceof RadioButtonDisplayComponent))
            return false;
      }
      return true;
   }

   /**
    * calculates upper left hand corner coordinates for the component after
    * alignment within the grid cell.
    *
    * @param boundRect
    *           the bounding rectangle for the grid cell
    * @param compDim
    *           the dimensions for the display component
    * @param alignment
    * @return
    */
   public static Point2D calculateAlignmentPosition(Rectangle2D boundRect,
         Dimension2D compDim, Justification alignment) {
      double width_margin = 3.0;

      Point2D point = new Point2D.Double();
      double x = 0, y = 0;
      if (alignment == Justification.LEFT_JUSTIFICATION) {
         y = boundRect.getY() + (boundRect.getHeight() - compDim.getHeight())
               / 2.0;
         x = boundRect.getX() + width_margin;
      } else if (alignment == Justification.RIGHT_JUSTIFICATION) {
         y = boundRect.getY() + (boundRect.getHeight() - compDim.getHeight())
               / 2.0;
         x = boundRect.getX()
               + (boundRect.getWidth() - compDim.getWidth() - width_margin);
         if (x < boundRect.getX())
            x = boundRect.getX() + width_margin;
      } else {
         y = boundRect.getY() + (boundRect.getHeight() - compDim.getHeight())
               / 2.0;
         x = boundRect.getX() + (boundRect.getWidth() - compDim.getWidth())
               / 2.0;
         if (x < boundRect.getX())
            x = boundRect.getX() + width_margin;
      }

      point.setLocation(x, y);

      return point;
   }

   public static String findAssociatedScoreName(String groupID, String id) {
      Association a = null;
      if (groupID != null) {
         a = AssociationHelper.getInstance().findScoreAssociation(groupID);
      } else if (id != null) {
         a = AssociationHelper.getInstance().findScoreAssociation(id);
      }

      if (a != null) {
         if (a instanceof ScoreAssociation) {
            ScoreAssociation sa = (ScoreAssociation) a;
            if (sa.getLeft() == null) {
               System.err.println("ScoreAssociation left was null "
                     + sa.getRight());
               return null;
            } else {
               return sa.getLeft().getScoreName();
            }
         } else {
            MandatoryFieldAssociation mfa = (MandatoryFieldAssociation) a;
            return mfa.getLeft();
         }
      }
      return null;
   }

   public static String toDisplaySize(String value, int maxSize) {
      if (value.length() < maxSize)
         return value;
      StringBuffer sb = new StringBuffer();
      sb.append(value.substring(0, maxSize - 3)).append("...");
      return sb.toString();
   }

   public static JMenuItem findMenuItem(String itemLabel, JMenu menu) {
      for (int i = 0; i < menu.getItemCount(); i++) {
         JMenuItem item = menu.getItem(i);
         if (item.getText().equals(itemLabel)) {
            return item;
         }
      }
      return null;
   }

   public static void drawSmallText(Graphics2D g2, String text, Color theColor,
         int x, int y) {
      Font oldFont = g2.getFont();
      int size = oldFont.getSize();
      Font newFont = new Font(oldFont.getName(), oldFont.getStyle(), size - 1);
      g2.setFont(newFont);

      // FontRenderContext frCtx = g2.getFontRenderContext();
      // Rectangle2D r = newFont.getStringBounds( text, frCtx);
      Color oldColor = g2.getColor();
      g2.setColor(theColor);
      g2.drawString(text, x, y);
      g2.setFont(oldFont);
      g2.setColor(oldColor);
   }

   /**
    * given the message content (can be any valid Swing or AWT component or
    * container shows a simple dialog box with only an OK button.
    *
    * @param comp
    * @param title
    * @param x
    * @param y
    */
   public static void handleMessageDialog(Component comp, String title, int x,
         int y) {
      JOptionPane pane = new JOptionPane(comp);
      JDialog dlg = pane.createDialog(pane, title);
      dlg.setLocation(x, y);
      dlg.setVisible(true);
   }

   public static Border createTitledBorder(String title, int padding) {
      Border lb = BorderFactory.createLineBorder(Color.darkGray);
      Border eb = BorderFactory.createEmptyBorder(padding, padding, padding,
            padding);
      Border cb = BorderFactory.createCompoundBorder(eb, lb);
      return BorderFactory.createTitledBorder(cb, title);
   }

   public static Border createTitledBorder(String title) {
      return createTitledBorder(title, 5);
   }

   public static JPanel createLabelFieldPanel(JLabel[] labels,
         JComponent[] fields, boolean adjustSize) {
      assert (labels.length == fields.length);
      JPanel panel = new JPanel(new BorderLayout(5, 5));
      panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
      JPanel labelPanel = new JPanel(new GridLayout(labels.length, 1, 5, 5));
      JPanel fieldPanel = new JPanel(new GridLayout(labels.length, 1, 5, 5));

      for (int i = 0; i < labels.length; i++) {
         labelPanel.add(labels[i]);
      }
      int height = 0;
      for (int i = 0; i < fields.length; i++) {
         fieldPanel.add(fields[i]);
         Dimension d = fields[i].getPreferredSize();
         int h = d.height + fields[i].getInsets().bottom
               + fields[i].getInsets().top;
         height += (h > 16) ? h : 16;
      }
      panel.add(labelPanel, BorderLayout.WEST);
      panel.add(fieldPanel);

      if (adjustSize) {
         Dimension d = panel.getPreferredSize();
         d.height = height;
         panel.setPreferredSize(d);
         panel.setMaximumSize(d);
      }

      return panel;
   }
}
