package caslayout.util;

import java.io.Writer;
import java.io.IOException;

public class HTMLUtils {
  protected HTMLUtils() {}

  public static void tableStart(Writer out) throws IOException {
    tableStart(out, 0, "100%");
  }

  public static void tableStart(Writer out, int border, String width) throws
      IOException {
    StringBuffer buf = new StringBuffer();
    buf.append(
        "<table class=\"as_table\" cellpadding=\"1\" cellspacing=\"1\" border=\"").
        append(border).append("\" width=\"");
    buf.append(width).append("\">\n");
    out.write(buf.toString());
  }

  public static void tableEnd(Writer out) throws IOException {
    out.write("</table>\n");
  }

  public static void tableRowStart(Writer out) throws IOException {
    out.write("<tr>\n");
  }

  public static void tableRowEnd(Writer out) throws IOException {
    out.write("</tr>\n");
  }

  public static void columnStartWithWidth(Writer out, int colIdx,
                                          int totColCount) throws IOException {
    StringBuffer buf = new StringBuffer();
    if ( (colIdx + 1) == totColCount) {
      out.write("<td class=\"as_td\">");
    }
    else {
      int percentage = 100 / totColCount;
      buf.append("<td class=\"as_td\" width=\"").append(percentage).append(
          "%\"> ");
      out.write(buf.toString());
    }
  }

  public static void columnStart(Writer out, int colSpan) throws IOException {
    StringBuffer buf = new StringBuffer();
    buf.append("<td colspan=\"").append(colSpan).append("\"> ");
    out.write(buf.toString());
  }

  public static void columnEnd(Writer out) throws IOException {
    out.write("</td>\n");
  }

}