package caslayout.util;

import java.util.Iterator;

import org.apache.log4j.Logger;

import caslayout.ui.AbstractDisplayComponent;
import caslayout.ui.CAContainer;
import caslayout.ui.CAPanel;
import caslayout.ui.Document;
import caslayout.ui.IDisplayComponent;
import caslayout.ui.Page;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: UIDManager.java,v 1.6 2008/10/13 23:58:08 bozyurt Exp $
 */
public class UIDManager {
   protected int uid = 0;
   protected static UIDManager instance;
   protected static Logger log = Logger.getLogger("UIDManager");

   protected UIDManager() {}

   public static synchronized UIDManager getInstance() {
      if (instance == null)
         instance = new UIDManager();
      return instance;
   }

   public synchronized void reset(Document doc) {
      if (doc == null)
         return;
      IDWrapper maxUID = new IDWrapper(Integer.MIN_VALUE);
      for (Iterator<Page> iter = doc.getPagesIterator(); iter.hasNext();) {
         Page page = iter.next();
         CAPanel panel = page.getViewPanel();
         findMaxUID(panel, maxUID);
      }
      uid = maxUID.getValue();
   }

   public synchronized String getNextUID() {
      uid++;
      // log.info("uid=" + uid);
      return "C" + uid;
   }

   protected void findMaxUID(AbstractDisplayComponent adc, IDWrapper curMax) {
      if (adc == null)
         return;
      String id = adc.getId();
      if (id != null) {
         int idNum = Integer.parseInt(id.substring(1));
         if (idNum > curMax.getValue())
            curMax.setValue(idNum);
      }

      if (adc instanceof CAContainer) {
         CAContainer c = (CAContainer) adc;
         for (Iterator<IDisplayComponent> iter = c.getComponents().iterator(); iter.hasNext();) {
            AbstractDisplayComponent item = (AbstractDisplayComponent) iter
                  .next();
            if (item != null) {
               findMaxUID(item, curMax);
            }
         }
      }
   }

   static class IDWrapper {
      int value;

      public IDWrapper(int value) {
         this.value = value;
      }

      public int getValue() {
         return value;
      }

      public void setValue(int newValue) {
         value = newValue;
      }

   }

}