package install;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;

import com.memoire.vainstall.AbstractCustomPrePost;
import com.memoire.vainstall.VAGlobals;
import com.memoire.vainstall.VAInstallStep;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: CustomPrePost.java,v 1.5 2008/10/13 23:58:08 bozyurt Exp $
 */
public class CustomPrePost extends AbstractCustomPrePost {
   public CustomPrePost() {}

   public static boolean postInstall(PrintWriter fileLog, VAInstallStep step)
         throws Exception {
      String configDir = VAGlobals.DEST_PATH + File.separator + "conf";
      String propsTemplateFile = configDir + File.separator
            + "caslayout.properties.example";
      String propsFile = configDir + File.separator + "caslayout.properties";
      String logTemplateFile = configDir + File.separator
            + "log4j.properties.example";
      String logFile = configDir + File.separator + "log4j.properties";
      String scriptTemplate = configDir + File.separator
            + "caslayout.sh.template";
      String scriptFile = VAGlobals.DEST_PATH + File.separator + "caslayout.sh";

      Map<String, String> macroMap = new HashMap<String, String>(3);
      macroMap.put("${DEST_PATH}", VAGlobals.DEST_PATH);
      step.details("Creating properties files...");
      filter(propsTemplateFile, propsFile, macroMap);
      filter(logTemplateFile, logFile, macroMap);
      filter(scriptTemplate, scriptFile, macroMap);
      if (System.getProperty("os.name").equalsIgnoreCase("linux")) {
         runCommand(new File(VAGlobals.DEST_PATH), new String[] { "/bin/chmod",
               "a+x", "caslayout.sh" }, step);
      }

      return true;
   }

   public static void filter(String inFile, String outFile, Map<String, String> macroMap) throws IOException {
    BufferedReader in = null;
    BufferedWriter out = null;
    try {
      in = new BufferedReader( new FileReader( inFile ) );
      out = new BufferedWriter( new FileWriter( outFile ) );
      String line = null;
      while ( ( line = in.readLine() ) != null) {
        if ( line.indexOf("${") != -1) {
          boolean replaced = false;
          do {
            replaced = false;
            for(Map.Entry<String, String> entry : macroMap.entrySet()) {
              String macro =  entry.getKey();
              if ( line.indexOf(macro) == -1) continue;
              String value =  entry.getValue();
              line = replaceMacro(macro, value, line);
              replaced = true;

            }
          } while (replaced );
        }// if
        out.write(line);
        out.newLine();
      }
    } finally {
      if (in != null) try { in.close(); } catch(Exception x) {}
      if (out != null) try { out.close(); } catch(Exception x) {}
    }

  }

   public static int findMacroLocation(String macro, String line) {
      return line.indexOf(macro);
   }

   public static String replaceMacro(String macro, String value, String line) {
      int idx = line.indexOf(macro);
      if (idx == -1)
         return line;
      StringBuffer buf = new StringBuffer(line.length() + 20);
      buf.append(line.substring(0, idx));
      buf.append(value).append(line.substring(idx + macro.length()));
      return buf.toString();
   }
}