#!/usr/bin/perl

use warnings;
use strict;

use DBI;
use File::Path;
use Getopt::Std;

sub get_experiments {
  my ($dbh) = @_;
  my $sth = $dbh->prepare("select name from nc_experiment");
  $sth->execute();
  my @exp_names = ();
  while(my @row = $sth->fetchrow()) {
     print $row[0] . "\n";
     push @exp_names, $row[0];
  }
  $sth->finish();
  return @exp_names;
}

sub get_exp_id {
   my($dbh, $exp_name) = @_;
   my $sth = $dbh->prepare('select uniqueid from nc_experiment where name= ?');   
   $sth->execute($exp_name);
   my $exp_id = undef;
   if (my @row = $sth->fetchrow()) {
        $exp_id = $row[0];
   }
   $sth->finish();
   return $exp_id;
}

sub get_sa_ids {
  my($dbh, $exp_name, $subjectid, $visit_id) = @_;
  my $sth = $dbh->prepare('select a.uniqueid from nc_storedassessment a, nc_experiment b where a.nc_experiment_uniqueid = b.uniqueid  and a.subjectid = ? and a.componentid = ? and b.name = ?');
  $sth->execute($subjectid, $visit_id, $exp_name);
  my @sa_list = ();
  while (my @row = $sth->fetchrow()) {
     push @sa_list , $row[0];
  }
  $sth->finish();
  return @sa_list;
}

sub del_assessment_values {
   my($dbh, $as_table,$sa_id) = @_;
   my $sql = "delete from $as_table where storedassessmentid = ?"; 
   my $sth = $dbh->prepare($sql);
   $sth->execute($sa_id);
   $sth->finish();
}
sub del_assessments {
   my($dbh, $sa_id) = @_;
   del_assessment_values($dbh,"nc_assessmentinteger",$sa_id);
   del_assessment_values($dbh,"nc_assessmentvarchar", $sa_id);
   del_assessment_values($dbh,"nc_assessmentfloat", $sa_id);
   del_assessment_values($dbh,"nc_assessmenttimestamp", $sa_id);
   del_assessment_values($dbh,"nc_assessmentboolean", $sa_id);
   my $sth = $dbh->prepare('delete from nc_storedassessment where uniqueid = ?');
   $sth->execute($sa_id);
   $sth->finish();
}


sub del_image_data {
   my ($dbh, $exp_id, $subjectid, $visit_id) = @_;
   my $sth = $dbh->prepare('select datauri from nc_rawdata where nc_experiment_uniqueid = ? and subjectid = ? and componentid = ?');
   $sth->execute($exp_id, $subjectid, $visit_id);
   my @images = ();
   while (my @row = $sth->fetchrow()) {
      push @images, $row[0];
   }
   $sth->finish();
   $sth = $dbh->prepare('select datauri from nc_deriveddata where nc_experiment_uniqueid = ? and subjectid = ? and componentid = ?');
   $sth->execute($exp_id, $subjectid, $visit_id);
   while (my @row = $sth->fetchrow()) {
      push @images, $row[0];
   }
   $sth->finish();

   $sth = $dbh->prepare('delete from nc_dataobject where dataid in (select uniqueid from nc_rawdata where nc_experiment_uniqueid = ? and subjectid = ? and componentid = ?)');
   $sth->execute($exp_id, $subjectid, $visit_id);
   $sth->finish();

   $sth = $dbh->prepare('delete from nc_rawdata where nc_experiment_uniqueid = ? and subjectid = ? and componentid = ?');
   $sth->execute($exp_id, $subjectid, $visit_id);
   $sth->finish();
   $sth = $dbh->prepare('delete from nc_deriveddata where nc_experiment_uniqueid = ? and subjectid = ? and componentid = ?');
   $sth->execute($exp_id, $subjectid, $visit_id);
   $sth->finish();

   return @images;
}

sub del_visit {
   my ($dbh,$exp_id, $subjectid, $visit_id) = @_;
   my $sth = $dbh->prepare('delete from nc_expsegment where nc_experiment_uniqueid = ? and subjectid = ? and componentid = ?');
   $sth->execute($exp_id, $subjectid, $visit_id);
   $sth->finish();
   $sth = $dbh->prepare('delete from nc_expstudy where experimentid = ? and subjectid = ? and componentid = ?');
   $sth->execute($exp_id, $subjectid, $visit_id);
   $sth->finish();
   $sth = $dbh->prepare('delete from nc_expcomponent where nc_experiment_uniqueid = ? and subjectid = ? and componentid = ?');
   $sth->execute($exp_id, $subjectid, $visit_id);
   $sth->finish();
}

sub del_subject_visit {
  my ($dbh, $exp_name, $subjectid, $visit_id) = @_;
  my $exp_id = get_exp_id($dbh, $exp_name);
  my @sa_id_list = get_sa_ids($dbh,$exp_name, $subjectid, $visit_id);
  foreach my $sa_id (@sa_id_list) {
     del_assessments($dbh,$sa_id); 
  }

  my @images = del_image_data($dbh, $exp_id, $subjectid, $visit_id);
  del_visit($dbh, $exp_id, $subjectid, $visit_id);
  foreach my $image_file (@images) {
      print "$image_file\n";
  }

  return @images;
}

sub del_image_files {
   my (@images) = @_;

}

sub find_common_root {
   my (@images) = @_;
   my $apath = $images[0];
   my @toks = split(/\//,$apath);
   my $idx = 0;
   for(my $i = 0; $i < @toks; $i++) {
     my $ok = 1;
     foreach my $image (@images) {
          my @parts = split(/\//, $image);
	  unless ($parts[$i] eq $toks[$i]) {
	      $ok = 0;
	      last;
	  }
     }
     if (!$ok) {
        $idx = $i - 1;
	last;
     }
   }
   my $cpath = join('/',@toks[0..$idx]);
   return $cpath;      
}


sub usage() {
die<<EOF

Deletes a subject's visit from the database including the imaging data.

Usage: $0 -d <database-name> -u <db-username> -p <db-pwd> -e <project-name> -s <subjectid> -v <visitid>
    
EOF
}

sub main() {
 my %opts = ();
 usage() unless (@ARGV == 12);
 getopt('d:u:p:e:s:v:',\%opts);
 my $db_name = $opts{d};
 my $dbuser = $opts{u};
 my $pwd = $opts{p};
 my $exp_name = $opts{e};
 my $subjectid = $opts{s};
 my $visit_id = $opts{v};

 my $dbh = DBI->connect("dbi:Pg:dbname=$db_name",$dbuser,$pwd,
    {RaiseError => 1, AutoCommit => 0});

 # get_experiments($dbh);

 local $@;
 eval {
    #my @images = del_subject_visit($dbh, "ASL","000870623805",1);
    my @images = del_subject_visit($dbh, $exp_name,$subjectid, $visit_id);
    my $common_root = find_common_root(@images);
    print "$common_root\n";
    if (-d $common_root) {
       print "deleting visit image data also ...\n";
       print "removing directory $common_root ...\n";
       #rmtree($common_root);
    }
    # $dbh->commit();
 };

 if ($@) {
   print "$@\n";
   # $dbh->rollback();
 }

 $dbh->rollback();
 $dbh->disconnect();
}

main();
