(function($) {

// optValues - an array of option values to remove
$.filterOptions=function(selectEl,optValues) {
   if (typeof(optValues) === 'undefined' || typeof(selectEl) === 'undefined') return;
   var options = $('option',selectEl);
	var selOpts = [];
	options.each(function() {
	   var value = $(this).attr('value');
		for(var i = 0; i < optValues.length; i++) {
          if (value == optValues[i]) {
              selOpts.push(this);
				  break;
			 }
		}
	});
	if (selOpts.length > 0) $(selOpts).remove();
};

$.reselectOptions=function(selectEl, optValues) {
    if (typeof(optValues) === 'undefined' || typeof(selectEl) === 'undefined') return;
    var options = $('option',selectEl);
	var valueMap = {};
	for(var i = 0; i < optValues.length; i++) {
      valueMap[optValues[i]] = optValues[i];
	}
	options.each(function() {
        var opt$ = $(this).removeAttr('selected');
	    var value = $(this).attr('value');
		var selValue = valueMap[value];
		if (selValue) {
          opt$.attr('selected','selected');
		}
	});
}

$.populateOtherSelect=function(selectEl, optValues, targetSel, compareFun) {
	 if (typeof(optValues) === 'undefined' || typeof(selectEl) === 'undefined') return;
	 var i, options = $('option',selectEl);
	 var targetOpts = $('option',targetSel);
	 var valueMap = {}, tvMap = {}, value;
 	 for(i = 0; i < optValues.length; i++) {
		  value = optValues[i];
	      valueMap[value] = value;
	 }	
 
	 options.each(function() {
		 var value = $(this).attr('value');
		 var selValue = valueMap[value];
		 if (selValue && !tvMap[value]) {
			 var text = $(this).text();
			 var option = new Option(text,value);
			 try {
				 targetSel.add(option, null);
			 } catch(e) {
				   targetSel.add(option, -1);
			 }
		 }
	 });

	 if (compareFun) {
		var finalOpts = $('option', targetSel);
		finalOpts.sort(compareFun);
		$(targetSel).empty().append(finalOpts);
	 }
}

$.populateSelect=function(selectEl,dataArr,optionGenFun, promptLabel) {
    $('option',selectEl).remove();
	 if (selectEl.options == null || selectEl.options.length == 0) {
	     var selIdx = 0, i, data, od, option;
        if (promptLabel) {
            option = new Option(promptLabel,'');
            option.selected = true;
            try {
               selectEl.add(option, null);
            } catch(e) {
               selectEl.add(option, -1);
            }
        }
        for(i = 0; i < dataArr.length; i++) {
            data = dataArr[i];
				od = optionGenFun(data);
            option = new Option(od.name, od.value);
				if (od.data) {
                $(option).data('ctx',od.data);
				}
            if (od.title) 
               $(option).data('title',od.title);
				if (i == 0 && !promptLabel) {
				   option.selected = true;
					selIdx = i;
				}
				try {
				   selectEl.add(option, null);
				} catch(e) {
                  selectEl.add(option, -1);
				}
		  }
	 }
};

$.submitQuery=function(elem, paramVal) {
     if (elem) {
       elem.form.actionParam.value=paramVal;
       elem.form.submit();
     }
     return false;
};

$.changeTab=function(form) {
   if (form) {
      form.submit();
   }
   return false;
};

})(jQuery);
