(function($) {
   $.isBlank = function(str) {
       return (!str || /^\s*$/.test(str) );
   };
   $.isValidNumeric = function(value, type) {
	   value = $.trim(value);
		if(value == '*') return true;
		if (type == 'integer' || type == 'INT') {
          return $.validInt(value);
		} else {
          return $.validNumber(value);
		}
   };
   $.validNumber = function(value) {
       return !isNaN($.trim(value));
   };
   $.validInt = function(value) {
	   value = $.trim(value);
      if (!isNaN(value)) {
          return /^[\-|\+]?\d+$/.test(value);
		}
		return false;
	};

  $.isValidTime = function(str) {
     var reg = /^[0-2][0-9]:[0-5][0-9]$/,
         tokens, hr;
     str = $.trim(str);
     if ( reg.test(str) ) {
        tokens = str.split(':');
        hr = tokens[0];
        if (hr > 24) { return false; }
     }
     return true; 
  };

	// mm/dd/yyyy format
	$.isValidDate = function(str) {
      str = $.trim(str);
      var daysOfMonths = new Array(31,28,31,30,31,30,31,31,30,31,30,31);
      var reg = /^[0-1]?[0-9]\/[0-3]?[0-9]\/[0-9][0-9][0-9][0-9]$/;
      if ( reg.test(str) ) {
        var tokens = str.split("/");
        var month = tokens[0];
        var day = tokens[1];
        var year = tokens[2];
        if (month > 12 || day > 31)
          return false;
        if ( month == "2") {
          if ( $.isLeapYear(year) ) {
            return day <= 29;
          } else {
            return day <= 28;
          }
        } else {
          return day <= daysOfMonths[ month - 1 ];
        }
     }
     return false;
	};
	$.isLeapYear = function(year) {
      if ((year % 4) != 0)
		  return false;
		if ( (year % 400) == 0)
		   return true;
		if ( (year % 100) == 0)
		   return false;
		return true;
	};
	$.checkNumberRange=function(lbNumStr,ubNumStr) {
       lbNumStr = $.trim(lbNumStr); 
       ubNumStr = $.trim(ubNumStr); 
		 var errMsg = '';
		 var lb = +lbNumStr;
		 var ub = +ubNumStr;
		 if (lb > ub) {
          errMsg += "The lower bound '" + lb + 
			   "' cannot be greater than the upper bound '" + ub + "'!"; 
		 } else if (lb == ub) {
          errMsg += "The lower bound '" + lb + 
			   "' cannot be same as the upper bound '" + ub + "'!"; 
		 }
		 return errMsg;
	};
	$.checkDateRange=function(lbDateStr,ubDateStr) {
		lbDateStr = $.trim(lbDateStr);
		ulDateStr = $.trim(ubDateStr);
		var errMsg = '';
		var tokens = lbDateStr.split("/");
		var lbMonth= +tokens[0];
		var lbDay= +tokens[1];
		var lbYear= +tokens[2];
		var tokens = ubDateStr.split("/");
		var ubMonth= +tokens[0];
		var ubDay= +tokens[1];
		var ubYear= +tokens[2];
		var lb = new Date(lbYear,lbMonth - 1,lbDay);
		var ub = new Date(ubYear,ubMonth - 1, ubDay);
		if (lb > ub) {
		   errMsg += "The start date '"+ lbDateStr + "' cannot be later than the end date '" +ubDateStr + "'!";
		} else if ( lb == ub) {
		   errMsg += "The start date '"+ lbDateStr + "' cannot be same as the end date '" +ubDateStr + "'!";
		}
		return errMsg;
	};

})(jQuery);
