package fbirn

import fbirn.ASLUploadInputGenerator.Demographics;

class DemographicsSource {
	def siMap = [:]
	
	def DemographicsSource() {
		load( "/home/bozyurt/dev/java/clinical/scripts/results/BIRN_demographics.csv")
	}
	static class SubjectInfo {
		String subjectID;
		String gender;
		String age;
		String diagnosis;
		
		static SubjectInfo create(String line) {
			def toks = line.split(/,/)
			String diagnosis = null
			// for traveling subjects 
			if (toks[3].equals('P')) {
				diagnosis = "traveling schizophrenic"
			} else if (toks[3].equals('C')) {
				diagnosis = "traveling control"
			}
			String subjectID = toks[0]
			int prefixSize = 12 - subjectID.length()
			subjectID = ('0' * prefixSize) + subjectID
			// println "subjectID:$subjectID" 
			String gender = toks[2]
			String age = toks[1]
			return new SubjectInfo(subjectID:subjectID, diagnosis:diagnosis, gender:gender, age:age)
		}
		
		@Override
		public String toString() {
			return "subjectID:$subjectID age:$age gender:$gender diagnosis:$diagnosis";
		}
	}
	
	def load(String csvFile) {
		new File(csvFile).eachLine {  line ->
		   SubjectInfo si = SubjectInfo.create(line)
		  //  println si
		   siMap[si.subjectID] = si
		}
	}
	
	String getGender(String subjectID) {
		SubjectInfo si = siMap[subjectID]
		if (si == null) return null
		return si.gender
	}
	
	String getAge(String subjectID) {
		SubjectInfo si = siMap[subjectID]
		if (si == null) return null
		return si.age
	}
	
	String getDiagnosis(String subjectID) {
		SubjectInfo si = siMap[subjectID]
		if (si == null) return null
		return si.diagnosis
	}
	
	public static void main(String[] args) {
		DemographicsSource ds = new DemographicsSource()
		println ds.getAge("000603242965")
		println " 001809270683 age:" + ds.getAge("001809270683")
	}
}
