package fbirn

import java.io.File;

import com.pixelmed.dicom.DicomFileUtilities;

class DicomUtils {
	
	static class VisitDemo {
		Demographics demographics;
		String subjectID;
		def visitId;
		def String type;
		def String timeStamp
		def String make
		def String model
	}
	
	static class Demographics {
		String birthDate
		int age
		String sex
		public String toString() {
			"[birthDate:$birthDate age:$age sex:$sex]"
		}
		
		public boolean hasSameBirthYear(int aBirthYear) {
			def matcher = birthDate =~ /(\d+)\/(\d+)\/(\d+)$/
			def birthYear = matcher[0][3].toInteger()
			return birthYear == aBirthYear
		}
	}
	
	def static getADicomFile(File rootDir) {
		def files = []
		rootDir.eachFileRecurse { File f -> if (f.file) files << f }
		if (files.empty) {
			return null
		}
		File dicomFile = null
		for(File f  in files) {
			if (DicomFileUtilities.isDicomOrAcrNemaFile(f.canonicalPath)) {
				dicomFile = f
				break
			}
		}
		return dicomFile
	}
	
	def static getDemographics(File rootDir) {
		def files = []
		rootDir.eachFileRecurse { File f -> 
			if (f.canonicalPath =~ /asl_fairest/) {
				files << f
			}
		}
		if (files.empty) {
			return null
		}
		File dicomFile = null
		for(File f  in files) {
			if (DicomFileUtilities.isDicomOrAcrNemaFile(f.canonicalPath)) {
				dicomFile = f;
				break;
			}
		}
		if (dicomFile == null) {
			return null
		}
		return getDemographicsFromDicom(dicomFile)
	}
	
	def static getVisitInfo(File t1Dir) {
		def files = []
		t1Dir.eachFileRecurse { File f -> if (f.file) files << f}
		if (files.empty) {
			return null
		}
		File dicomFile = null
		for(File f  in files) {
			if (DicomFileUtilities.isDicomOrAcrNemaFile(f.canonicalPath)) {
				dicomFile = f;
				break;
			}
		}
		if (dicomFile == null) {
			return null
		}
		def vd = getVisitInfoFromDicomFile(dicomFile)
		// add visit id
		
		return vd;
	}
	
	def static getVisitInfoFromDicomFile(File dcmFile) {
		def cmd = """dcmdump ${dcmFile.absolutePath}"""
		def proc = cmd.execute()
		proc.waitFor()
		String timeStamp = null
		String make = null
		String model = null
		proc.in.text.eachLine {
			if (it =~ /ManufacturerModelName/) model = it
			else if (it =~ /Manufacturer/) make = it
			else if (it =~ /StudyDate/) timeStamp = it
		}
		timeStamp = getDicomValue(timeStamp)
		make = getDicomValue(make)
		model = getDicomValue(model)
		
		if (timeStamp != null && timeStamp != '00000000') {
			def matcher = timeStamp =~ /(\d{4,4})(\d{2,2})(\d{2,2})$/
			timeStamp = matcher[0][2] + '/' + matcher[0][3] + '/' + matcher[0][1]
		} else {
			timeStamp = null
		}
		VisitDemo vd = new VisitDemo(timeStamp: timeStamp, make:make, model:model);
		
		Demographics dm = getDemographicsFromDicom(dcmFile);
		vd.demographics = dm
		return vd;
	}
	
	def static getDemographicsFromDicom(File dcmFile) {
		def cmd = """dcmdump ${dcmFile.absolutePath}"""
		def proc = cmd.execute()
		proc.waitFor()
		def birthDate = null
		def age = null
		def sex = null
		proc.in.text.eachLine { 
			if (it =~ /PatientBirthDate/) birthDate = it 
			else if (it =~ /PatientAge/) age = it
			else if (it =~ /PatientSex/) sex = it
		}
		
		birthDate = getDicomValue(birthDate)
		age = getDicomValue(age)
		sex = getDicomValue(sex)
		if (birthDate != null) {
			def matcher = birthDate =~ /(\d{4,4})(\d{2,2})(\d{2,2})$/
			birthDate = matcher[0][2] + '/' + matcher[0][3] + '/' + matcher[0][1]
		}
		if (age != null) {
			def m = age =~ /(\d+)Y/
			if (m) {
				age = m[0][1]
			} else {
				age = -1
			}
		}
		
		return new Demographics(birthDate: birthDate, age: age.toInteger(), sex: sex)
	}
	
	def static getDicomValue(line) {
		if (line == null) return null
		def m = line =~ /\[([^\]]+)\]/
		if (m) {
			return m[0][1]
		}
		return null
	}
	
	static void main(args) {
		File f = new File('/data/bozyurt/cbfbirn/upload/fBIRNPhaseIII__0090/uci/000989919547/Visit_10_28_2010_0009/asl_fairest/0046.dcm')
		println DicomUtils.getDemographicsFromDicom(f)
		
		File rootDir = new File('/data/bozyurt/cbfbirn/upload/fBIRNPhaseIII__0090/umn/001395444688/Visit_08_08_2011_0013')
		def d = DicomUtils.getDemographics(rootDir)
		println d
		assert d.hasSameBirthYear(1969)
	}
}
