package fbirn

import java.io.File;
import java.util.HashSet;

import java.util.Set;
import java.util.Map;


import fbirn.ASLImgDataOrganizer.VisitInfo;
import groovy.util.XmlSlurper;
import com.pixelmed.dicom.DicomFileUtilities;

class ECTSASLImgDataOrganizer {
	def String srcRoot = '/data/bozyurt/fbirn/ASL_from_tomlab/ECTS'
	def String destRoot = '/data/bozyurt/cbfbirn/upload'
	def DemographicsSource demSrc = new DemographicsSource()
	def ECTSVisitDateSource vdSrc = new ECTSVisitDateSource()
	def bwhVisitDateMap = [:]
	
	
	
	static class SeriesInfo {
		def String subjectId;
		def String visitId;
		def String siteId;
		def String seriesName;
		def String srcPath;
		def String magnetName;
		
		@Override
		public String toString() {
			return "[visitId:$visitId, siteId:$siteId, seriesName:$seriesName, magnetName:$magnetName,srcPath:$srcPath]"
		}
	}
	
	static class VisitInfo {
		def String subjectId;
		def visitId;
		def String type;
		def String timeStamp
		def siList = []
		File visitDestDir
		def studyContentMap = [:]
		def studyMap = [:]
		def Map<String, File> studyDestDirMap = [:]
		
		public String getKey() {
			return "${subjectId}:${visitId}"
		}
		
		public def prepStudyMap() {
			siList.each { si ->
				String key = si.magnetName
				if (key.length() == 0) key='default'
				def studySiList = studyMap[key]
				if (studySiList == null) {
					studySiList = []
					studyMap[key] = studySiList
				}
				studySiList << si
			}
			studyMap.keySet().each { k ->
				studyContentMap[k] = [:]
			}
			return studyMap
		}
		
		public String getDestVisitDirName() {
			def matcher = timeStamp =~ /(\d+)\-(\d+)\-(\d+)/
			if (!matcher) {
				// println "different timeStamp:$timeStamp"
				matcher = timeStamp =~ /(\d+)\/(\d+)\/(\d+)/
				return 'Visit_' + matcher[0][1] + '_' + matcher[0][2] + '_' + matcher[0][3]
			}
			return 'Visit_' + matcher[0][2] + '_' + matcher[0][3] + '_' + matcher[0][1]
		}
		
		@Override
		public String toString() {
			return "[subjectId:$subjectId, visitId:$visitId, type:$type, timeStamp:$timeStamp]"
		}
		
		def writeContents(String studyKey) {
			def visitDestDir = 	studyDestDirMap[studyKey]
			assert visitDestDir, "no visitDestDir for key:$studyKey"
			def contentMap = studyContentMap[studyKey]
			if (contentMap.empty) { return
			}
			
			def outFile = new File(visitDestDir,'CONTENTS')
			outFile.withWriter { writer ->
				contentMap.each {k,v ->
					writer.writeLine("${k}\t${v}")
				}
			}
		}
	}
	
	def prepSiteVisitMap(expInfoXmlFiles) {
		def sidMap = ['ucsd':'0008','uci':'0009','duke':'0003','ucsf':'0020','mrn':'0010','uiowa':'0012','umn':'0013','yale':'0018']
		def siteMap = [:]
		for(xmlFile in expInfoXmlFiles) {
			def name = new File(xmlFile).name
			def matcher = name =~ /\d_([^\.]+)\.xml$/
			name = matcher[0][1]
			// Yale is UCSF now
			if (name == 'ucsf') name = 'yale';
			def siteId = sidMap[name]
			assert siteId
			def visitMap = siteMap[siteId]
			if (visitMap == null) {
				visitMap = [:]
				siteMap[siteId] = visitMap
			}
			def xml = new XmlSlurper().parse(xmlFile)
			xml.subjects[0].subjExp.each { se ->
				// println se.'@subjectid'
				se.visit.each { v ->
					VisitInfo vi = new VisitInfo(subjectId: v.'@subjectid',visitId:v.'@componentid',
							timeStamp:v.'@timeStamp',type:v.'@visittype')
					visitMap.put vi.key, vi
				}
			}
		}
		println "siteMap - Meta data from the HID"
		println "-" * 60
		siteMap.each {k,vMap ->
			println "${k}:"
			vMap.each {key,v ->
				println "\t" + v.toString()
			}
		}
		return siteMap
	}
	
	def extractSourceSeries() {
		def siMap = [:]
		def expDir = new File("${srcRoot}")
		def subjectDirs = []
		expDir.eachFile { f ->
			if (f.directory && f.name.startsWith('00')) {
				def count = 0;
				f.eachFileRecurse {
					if (it.file) count++
				}
				if (count > 0) subjectDirs << f
			}
		}
		def suffixMap = [:]
		for(sDir in subjectDirs) {
			String subjectId = sDir.name
			def siList = siMap[subjectId]
			if (siList == null) {
				siList = []
				siMap[subjectId] = siList
			}
			
			def visitDirs = [];
			sDir.eachFile { f ->
				if (f.directory && f.name.startsWith("scanVisit")) visitDirs << f
			}
			for(vDir in visitDirs) {
				String s = vDir.name
				def matcher = s =~ /(\d+)__000(\d$)/
				// assert matcher.matches(), "no match for $s"
				def siteId = matcher[0][1]
				def visitId = matcher[0][2]
				
				def seriesDirs = []
				vDir.eachFile {
					if (it.directory && !it.name.equalsIgnoreCase("matlab") 
					&& !it.name.startsWith('bh') && !it.name.startsWith('wm')) seriesDirs << it
				}
				for(sd in seriesDirs) {
					sd.eachFileRecurse {f ->
						if (f.file) {
							def m = f.name =~ /\.(.+)$/
							m.each { all, suf ->
								suffixMap[suf] = suf
							}
						}
					}
					SeriesInfo si = new SeriesInfo(subjectId:subjectId, visitId:visitId,
							seriesName:sd.name, srcPath: sd.absolutePath, siteId:siteId, magnetName:'')
					siList << si
				}
			}
		}
		
		// strip any empty series and visits with missing ASL series
		def keys2Remove = []
		for(String subjectID in siMap.keySet()) {
			def siList = siMap[subjectID]
			def vrMap = [:]
			def si2RemList = []
			int numSeriesBefore = siList.size()
			for(SeriesInfo si in siList) {
				VisitRec vr = new VisitRec(visitId:si.visitId, siteId: si.siteId)
				String key = vr.getKey()
				if (vrMap[key] == null) {
					vrMap[key] = vr
				} else {
				   vr = vrMap[key]
				}
				if ( isDirEmpty(new File(si.srcPath))) {
					si2RemList << si
				} else {
					vr.siList << si
				}
			}
			if (!si2RemList.empty) {
				println "removing empty series for subject:$subjectID " + si2RemList
				siList = siList - si2RemList
			}
			for(VisitRec vr : vrMap.values()) {
				if (!vr.siList.empty && !vr.isEligible()) {
					String key = vr.getKey()
					println "removing empty visit series for subject:$subjectID ($key) " + vr.siList
					siList = siList - vr.siList
				}
			}
			int numSeriesAfter = siList.size()
			println "numSeriesBefore: $numSeriesBefore numSeriesAfter: $numSeriesAfter"
			if (siList.empty) {
				keys2Remove << subjectID
			} else {
			 siMap[subjectID] = siList
			}
		}
		keys2Remove.each  { key -> siMap.remove(key) }
		return siMap
	}
	
	static class VisitRec {
		def siList = [];
		def visitId;
		def siteId;
		
		String getKey() { return "${visitId}:${siteId}"}
		
		boolean isEligible() {
			int count = 0
			for(SeriesInfo si in siList) {
				if (si.seriesName.startsWith('asl') && isASLSeries(si)) {
					count++;
				}
			}
			if (count != 3) {
				
			}
			return count == 3
		}
	}
	
	def isDirEmpty(File dir) {
		def files = []
		dir.eachFile { files << it}
		return files.empty
	}
	
	def static boolean isASLSeries(SeriesInfo si) {
		def files = []
		File srcRoot = new File(si.srcPath)
		srcRoot.eachFileRecurse {f ->
			if (f.file && (isASLFile(f) ||  DicomFileUtilities.isDicomOrAcrNemaFile(f.canonicalPath))) files << f
		}
		if (!files.empty) return true
	}
	
	def prepVisitMapByDicom(siteMap, String siteId, String subjectid, siList) {
		if (siList.empty) {
			println "No series for $subjectid for site $siteId"
			return
		}
		def visitMap = siteMap[siteId];
		if (visitMap != null) {
			for(SeriesInfo si in siList) {
				String key = si.subjectId + ':' + si.visitId
				VisitInfo vi = visitMap[key]
			}
		}
		SeriesInfo theSi = null
		File t1Dir = null
		for(SeriesInfo si in siList) {
			if (si.siteId == siteId) {
				theSi = si
			}
			if (si.siteId == siteId && si.seriesName == 't1') {
				t1Dir = new File(si.srcPath)
				break
			}
		}
		if (t1Dir == null) {
			for(SeriesInfo si in siList) {
				if (si.siteId == siteId && si.seriesName == 'B0_mag1') {
					t1Dir = new File(si.srcPath)
					break
				}
			}
		}
		
		if (t1Dir == null) {
			if (theSi == null) {
				println "theSi was null"
			}
			println "**>> Neither t1 nor B0_mag1 skipping " + theSi.seriesName + " " + subjectId + " srcPath:" + theSi.srcPath
			return
		}
		
		String s = t1Dir.parentFile.name
		def matcher = s =~ /(\d+)__000(\d$)/
		// assert matcher.matches(), "no match for $s"
		String visitId = matcher[0][2]
		
		String theVisitDate = vdSrc.getVisitDate(subjectid, visitId.toInteger(), siteId)
		if (siteId == '0018' && theVisitDate != null) {
			println "yale visit lookup"
		}
		
		DicomUtils.VisitDemo vd = null
		
		if (theVisitDate != null) {
			vd = new DicomUtils.VisitDemo()
			vd.timeStamp = theVisitDate
			println "theVisitDate:${theVisitDate}"
		} else {
			vd = DicomUtils.getVisitInfo(t1Dir);
			
			if (vd == null || vd.timeStamp == null /* || vd.make == null || vd.model == null */) {
				println ">>> ***  no visit info from the DICOM header for t1:${t1Dir}";
				String aVisitDate = extractVisitDate(siList)
				if (aVisitDate != null) {
					vd = new DicomUtils.VisitDemo()
					vd.timeStamp = aVisitDate
					println "aVisitDate:${aVisitDate}"
				} else {
					println ">>> *** skipping visit ($t1Dir)" 
					return;
				}
			}
		}
		println "vd.timeStamp:${vd.timeStamp}"
		File dcmFile = DicomUtils.getADicomFile(t1Dir);
		DicomUtils.Demographics dem = null
		if (dcmFile != null) {
			dem = DicomUtils.getDemographicsFromDicom(dcmFile);
		}
		if (dem == null || dem.age == null || dem.sex == null || dem.birthDate == null) {
			println ">>> *** no demographics info from the DICOM header for t1:${t1Dir}";
			// return;
		}
		if (visitMap == null) {
			visitMap = [:]
			siteMap[siteId] = visitMap
		} 
		
		VisitInfo vi = null
		for(SeriesInfo si in siList) {
			String key = si.subjectId + ':' + si.visitId
			vi = visitMap[key]
			if (vi == null) {
				break;
			}
		}
		if (vi == null) {
			vi = new VisitInfo(subjectId: subjectid,visitId:visitId.toInteger(),
					timeStamp:vd.timeStamp,type:'scan')
			visitMap.put(vi.key, vi)
			println "added visit to visitMap " + vi.toString()
		}
	}
	
	// visitDate format 11/28/2007
	def extractVisitDate(siList) {
		File seriesDir = null
		for(SeriesInfo si in siList) {
			if (si.seriesName == 'B0_mag1') {
				seriesDir = new File(si.srcPath)
				break
			}
		}
		if (seriesDir == null) { return null
		}
		def dicomTarBalls = []
		def imageWrapperFile = null
		def files = []
		seriesDir.eachFileRecurse { files << it }
		
		
		files.each { f -> 
			if (isDicomTarBall(f)) dicomTarBalls << f
			if (f.name.equals('ImageWrapper.xml')) imageWrapperFile = f
		}
		
		File dicomDir = null
		if (imageWrapperFile == null){
			if (dicomTarBalls.size() > 0) {
				File destDir = new File("/tmp/ects")
				destDir.mkdir()
				dicomDir = new File(destRoot,'DICOM')
				if (dicomDir.directory) {
					// delete tmpDir and all its contents
					new AntBuilder().delete(dir: dicomDir.canonicalPath)
				}
				extractTarBall(dicomTarBalls[0].canonicalPath, destDir.canonicalPath)
				assert dicomDir.directory
				files = []
				dicomDir.eachFile { f ->  if (f.name.equals('ImageWrapper.xml')) imageWrapperFile = f }
			} else {
				return null
			}
		}
		
		if (imageWrapperFile != null) {
			def visitDateStr = null
			def xml = new XmlSlurper().parse(imageWrapperFile)
			xml.acqProtocol[0].acqParam.each { ap ->  
				def name = ap.'@name'
				if (name.equals("scandate") /*|| name.equals("psddate")*/) {
					String s = ap.text()
					if (visitDateStr == null && s.trim().length() > 0) {
						visitDateStr = s
					}
				}
			}
			if (visitDateStr != null) {
				println "visitDateStr:$visitDateStr"
				def toks = visitDateStr.split(/-/)
				String vt = "${toks[1]}/${toks[2]}/${toks[0]}"
				return vt;
			}
			return null
		}
		return null
	}
	
	def copy2Dest(String expName, siMap, siteMap) {
		def expDir = new File(destRoot, expName)
		expDir.mkdirs()
		def scanVisitMap = [:]
		
		siMap.each {subjectid, siList ->
			assert !siList.empty
			// String siteId = siList[0].siteId
			def vrMap = [:]
			for(SeriesInfo si : siList) {
				String key = "${si.visitId}:${si.siteId}"
				VisitRec vr = vrMap[key]
				if (vr == null) {
					vr = new VisitRec(visitId:si.visitId, siteId: si.siteId)
					vrMap[key] = vr
				}
				vr.siList << si
			}
			for(VisitRec vr : vrMap.values()) {
			   prepVisitMapByDicom(siteMap, vr.siteId, subjectid, vr.siList)
			}
		}
		
		println "siteMap - Meta data from the HID"
		println "-" * 60
		siteMap.each {k,vMap ->
			println "${k}:"
			vMap.each {key,v ->
				println "\t$key : " + v.toString()
			}
		}
		println "-" * 60
		
		
		MiscUtils.ECTSSubjectSource ess = new MiscUtils.ECTSSubjectSource()
		
		Set<String> missingFromVisitMapSet = []
		Set<String> foundInVisitMapSet = []
		siMap.each {subjectid, siList ->
			def subjDir = new File(expDir,subjectid)
			subjDir.mkdir()
			println '-' * 40
			for(SeriesInfo si in siList) {
				def visitMap = siteMap[si.siteId]
				if (visitMap == null) {
					println "&&&& ** no visitMap for si.siteId:${si.siteId} for $subjectid"
					//FIXME handle cases where there is no metadata from the database
					continue;
				}
				assert visitMap
				String key = si.subjectId + ':' + si.visitId
				VisitInfo vi = visitMap[key]
				if (vi == null) {
					println "*** No match for key:$key for site:${si.siteId}. Skipping series ..."
					missingFromVisitMapSet << "${si.siteId}:$key"
					continue;
				}
				assert vi
				foundInVisitMapSet << "${si.siteId}:$key"
				File srcDir = new File(si.srcPath)
				String name = srcDir.name
				if (name.startsWith('asl') || name == 't1' || name.startsWith('B0_')) {
					vi.siList << si
				}
			}
		}
		siteMap.values().each { visitMap ->
			visitMap.each {k, vi ->
				vi.prepStudyMap()
			}
		}
		int totVisitMap = 0
		siteMap.each { siteId , visitMap -> 
		    println "Site:$siteId - visitMap.size:" + visitMap.size()	
			totVisitMap += visitMap.size()
		}
		println "totVisitMap: $totVisitMap"
		println "=" * 60
		println "# missingFromVisitMapSet:" + missingFromVisitMapSet.size() 
		println "# foundInVisitMapSet:" + foundInVisitMapSet.size()
		println "missingFromVisitMapSet"
		println "-" * 40
		missingFromVisitMapSet.each { println it }
		println "-" * 40
		
		
		def viSet = [:]
		siMap.each {subjectid, siList ->
			def subjDir = new File(expDir,subjectid)
			subjDir.mkdir()
			println "$subjectid ..."
			for(SeriesInfo si in siList) {
				def visitMap = siteMap[si.siteId]
				if (visitMap == null) {
					println ">> No match in the siteMap for siteid:${si.siteId}. Skipping series..."
					continue;
				}
				assert visitMap
				String key = si.subjectId + ':' + si.visitId
				VisitInfo vi = visitMap[key]
				if (vi == null) {
					println "No visit. No match for key:$key for site:${si.siteId}. Skipping series ..."
					continue;
				}
				assert vi
				viSet["${vi.key}:${si.siteId}"] = vi
				
				if (!hasASL(vi)) {
					"No ASL for visit:" + vi.toString() + ". Skipping ..."
					continue
				}
				
				File srcDir = new File(si.srcPath)
				String name = srcDir.name
				if (name.startsWith('asl') || name == 't1' || name.startsWith('B0_')) {
					println "$subjectid - " + vi.destVisitDirName + ' ' + name + ' ' + srcDir
					File visitDir = new File(subjDir, vi.destVisitDirName +'_' + si.siteId);
					visitDir.mkdir();
					if (si.magnetName.length() > 0) {
						visitDir = new File(visitDir, si.magnetName);
						visitDir.mkdir();
						vi.studyDestDirMap[si.magnetName] = visitDir
					} else {
						vi.studyDestDirMap['default'] = visitDir
					}
				}
			}
		}
		
		println "visit Id - to dest dir map"
		println '-' * 40
		println viSet.size()
		viSet.each { key, vi ->		
			def vd = vi.studyDestDirMap['default']	
			if (vd == null) {
				vi.studyDestDirMap.each {k, v -> println "\t$k : $v" }
			}
			println "${key},${vi.visitId},$vd"
		} 
		//  TEST
		//  return
		
		siteMap.values().each { visitMap ->
			for(VisitInfo vi in visitMap.values()) {
				vi.studyMap.each { key,siList ->
					if (ess.isEligible(vi.subjectId)) {				
						println "${vi.subjectId} key:$key"
						if (vi.studyDestDirMap.containsKey(key) ) {
							prepDest(vi, siList, vi.studyDestDirMap[key], key)
						}
					}
				}
			}
		}
	}
	
	def prepDest(VisitInfo vi, siList, destRoot, studyKey) {
		println "preparing visit data for CBF upload (${vi.subjectId} ${vi.visitId} - ${siList[0].siteId})"
		if (hasSiemensB0(siList)) {
			for(SeriesInfo si in siList) {
				File srcRoot = new File(si.srcPath)
				def files = []
				srcRoot.eachFileRecurse { files << it }
				def dicomFile = files.find { f ->
					!f.name.endsWith('.xml') && 
							!f.name.endsWith('.gz') && DicomFileUtilities.isDicomOrAcrNemaFile(f.canonicalPath)
				}
				if (dicomFile) {
					println "dicom dir: ${dicomFile.parent}"
				}
				dispatchSeriesPrep(vi, si, files, destRoot, studyKey);
			}
		} else {
			for(SeriesInfo si in siList) {
				if (si.seriesName.startsWith('B0')) {
					continue;
				}
				File srcRoot = new File(si.srcPath)
				def files = []
				srcRoot.eachFileRecurse { files << it }
				dispatchSeriesPrep(vi, si, files, destRoot, studyKey);
			}
			// also handle GE B0 
			prepDestGEB0(vi, siList, destRoot, studyKey)
		}
	}
	
	def dispatchSeriesPrep(VisitInfo vi, SeriesInfo si, files, destRoot, studyKey) {
		def pfiles = []
		def dicomTarBalls = []
		def brikFiles = []
		def extraFiles = []
		def dicomFiles = []
		files.each { f ->
			if (isPFile(f)) pfiles << f
			else if (isDicomTarBall(f)) dicomTarBalls << f
			else if (isBrikFile(f)) brikFiles << f
			else if (f.name.equals('ImageWrapper.xml')) extraFiles << f
			else if (DicomFileUtilities.isDicomOrAcrNemaFile(f.canonicalPath)) dicomFiles << f
		}
		if (!pfiles.empty) {
			def pfile = pfiles[0]
			String name = pfile.name
			name = name.replaceFirst(/\..+$/,'.7')
			File dest = new File(destRoot,name)
			copyFile(pfile,dest)
			File wrapperFile = findInSameDirAs(pfile, extraFiles)
			if (wrapperFile != null) {
				String wfn = wrapperFile.name.replaceFirst(/\.xml$/,"_${si.seriesName}.xml")
				File wDest = new File(destRoot,wfn)
				copyFile(wrapperFile,wDest)
			}
			def contentMap = vi.studyContentMap[studyKey]
			contentMap[si.seriesName] = name
		} else if (!dicomTarBalls.empty) {
			def dtb = dicomTarBalls[0]
			extractTarBall(dtb.canonicalPath, destRoot.canonicalPath)
			File dicomDir = new File(destRoot,'DICOM')
			assert dicomDir.directory
			def destDir = new File(destRoot,si.seriesName)
			println "renaming $dicomDir to $destDir"
			dicomDir.renameTo(new File(destRoot,si.seriesName))
		} else if (!dicomFiles.empty) {
			File destDir = new File(destRoot,si.seriesName);
			destDir.mkdir();
			for(dcmFile in dicomFiles) {
				File dest = new File(destDir, dcmFile.name)
				copyFile(dcmFile,dest);
			}
		} else if (!brikFiles.empty) {
			String brikName = ''
			for(bf in brikFiles) {
				String name = si.seriesName + "+orig"
				name += (bf.name =~ /\.HEAD$/) ? '.HEAD' : '.BRIK'
				if (bf.name =~ /\.BRIK$/) { 
					brikName = name
				}
				File dest = new File(destRoot,name)
				copyFile(bf,dest)
			}
			File wrapperFile = findInSameDirAs(brikFiles[0], extraFiles)
			if (wrapperFile != null) {
				String wfn = wrapperFile.name.replaceFirst(/\.xml$/,"_${si.seriesName}.xml")
				File wDest = new File(destRoot,wfn)
				copyFile(wrapperFile,wDest)
			}
			def contentMap = vi.studyContentMap[studyKey]
			contentMap[si.seriesName] = brikName
		}
	}
	
	def boolean hasSiemensB0(siList) {
		def b0Series = []
		for(SeriesInfo si in siList) {
			if (si.seriesName.startsWith('B0')) {
				b0Series << si.seriesName;
			}
		}
		return (b0Series.size() == 2 && b0Series.contains('B0_phase1') && b0Series.contains('B0_mag1') )
	}
	
	def prepDestGEB0(VisitInfo vi, siList, destRoot, studyKey) {
		def dicomTarBalls = []
		for(SeriesInfo si in siList) {
			if (si.seriesName.startsWith('B0')) {
				File srcRoot = new File(si.srcPath)
				def files = []
				srcRoot.eachFileRecurse { files << it }
				files.each { f -> if (isDicomTarBall(f)) dicomTarBalls << f}
			}
		}
		// group fm1 and fm2
		def b01TarBalls = []
		def b02TarBalls = []
		if (dicomTarBalls.size() == 8) {
			dicomTarBalls.each { println it }
			dicomTarBalls.each { dtb ->
				if (dtb =~ /B0_mag1/ || dtb =~ /B0_phase1/ || dtb =~ /B0_real1/ || dtb =~ /B0_imag1/) { b01TarBalls << dtb
				}
				if (dtb =~ /B0_mag2/ || dtb =~ /B0_phase2/ || dtb =~ /B0_real2/ || dtb =~ /B0_imag2/) { b02TarBalls << dtb
				}
			}
			assert b01TarBalls.size() == 4
			for(dtb in b01TarBalls) {
				add2B0Dest(dtb, destRoot,'fm1');
			}
			for(dtb in b02TarBalls) {
				add2B0Dest(dtb, destRoot,'fm2');
			}
			println "finished GE b0 preparation for  ${vi.subjectId} - " + vi.visitDestDir
		}
	}
	
	def add2B0Dest(dtb, destRoot, destSeriesName) {
		extractTarBall(dtb.canonicalPath, destRoot.canonicalPath)
		File dicomDir = new File(destRoot,'DICOM')
		assert dicomDir.directory
		File destDir = new File(destRoot,destSeriesName)
		destDir.mkdir()
		moveFiles( dicomDir.canonicalPath, destDir.canonicalPath)
		boolean ok = dicomDir.delete()
	}
	
	static void copyFile(File src, File dest) {
		new AntBuilder().copy(file:"$src.canonicalPath",tofile:"$dest.canonicalPath",overwrite:'true')
	}
	
	def findInSameDirAs(File refFile, files) {
		for(f in files) {
			if (refFile.parent.equals(f.parent)) {
				return f
			}
		}
		return null
	}
	def hasASL(VisitInfo vi) {
		def files = []
		for(SeriesInfo si in vi.siList) {
			if (si.seriesName.toLowerCase().startsWith("asl")) {
				File srcRoot = new File(si.srcPath)
				srcRoot.eachFileRecurse {f ->
					if (f.file && (isASLFile(f) ||  DicomFileUtilities.isDicomOrAcrNemaFile(f.canonicalPath))) files << f
				}
				if (!files.empty) return true
			}
		}
		return !files.empty
	}
	
	
	
	def static isASLFile(File f) {
		String n = f.name;
		return (n =~ /\.7$/ || n =~ /\.7_PFILE$/ || n =~ /\.tar\.gz$/ || n =~ /\.HEAD$/ || n =~ /\.BRIK$/ )
	}
	
	def static isDicomDir(File dir) {
		def files = []
		dir.eachFile { f ->  if (f.file) files << f }
		for(File f in files) {
			if (DicomFileUtilities.isDicomOrAcrNemaFile(f.canonicalPath)) {
				return true;
			}
		}
		return false;
	}
	
	def static isDicomTarBall(File f) {
		f.name.equals('DICOM.tar.gz')
	}
	
	def static isPFile(File f) {
		String n = f.name;
		return (n =~ /\.7$/ || n =~ /\.7_PFILE$/)
	}
	
	def static isBrikFile(File f) {
		String n = f.name;
		return (n =~ /\.HEAD$/ || n =~ /\.BRIK$/)
	}
	
	def extractTarBall(String tarballPath, String dest) {
		def ant = new AntBuilder()
		ant.untar(src:tarballPath, dest:dest,compression:"gzip")
	}
	
	def moveFiles(String fromDir, String toDir) {
		def ant = new AntBuilder()
		ant.move(todir:toDir) { fileset(dir:fromDir) }
	}
	static void handle() {
		ECTSASLImgDataOrganizer aido = new ECTSASLImgDataOrganizer()
		def xmlRoot = '/home/bozyurt/dev/java/clinical/scripts/results'
		def siteMap = aido.prepSiteVisitMap([
			"${xmlRoot}/exp_FBIRNSubject2007TE__0050_duke.xml",
			"${xmlRoot}/exp_FBIRNSubject2007TE__0050_ucsf.xml"
		])
		
		def siMap = aido.extractSourceSeries()
		
		
		println siMap.size()
		int count = 0
		def vMap = [:]
		siMap.each {key, list ->
			println key
			list.each { si ->
				println "\t" + si.toString();
				count++
				def path = new File(si.srcPath).parent
				vMap[path] = path
			}
		}
		println "count:$count # of scanVisits:" + vMap.size()
		println '-' * 40
		
		aido.copy2Dest('FBIRNSubject2007TE__0050', siMap, siteMap);
	}
	
	static void main(args) {
		handle();
	}
}
