package fbirn

class ECTSVisitDateSource {
	def bwhSvMap = [:]
	def mghSvMap = [:]
	def yaleSvMap = [:]
	
	public ECTSVisitDateSource() {
		load()
	}
	
	static class SubjectVisit {
		String subjectID
		int visitID
		String visitStr
		String visitDate
		
		static SubjectVisit create(String line) {
			def toks = line.split(/,/)
			assert toks.size(), 3
			String vs = toks[1]
			def vsToks = vs.split(/__/)
			assert vsToks.size(), 3
			int visitID = vsToks[2].toInteger()
			return new SubjectVisit(subjectID:toks[0], visitStr:toks[1], visitDate:toks[2], visitID: visitID)
		}
		
		@Override
		public String toString() {
			return "subjectID:$subjectID visitID:$visitID visitDate:$visitDate";
		}
	}
	
	def load() {
		def csvFile = "/home/bozyurt/dev/java/clinical/scripts/fbirn_import/ects_mgh.txt"
		new File(csvFile).eachLine {  line ->
			SubjectVisit sv = SubjectVisit.create(line)
			String key = "${sv.subjectID}:${sv.visitID}"
			mghSvMap[key] = sv
		}
		csvFile = "/home/bozyurt/dev/java/clinical/scripts/fbirn_import/ects_bwh.txt"
		new File(csvFile).eachLine {  line ->
			SubjectVisit sv = SubjectVisit.create(line)
			String key = "${sv.subjectID}:${sv.visitID}"
			bwhSvMap[key] = sv
		}
		
		csvFile = "/home/bozyurt/dev/java/clinical/scripts/fbirn_import/ects_yale.txt"
		new File(csvFile).eachLine {  line ->
			SubjectVisit sv = SubjectVisit.create(line)
			String key = "${sv.subjectID}:${sv.visitID}"
			yaleSvMap[key] = sv
		}
	}

	
	String getVisitDate(String subjectID, int visitID, String site) {
		if (site == '0005') {
			site = 'bwh'
		} else if (site == '0006') {
		    site = 'mgh'
		} else if (site == '0018') {
		    site = 'yale'
		}
		String key = "${subjectID}:${visitID}"
		if (site == 'bwh') {
			return bwhSvMap[key]
		} else if (site == 'mgh') {
		   return mghSvMap[key]
		} else if (site == 'yale') {
		   return yaleSvMap[key]
		}
		return null
	}
}
