package fbirn.db;

import fbirn.util.GenUtils;
import groovy.sql.Sql;

class DBUtils {
  
  static testQuery(db) {
	  def fmt = new java.text.SimpleDateFormat('dd MMM yyy (HH:mm:ss)', Locale.US)		 
	  db.eachRow('select * from users') {user -> 
	  	 println user.user_name + ' ' +  fmt.format(user.mod_time)
	     println '-' * 40
	  }	 
  }
  
  
  static def getDb(String usersXMLFile, Map props) {
      assert props != null
      // println "usersXMLFile: $usersXMLFile - props: $props";
      def reader = new FileReader(usersXMLFile);
      def recs = new XmlParser().parse(reader);
	  def theDBElem = recs.databases[0].database.find { it.'@default' =='true'};
	  assert(theDBElem)
      def dbID = theDBElem.'@id';
      def theDBUserElem = recs.dbusers[0].dbuser.find { it.'@dbid' == dbID }
      assert theDBUserElem;
      // println "dbType=" + theDBElem.'db-type'[0].text();
      props.put('db.type',  theDBElem.'db-type'[0].text());
      props.put('db.url',theDBElem.'db-url'[0].text());
      props.put('db.user', theDBUserElem.'@name');
      props.put('db.pwd', theDBUserElem.'@pwd');
      
      def db = null;
	  if ( props.'db.type' == 'postgres') {
		  db = Sql.newInstance(props.'db.url', 
		    		 props.'db.user',props.'db.pwd',  
		    		 'org.postgresql.Driver');
	  } else {
	     db = Sql.newInstance(props.'db.url', 
	    		 props.'db.user',props.'db.pwd',  
	    		 'oracle.jdbc.driver.OracleDriver');
	  }  
	  return db  
  }
  
  public static String getAnswer(String msg=null) {
     def console = new BufferedReader(new InputStreamReader(System.in));
     def ans = null;
     while(true) {
        if (msg != null) print "$msg>>";
        ans = console.readLine().trim();
        if (ans.length() > 0)
           break;
     }
     return ans;
  }
  
  public static String getAnswerOrDefault(String defAns, String msg=null) {
     def console = new BufferedReader(new InputStreamReader(System.in));
     def ans = null;
     if (msg != null) print "$msg [$defAns]>>";
     ans = console.readLine().trim();
     if (ans.length() == 0) {
           ans = defAns;
     }
     return ans;
  }
  
  def public static getDatabaseUser(db) {
      def dao = new DatabaseuserDAO(db : db);
      def dbuList = dao.find();
      dbuList.eachWithIndex { vo, i ->
         print "$i) ";
         dao.dumpVO(vo);
      }
      def ans = getAnswer("Please select a databaseuser ");
      def dbu = dbuList.get( Integer.parseInt(ans) );
      return dbu;
  } 
  
  static void main(args) {
	 def props = GenUtils.loadProperties("gtools-oracle.properties")
	 assert props
     def db = Sql.newInstance(props.getProperty('db.url'), 
    		 props.getProperty('db.user'),props.getProperty('db.pwd'),  
    		 'oracle.jdbc.driver.OracleDriver')
        	 
	 def se = new SchemaExtractor();
	 def schemaXmlFile = '/home/bozyurt/dev/java/branch/BIRN/clinical/conf/gtools/schema.xml';
	 se.loadDBTables(db, 'FBIRN_TEST2', schemaXmlFile);
  }
}

class SchemaExtractor {
	def tableMap = [:];
	
	void loadDBTables(sql, schema, schemaXmlFile, loadViewsAlso = true) {
		def meta = sql.connection.metaData;
		def rs = meta.getCatalogs();
		while( rs.next()) {
			println rs.getString(1);			
		}
		def tableTypes = new String[1];
		tableTypes[0] ="TABLE";
		if ( loadViewsAlso) {
			tableTypes = new String[2];
			tableTypes[0] ="TABLE";
			tableTypes[1] ="VIEW";
		}
		
		def count = 0;
		
		rs = meta.getTables("", schema, "%", tableTypes);
		while( rs.next() ) {
			def tableName = rs.getString(3);
			println("table: $tableName")
			if (!tableName.toLowerCase().startsWith('nc_') ) {
				continue;
			}
			println("table: $tableName")			
			def table = new DBTable(sql, tableName, schema);
			tableMap[tableName] = table;
			table.numRows = getNumRows(sql, tableName);
			++count
			// if (count > 10) break;
		}
		
		
		buildXml( GenUtils.adjustPath(schemaXmlFile), tableMap);
		
		/*
		def outFile = new File( GenUtils.adjustPath("/home/bozyurt/dev/groovy/gtools/schema.dump"))
		tableMap.each {key, value -> 
		   // println value; 
		   // println '-' * 40
		   outFile << value << "\n";
		   outFile << "-" * 40 << "\n";
		 }
		*/
		
	}
	
	int getNumRows(sql, String tableName) {
		def count = 0;
		count = sql.firstRow("select count(*) as cnt from $tableName").getAt(0);
		
		return count;
	}
	
	void buildXml(String fname, tm) {
		def writer = new FileWriter(fname);
		def builder = new groovy.xml.MarkupBuilder(writer);
		println "tableMap: " << tm.size() <<  " - " << this; 
		builder.schema() {
			for(dt in tm.values()) {
				table(name: dt.name, sorted: dt.sorted, numCols: dt.columns.size(),  numRows: dt.numRows) {
					for(col in dt.columns) {
						column(name: col.name, type: col.type, width: col.width, fracDigit: col.fracDigit, primaryKey: col.primaryKey,
								pkOrder: col.pkOrder);
					}
					'exported-keys'() {
						for(ek in dt.exportedKeys) {						
							'exported-key'(name: ek.name, pkTableName: ek.pkTableName, pkColumnName: ek.pkColumnName,
									fkTableName: ek.fkTableName, fkColumnName : ek.fkColumnName, keySeq: ek.keySeq); 							
						}						
					}
					'imported-keys'() {
						for(ik in dt.importedKeys) {						
							'imported-key'(name: ik.name, pkTableName: ik.pkTableName, pkColumnName: ik.pkColumnName,
									fkTableName: ik.fkTableName, fkColumnName : ik.fkColumnName, keySeq: ik.keySeq); 							
						}						
					}
				}				
			}
		}
	}
	
}

class DBTable {
	String name;
	def columns = [];
	boolean sorted
	def importedKeys = [];
	def exportedKeys = [];
	int numRows;
	
	DBTable(sql, tableName, schema) {
		this.name = tableName;
		extractTableInfo(sql, tableName, schema);
	}
	
	void extractTableInfo(sql, tableName, schema) {
		def meta = sql.connection.metaData;
		def rs = meta.getColumns("", schema, tableName,"%");
		 while( rs.next()) {
			def col = new DBColumn(name: rs.getString(4), 
					type: rs.getString(6), width: rs.getInt(7),
					fracDigit: rs.getInt(9), order: rs.getInt(17));
			columns << col;		
		 }
		 
		 getPrimaryKeys(sql,tableName, schema)
		 getImportedKeys(sql, tableName, schema)
		 getExportedKeys(sql, tableName, schema)
	}
	
	String[] getColumnNames() {
		def colNames = [];
		columns.each { colNames << it.name }
		return colNames;
	}
	
	
	void getImportedKeys(sql,tableName, schema) {
		def meta = sql.connection.metaData;
		def rs = meta.getImportedKeys("", schema, tableName);
		while( rs.next()) {
		   def fk = new DBFK(name: rs.getString(12),
				   pkTableName: rs.getString(3), pkColumnName: rs.getString(4),
				   fkTableName: rs.getString(7), fkColumnName: rs.getString(8),
				   keySeq: rs.getInt(9));
		   this.importedKeys << fk;
		}
		rs.close();
	}
	
	void getExportedKeys(sql,tableName, schema) {
		def meta = sql.connection.metaData;
		def rs = meta.getExportedKeys("", schema, tableName);
		while( rs.next()) {
		   def fk = new DBFK(name: rs.getString(12),
				   pkTableName: rs.getString(3), pkColumnName: rs.getString(4),
				   fkTableName: rs.getString(7), fkColumnName: rs.getString(8),
				   keySeq: rs.getInt(9));
		   this.exportedKeys << fk;
		}
		rs.close()
	}
	
	private void getPrimaryKeys(sql,tableName, schema) {
		def meta = sql.connection.metaData;
		def rs = meta.getPrimaryKeys("", schema, tableName);
		while( rs.next()) {
			def pkName = rs.getString(4);
			for(col in columns) {
				if(col.name == pkName) {
					col.primaryKey = true;
					col.pkOrder = rs.getInt(5);
					break;
				}
			}
		}
		rs.close()
	}
	
	def getPKColumns() {
		def pkCols = [];
		columns.each { if ( it.primaryKey) pkCols << it }
		return pkCols;
	}
	
	def getPKIndices() {
		def idxs = [];
		columns.each { if (it.primaryKey) idxs << it.pkOrder }
		return idxs;
	}
	
	String toString() {
		def s = "$name : Columns:"
		for(cn in columns) { s <<= cn.name + ","; };
		s = s[0..-2];
		s <<= "\nPrimary Key: "
		def pkCols = getPKColumns();
		for(pkc in pkCols) { s <<= pkc.name + ","; };
		s = s[0..-2];
		s <<= "\nImported Keys (${importedKeys.size()})\nExported Keys (${exportedKeys.size()})";
		if ( importedKeys) {
			s <<= "\nImportedKeys:\n"
			importedKeys.each { s <<= it.toString() + "\n" }
		}
		if ( exportedKeys) {
			s <<= "\nExportedKeys:\n"
			exportedKeys.each { s <<= it.toString() + "\n" }
		}
		return s;
	}
}

class DBColumn {
	String name;
	String type;
	int width;
	int fracDigit
	boolean notNullable;
	int order;
	boolean primaryKey;
	int pkOrder;
	
	String toDDL() {
		def s = "$name  $type";
		if ( width > 0 && type != 'DATE') {
			s <<= "($width";
			if (fracDigit > 0) s <<= ",$fracDigit";
			s <<= ") "	
		} else {
			s << "  ";
		}
		if (notNullable) s <<= "NOT NULL"
		return s;
	}
}

class DBFK {
	String name;
	String pkTableName;
	String pkColumnName;
	String fkTableName;
	String fkColumnName;
	int keySeq;
	
	String toString() {
		def s = "DBFK::[$name\n\t";
		s <<= "fk: ${fkTableName}.$fkColumnName pk: ${pkTableName}.$pkColumnName ]"
		return s;
	}
}
