package clinical.cache;

import java.util.Map;

import clinical.web.Constants;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: CacheUtils.java 750 2012-12-03 20:45:56Z bozyurt $
 */
public class CacheUtils {
	public static Object getFromCache(String key) {
		Cache cache = CacheManager.getInstance().getCache("remote");
		Element el = cache.get(key);
		if (el == null)
			return null;
		return el.getObjectValue();
	}

	public static void put2Cache(String key, Object value) {
		Cache cache = CacheManager.getInstance().getCache("remote");
		Element el = new Element(key, value);
		cache.put(el);
	}

	public static synchronized void dropFromCache(String key) {
		Cache cache = CacheManager.getInstance().getCache("remote");
		cache.remove(key);
	}

	@SuppressWarnings("unchecked")
	public static Map<String, String> getDBID2SiteIDMap() {
		return (Map<String, String>) getFromCache(Constants.DBID2SITEID_MAP);
	}

	public static synchronized void removeFromDBID2SiteIDMap(String dbID) {
		@SuppressWarnings("unchecked")
		Map<String, String> dbID2SiteIDMap = (Map<String, String>) getFromCache(Constants.DBID2SITEID_MAP);
		if (dbID2SiteIDMap != null) {
			Cache cache = CacheManager.getInstance().getCache("remote");
			cache.removeQuiet(Constants.DBID2SITEID_MAP);
			dbID2SiteIDMap.remove(dbID);
			Element el = new Element(Constants.DBID2SITEID_MAP, dbID2SiteIDMap);
			el.setEternal(true);
			cache.put(el);
		}

	}

	public static synchronized String getDBID4SiteID(String siteID) {
		@SuppressWarnings("unchecked")
		Map<String, String> map = (Map<String, String>) getFromCache(Constants.DBID2SITEID_MAP);
		if (map == null) return null;
		for(Map.Entry<String, String> entry : map.entrySet()) {
			if (siteID.equals(entry.getValue())) {
				return entry.getKey();
			}
		}
		return null;
	}

	public static synchronized void addDBID2SiteIDRec(String dbId, String siteID) {
		@SuppressWarnings("unchecked")
		Map<String, String> dbID2SiteIDMap = (Map<String, String>) getFromCache(Constants.DBID2SITEID_MAP);
		if (dbID2SiteIDMap != null) {
			Cache cache = CacheManager.getInstance().getCache("remote");
			cache.removeQuiet(Constants.DBID2SITEID_MAP);
			dbID2SiteIDMap.put(dbId, siteID);
			Element el = new Element(Constants.DBID2SITEID_MAP, dbID2SiteIDMap);
			el.setEternal(true);
			cache.put(el);
		}

	}
}
