package clinical.server;

import java.sql.Connection;
import java.sql.DriverManager;
import java.util.List;

import clinical.server.dao.oracle.AssessmentscoreDAO;
import clinical.server.dao.oracle.DatabaseuserDAO;
import clinical.server.dao.oracle.ExpcomponentDAO;
import clinical.server.vo.Assessmentscore;
import clinical.server.vo.Databaseuser;
import clinical.server.vo.Expcomponent;

/**
 * @author I. Burak Ozyurt
 * @version $Id: Driver.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class Driver {

	public static void testDatabaseUser(Connection con) throws Exception {
		Databaseuser criteria = new Databaseuser();
		DatabaseuserDAO dao = new DatabaseuserDAO();
		List<Databaseuser> users = dao.find(con, criteria);
		for (Databaseuser dbUser : users) {
			System.out.println(dbUser);
		}
	}

	public static void testAssessmentScore(Connection con) throws Exception {
		Assessmentscore criteria = new Assessmentscore();
		AssessmentscoreDAO dao = new AssessmentscoreDAO();
		List<Assessmentscore> scores = dao.find(con, criteria);
		for (Assessmentscore score : scores) {
			System.out.println(score);
		}
	}

	public static void testExpComponent(Connection con) throws Exception {
		Expcomponent criteria = new Expcomponent();
		ExpcomponentDAO dao = new ExpcomponentDAO();
		List<Expcomponent> visits = dao.find(con, criteria);
		for (Expcomponent visit : visits) {
			System.out.println(visit);
		}
	}

	public static void usage() {
		System.err.println("java clinical.server.Driver <dbURL> <usr> <pwd>");
		System.err
				.println("\twhere dbURL has the following syntax jdbc:oracle:thin:@<host>:<port>:<sid>");
		System.exit(1);
	}

	public static void main(String[] args) {
		Connection con = null;
		if (args.length != 3)
			usage();

		String dbURL = args[0];
		String user = args[1];
		String pwd = args[2];

		try {
			Class.forName("oracle.jdbc.driver.OracleDriver");

			con = DriverManager.getConnection(dbURL, user, pwd);
			testDatabaseUser(con);
			System.out.println("assessment scores");
			testAssessmentScore(con);
			System.out.println("visits");
			testExpComponent(con);
		} catch (Exception x) {
			x.printStackTrace();
		} finally {
			if (con != null)
				try {
					con.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

}
