package clinical.server.dao.oracle;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.utils.OracleUtils;
import clinical.server.vo.Assessmentscore;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class AssessmentscoreDAO implements
		clinical.server.dao.AssessmentscoreDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public AssessmentscoreDAO() {}

	public void insert(Connection con, Assessmentscore bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_ASSESSMENTSCORE ");
			buf
					.append(" (ASSESSMENTID,SCORENAME,SCORESEQUENCE,SCORETYPE,TABLEID,UNIQUEID,OWNER,MODTIME,MODUSER,DEFAULTVALUE,NULLABLE,SCORELEVEL,PARENTASID,PARENTSCORE,ASSESSMENTONTOLOGY,ASSESSMENTCONCEPT,SECURITYCLASSIFICATION,MINANSWERS,MAXANSWERS,ISREQUIRED,ISEXCLUDED,ISNEW,ISMODIFIED,DESCRIPTION) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 24; ++i) {
				buf.append('?');
				if (i < 23)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (java.math.BigDecimal) bean.getAssessmentid(),
					Types.NUMERIC);
			ps.setObject(2, (String) bean.getScorename(), Types.VARCHAR);
			ps.setObject(3, (java.math.BigDecimal) bean.getScoresequence(),
					Types.NUMERIC);
			ps.setObject(4, (String) bean.getScoretype(), Types.VARCHAR);
			ps.setObject(5, (java.math.BigDecimal) bean.getTableid(),
					Types.NUMERIC);
			ps.setObject(6, (java.math.BigDecimal) bean.getUniqueid(),
					Types.NUMERIC);
			ps.setObject(7, (java.math.BigDecimal) bean.getOwner(), Types.NUMERIC);
			ps.setTimestamp(8, bean.getModtime() == null ? null
					: new java.sql.Timestamp(bean.getModtime().getTime()));
			ps.setObject(9, (java.math.BigDecimal) bean.getModuser(),
					Types.NUMERIC);
			ps.setObject(10, (String) bean.getDefaultvalue(), Types.VARCHAR);
			ps.setObject(11, boolean2Number((Boolean) bean.getNullable()),
					Types.NUMERIC);
			ps.setObject(12, (java.math.BigDecimal) bean.getScorelevel(),
					Types.NUMERIC);
			ps.setObject(13, (java.math.BigDecimal) bean.getParentasid(),
					Types.NUMERIC);
			ps.setObject(14, (String) bean.getParentscore(), Types.VARCHAR);
			ps.setObject(15, (String) bean.getAssessmentontology(), Types.VARCHAR);
			ps.setObject(16, (String) bean.getAssessmentconcept(), Types.VARCHAR);
			ps.setObject(17, (String) bean.getSecurityclassification(),
					Types.VARCHAR);
			ps.setObject(18, (java.math.BigDecimal) bean.getMinanswers(),
					Types.NUMERIC);
			ps.setObject(19, (java.math.BigDecimal) bean.getMaxanswers(),
					Types.NUMERIC);
			ps.setObject(20, boolean2Number((Boolean) bean.getIsrequired()),
					Types.NUMERIC);
			ps.setObject(21, boolean2Number((Boolean) bean.getIsexcluded()),
					Types.NUMERIC);
			ps.setObject(22, boolean2Number((Boolean) bean.getIsnew()),
					Types.NUMERIC);
			ps.setObject(23, boolean2Number((Boolean) bean.getIsmodified()),
					Types.NUMERIC);
			ps.setObject(24, OracleUtils.getCLOB(con, bean.getDescription()),
					Types.CLOB);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(Assessmentscore bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("ASSESSMENTID");
		buf.append(',');
		buf.append("SCORENAME");
		buf.append(',');
		buf.append("SCORESEQUENCE");
		buf.append(',');
		buf.append("SCORETYPE");
		buf.append(',');
		buf.append("TABLEID");
		buf.append(',');
		buf.append("UNIQUEID");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MODTIME");
		buf.append(',');
		buf.append("MODUSER");
		buf.append(',');
		buf.append("DEFAULTVALUE");
		buf.append(',');
		buf.append("NULLABLE");
		buf.append(',');
		buf.append("SCORELEVEL");
		buf.append(',');
		buf.append("PARENTASID");
		buf.append(',');
		buf.append("PARENTSCORE");
		buf.append(',');
		buf.append("ASSESSMENTONTOLOGY");
		buf.append(',');
		buf.append("ASSESSMENTCONCEPT");
		buf.append(',');
		buf.append("SECURITYCLASSIFICATION");
		buf.append(',');
		buf.append("MINANSWERS");
		buf.append(',');
		buf.append("MAXANSWERS");
		buf.append(',');
		buf.append("ISREQUIRED");
		buf.append(',');
		buf.append("ISEXCLUDED");
		buf.append(',');
		buf.append("ISNEW");
		buf.append(',');
		buf.append("ISMODIFIED");
		buf.append(',');
		buf.append("DESCRIPTION");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Assessmentscore bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getAssessmentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ASSESSMENTID=?");
			qi.values.add(bean.getAssessmentid());
			valueSet = true;
		}
		if (bean.getScorename() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("SCORENAME=?");
			qi.values.add(bean.getScorename());
			valueSet = true;
		}
		if (bean.getScoresequence() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("SCORESEQUENCE=?");
			qi.values.add(bean.getScoresequence());
			valueSet = true;
		}
		if (bean.getScoretype() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("SCORETYPE=?");
			qi.values.add(bean.getScoretype());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TABLEID=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UNIQUEID=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODTIME=?");
			qi.values.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODUSER=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getDefaultvalue() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("DEFAULTVALUE=?");
			qi.values.add(bean.getDefaultvalue());
			valueSet = true;
		}
		if (bean.getNullable() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("NULLABLE=?");
			qi.values.add(boolean2Number((Boolean) bean.getNullable()));
			valueSet = true;
		}
		if (bean.getScorelevel() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("SCORELEVEL=?");
			qi.values.add(bean.getScorelevel());
			valueSet = true;
		}
		if (bean.getParentasid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("PARENTASID=?");
			qi.values.add(bean.getParentasid());
			valueSet = true;
		}
		if (bean.getParentscore() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("PARENTSCORE=?");
			qi.values.add(bean.getParentscore());
			valueSet = true;
		}
		if (bean.getAssessmentontology() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ASSESSMENTONTOLOGY=?");
			qi.values.add(bean.getAssessmentontology());
			valueSet = true;
		}
		if (bean.getAssessmentconcept() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ASSESSMENTCONCEPT=?");
			qi.values.add(bean.getAssessmentconcept());
			valueSet = true;
		}
		if (bean.getSecurityclassification() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("SECURITYCLASSIFICATION=?");
			qi.values.add(bean.getSecurityclassification());
			valueSet = true;
		}
		if (bean.getMinanswers() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MINANSWERS=?");
			qi.values.add(bean.getMinanswers());
			valueSet = true;
		}
		if (bean.getMaxanswers() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MAXANSWERS=?");
			qi.values.add(bean.getMaxanswers());
			valueSet = true;
		}
		if (bean.getIsrequired() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ISREQUIRED=?");
			qi.values.add(boolean2Number((Boolean) bean.getIsrequired()));
			valueSet = true;
		}
		if (bean.getIsexcluded() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ISEXCLUDED=?");
			qi.values.add(boolean2Number((Boolean) bean.getIsexcluded()));
			valueSet = true;
		}
		if (bean.getIsnew() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ISNEW=?");
			qi.values.add(boolean2Number((Boolean) bean.getIsnew()));
			valueSet = true;
		}
		if (bean.getIsmodified() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ISMODIFIED=?");
			qi.values.add(boolean2Number((Boolean) bean.getIsmodified()));
			valueSet = true;
		}
		if (bean.getDescription() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("DESCRIPTION=?");
			qi.values.add(bean.getDescription());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Assessmentscore bean,
			Assessmentscore criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_ASSESSMENTSCORE SET ");

		if (bean.getAssessmentid() != null || bean.isNull("assessmentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ASSESSMENTID=? ");
			uqi.setValues.add(bean.getAssessmentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("assessmentid"), uqi);
			valueSet = true;
		}
		if (bean.getScorename() != null || bean.isNull("scorename")) {
			if (valueSet)
				buf.append(", ");
			buf.append("SCORENAME=? ");
			uqi.setValues.add(bean.getScorename());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("scorename"), uqi);
			valueSet = true;
		}
		if (bean.getScoresequence() != null || bean.isNull("scoresequence")) {
			if (valueSet)
				buf.append(", ");
			buf.append("SCORESEQUENCE=? ");
			uqi.setValues.add(bean.getScoresequence());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("scoresequence"), uqi);
			valueSet = true;
		}
		if (bean.getScoretype() != null || bean.isNull("scoretype")) {
			if (valueSet)
				buf.append(", ");
			buf.append("SCORETYPE=? ");
			uqi.setValues.add(bean.getScoretype());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("scoretype"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TABLEID=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UNIQUEID=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODTIME=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODUSER=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getDefaultvalue() != null || bean.isNull("defaultvalue")) {
			if (valueSet)
				buf.append(", ");
			buf.append("DEFAULTVALUE=? ");
			uqi.setValues.add(bean.getDefaultvalue());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("defaultvalue"), uqi);
			valueSet = true;
		}
		if (bean.getNullable() != null || bean.isNull("nullable")) {
			if (valueSet)
				buf.append(", ");
			buf.append("NULLABLE=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean.getNullable()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("nullable"), uqi);
			valueSet = true;
		}
		if (bean.getScorelevel() != null || bean.isNull("scorelevel")) {
			if (valueSet)
				buf.append(", ");
			buf.append("SCORELEVEL=? ");
			uqi.setValues.add(bean.getScorelevel());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("scorelevel"), uqi);
			valueSet = true;
		}
		if (bean.getParentasid() != null || bean.isNull("parentasid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("PARENTASID=? ");
			uqi.setValues.add(bean.getParentasid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("parentasid"), uqi);
			valueSet = true;
		}
		if (bean.getParentscore() != null || bean.isNull("parentscore")) {
			if (valueSet)
				buf.append(", ");
			buf.append("PARENTSCORE=? ");
			uqi.setValues.add(bean.getParentscore());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("parentscore"), uqi);
			valueSet = true;
		}
		if (bean.getAssessmentontology() != null
				|| bean.isNull("assessmentontology")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ASSESSMENTONTOLOGY=? ");
			uqi.setValues.add(bean.getAssessmentontology());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("assessmentontology"), uqi);
			valueSet = true;
		}
		if (bean.getAssessmentconcept() != null
				|| bean.isNull("assessmentconcept")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ASSESSMENTCONCEPT=? ");
			uqi.setValues.add(bean.getAssessmentconcept());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("assessmentconcept"), uqi);
			valueSet = true;
		}
		if (bean.getSecurityclassification() != null
				|| bean.isNull("securityclassification")) {
			if (valueSet)
				buf.append(", ");
			buf.append("SECURITYCLASSIFICATION=? ");
			uqi.setValues.add(bean.getSecurityclassification());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("securityclassification"), uqi);
			valueSet = true;
		}
		if (bean.getMinanswers() != null || bean.isNull("minanswers")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MINANSWERS=? ");
			uqi.setValues.add(bean.getMinanswers());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("minanswers"), uqi);
			valueSet = true;
		}
		if (bean.getMaxanswers() != null || bean.isNull("maxanswers")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MAXANSWERS=? ");
			uqi.setValues.add(bean.getMaxanswers());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("maxanswers"), uqi);
			valueSet = true;
		}
		if (bean.getIsrequired() != null || bean.isNull("isrequired")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ISREQUIRED=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean.getIsrequired()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("isrequired"), uqi);
			valueSet = true;
		}
		if (bean.getIsexcluded() != null || bean.isNull("isexcluded")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ISEXCLUDED=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean.getIsexcluded()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("isexcluded"), uqi);
			valueSet = true;
		}
		if (bean.getIsnew() != null || bean.isNull("isnew")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ISNEW=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean.getIsnew()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("isnew"), uqi);
			valueSet = true;
		}
		if (bean.getIsmodified() != null || bean.isNull("ismodified")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ISMODIFIED=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean.getIsmodified()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("ismodified"), uqi);
			valueSet = true;
		}
		if (bean.getDescription() != null || bean.isNull("description")) {
			if (valueSet)
				buf.append(", ");
			buf.append("DESCRIPTION=? ");
			uqi.setValues.add(bean.getDescription());
			uqi.sqlTypes.add(new Integer(Types.CLOB));
			prepareNullSetListValue(bean.isNull("description"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	protected Boolean convert2Boolean(Object columnValue) {
		if (columnValue == null)
			return null;
		return ((java.math.BigDecimal) columnValue).intValue() > 0 ? new Boolean(
				true) : new Boolean(false);
	}

	protected BigDecimal boolean2Number(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? new java.math.BigDecimal("1")
				: new java.math.BigDecimal("0");
	}

	protected String boolean2YN(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? "Y" : "N";
	}

	public Assessmentscore createObject(ResultSet rs) throws SQLException {
		Assessmentscore obj = new Assessmentscore();
		obj.setAssessmentid((java.math.BigDecimal) rs.getObject(1));
		obj.setScorename((String) rs.getObject(2));
		obj.setScoresequence((java.math.BigDecimal) rs.getObject(3));
		obj.setScoretype((String) rs.getObject(4));
		obj.setTableid((java.math.BigDecimal) rs.getObject(5));
		obj.setUniqueid((java.math.BigDecimal) rs.getObject(6));
		obj.setOwner((java.math.BigDecimal) rs.getObject(7));
		if (rs.getTimestamp(8) != null) {
			obj.setModtime(new java.util.Date(rs.getTimestamp(8).getTime()));
		}
		obj.setModuser((java.math.BigDecimal) rs.getObject(9));
		obj.setDefaultvalue((String) rs.getObject(10));
		obj.setNullable(convert2Boolean(rs.getObject(11)));
		obj.setScorelevel((java.math.BigDecimal) rs.getObject(12));
		obj.setParentasid((java.math.BigDecimal) rs.getObject(13));
		obj.setParentscore((String) rs.getObject(14));
		obj.setAssessmentontology((String) rs.getObject(15));
		obj.setAssessmentconcept((String) rs.getObject(16));
		obj.setSecurityclassification((String) rs.getObject(17));
		obj.setMinanswers((java.math.BigDecimal) rs.getObject(18));
		obj.setMaxanswers((java.math.BigDecimal) rs.getObject(19));
		obj.setIsrequired(convert2Boolean(rs.getObject(20)));
		obj.setIsexcluded(convert2Boolean(rs.getObject(21)));
		obj.setIsnew(convert2Boolean(rs.getObject(22)));
		obj.setIsmodified(convert2Boolean(rs.getObject(23)));
		obj.setDescription(OracleUtils.readCLOB((oracle.sql.CLOB) rs
				.getObject(24)));
		return obj;
	}

	public List<Assessmentscore> find(Connection con, Assessmentscore criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Assessmentscore> results = new LinkedList<Assessmentscore>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_ASSESSMENTSCORE ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Assessmentscore item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Assessmentscore bean,
			Assessmentscore criteria) throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Assessmentscore criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_ASSESSMENTSCORE ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
