package clinical.server.dao.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.utils.OracleUtils;
import clinical.server.vo.Assessmentscorecode;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class AssessmentscorecodeDAO implements
		clinical.server.dao.AssessmentscorecodeDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public AssessmentscorecodeDAO() {}

	public void insert(Connection con, Assessmentscorecode bean)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_ASSESSMENTSCORECODE ");
			buf
					.append(" (ASSESSMENTID,SCORENAME,SCORECODE,SCORECODELABEL,TABLEID,UNIQUEID,OWNER,MODTIME,MODUSER,SCORECODEVALUE,SCORECODETYPE,DESCRIPTION,ONTOLOGYSOURCE,CONCEPTID) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 14; ++i) {
				buf.append('?');
				if (i < 13)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (java.math.BigDecimal) bean.getAssessmentid(),
					Types.NUMERIC);
			ps.setObject(2, (String) bean.getScorename(), Types.VARCHAR);
			ps.setObject(3, (String) bean.getScorecode(), Types.VARCHAR);
			ps.setObject(4, (String) bean.getScorecodelabel(), Types.VARCHAR);
			ps.setObject(5, (java.math.BigDecimal) bean.getTableid(),
					Types.NUMERIC);
			ps.setObject(6, (java.math.BigDecimal) bean.getUniqueid(),
					Types.NUMERIC);
			ps.setObject(7, (java.math.BigDecimal) bean.getOwner(), Types.NUMERIC);
			ps.setTimestamp(8, bean.getModtime() == null ? null
					: new java.sql.Timestamp(bean.getModtime().getTime()));
			ps.setObject(9, (java.math.BigDecimal) bean.getModuser(),
					Types.NUMERIC);
			ps.setObject(10, (String) bean.getScorecodevalue(), Types.VARCHAR);
			ps.setObject(11, (String) bean.getScorecodetype(), Types.VARCHAR);
			ps.setObject(12, OracleUtils.getCLOB(con, bean.getDescription()),
					Types.CLOB);
			ps.setObject(13, (String) bean.getOntologysource(), Types.VARCHAR);
			ps.setObject(14, (String) bean.getConceptid(), Types.VARCHAR);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(Assessmentscorecode bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("ASSESSMENTID");
		buf.append(',');
		buf.append("SCORENAME");
		buf.append(',');
		buf.append("SCORECODE");
		buf.append(',');
		buf.append("SCORECODELABEL");
		buf.append(',');
		buf.append("TABLEID");
		buf.append(',');
		buf.append("UNIQUEID");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MODTIME");
		buf.append(',');
		buf.append("MODUSER");
		buf.append(',');
		buf.append("SCORECODEVALUE");
		buf.append(',');
		buf.append("SCORECODETYPE");
		buf.append(',');
		buf.append("DESCRIPTION");
		buf.append(',');
		buf.append("ONTOLOGYSOURCE");
		buf.append(',');
		buf.append("CONCEPTID");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Assessmentscorecode bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getAssessmentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ASSESSMENTID=?");
			qi.values.add(bean.getAssessmentid());
			valueSet = true;
		}
		if (bean.getScorename() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("SCORENAME=?");
			qi.values.add(bean.getScorename());
			valueSet = true;
		}
		if (bean.getScorecode() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("SCORECODE=?");
			qi.values.add(bean.getScorecode());
			valueSet = true;
		}
		if (bean.getScorecodelabel() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("SCORECODELABEL=?");
			qi.values.add(bean.getScorecodelabel());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TABLEID=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UNIQUEID=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODTIME=?");
			qi.values.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODUSER=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getScorecodevalue() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("SCORECODEVALUE=?");
			qi.values.add(bean.getScorecodevalue());
			valueSet = true;
		}
		if (bean.getScorecodetype() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("SCORECODETYPE=?");
			qi.values.add(bean.getScorecodetype());
			valueSet = true;
		}
		if (bean.getDescription() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("DESCRIPTION=?");
			qi.values.add(bean.getDescription());
			valueSet = true;
		}
		if (bean.getOntologysource() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("ONTOLOGYSOURCE=?");
			qi.values.add(bean.getOntologysource());
			valueSet = true;
		}
		if (bean.getConceptid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("CONCEPTID=?");
			qi.values.add(bean.getConceptid());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Assessmentscorecode bean,
			Assessmentscorecode criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_ASSESSMENTSCORECODE SET ");

		if (bean.getAssessmentid() != null || bean.isNull("assessmentid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ASSESSMENTID=? ");
			uqi.setValues.add(bean.getAssessmentid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("assessmentid"), uqi);
			valueSet = true;
		}
		if (bean.getScorename() != null || bean.isNull("scorename")) {
			if (valueSet)
				buf.append(", ");
			buf.append("SCORENAME=? ");
			uqi.setValues.add(bean.getScorename());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("scorename"), uqi);
			valueSet = true;
		}
		if (bean.getScorecode() != null || bean.isNull("scorecode")) {
			if (valueSet)
				buf.append(", ");
			buf.append("SCORECODE=? ");
			uqi.setValues.add(bean.getScorecode());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("scorecode"), uqi);
			valueSet = true;
		}
		if (bean.getScorecodelabel() != null || bean.isNull("scorecodelabel")) {
			if (valueSet)
				buf.append(", ");
			buf.append("SCORECODELABEL=? ");
			uqi.setValues.add(bean.getScorecodelabel());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("scorecodelabel"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TABLEID=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UNIQUEID=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODTIME=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODUSER=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getScorecodevalue() != null || bean.isNull("scorecodevalue")) {
			if (valueSet)
				buf.append(", ");
			buf.append("SCORECODEVALUE=? ");
			uqi.setValues.add(bean.getScorecodevalue());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("scorecodevalue"), uqi);
			valueSet = true;
		}
		if (bean.getScorecodetype() != null || bean.isNull("scorecodetype")) {
			if (valueSet)
				buf.append(", ");
			buf.append("SCORECODETYPE=? ");
			uqi.setValues.add(bean.getScorecodetype());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("scorecodetype"), uqi);
			valueSet = true;
		}
		if (bean.getDescription() != null || bean.isNull("description")) {
			if (valueSet)
				buf.append(", ");
			buf.append("DESCRIPTION=? ");
			uqi.setValues.add(bean.getDescription());
			uqi.sqlTypes.add(new Integer(Types.CLOB));
			prepareNullSetListValue(bean.isNull("description"), uqi);
			valueSet = true;
		}
		if (bean.getOntologysource() != null || bean.isNull("ontologysource")) {
			if (valueSet)
				buf.append(", ");
			buf.append("ONTOLOGYSOURCE=? ");
			uqi.setValues.add(bean.getOntologysource());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("ontologysource"), uqi);
			valueSet = true;
		}
		if (bean.getConceptid() != null || bean.isNull("conceptid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("CONCEPTID=? ");
			uqi.setValues.add(bean.getConceptid());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("conceptid"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public Assessmentscorecode createObject(ResultSet rs) throws SQLException {
		Assessmentscorecode obj = new Assessmentscorecode();
		obj.setAssessmentid((java.math.BigDecimal) rs.getObject(1));
		obj.setScorename((String) rs.getObject(2));
		obj.setScorecode((String) rs.getObject(3));
		obj.setScorecodelabel((String) rs.getObject(4));
		obj.setTableid((java.math.BigDecimal) rs.getObject(5));
		obj.setUniqueid((java.math.BigDecimal) rs.getObject(6));
		obj.setOwner((java.math.BigDecimal) rs.getObject(7));
		if (rs.getTimestamp(8) != null) {
			obj.setModtime(new java.util.Date(rs.getTimestamp(8).getTime()));
		}
		obj.setModuser((java.math.BigDecimal) rs.getObject(9));
		obj.setScorecodevalue((String) rs.getObject(10));
		obj.setScorecodetype((String) rs.getObject(11));
		obj.setDescription(OracleUtils.readCLOB((oracle.sql.CLOB) rs
				.getObject(12)));
		obj.setOntologysource((String) rs.getObject(13));
		obj.setConceptid((String) rs.getObject(14));
		return obj;
	}

	public List<Assessmentscorecode> find(Connection con,
			Assessmentscorecode criteria) throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Assessmentscorecode> results = new LinkedList<Assessmentscorecode>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_ASSESSMENTSCORECODE ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Assessmentscorecode item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Assessmentscorecode bean,
			Assessmentscorecode criteria) throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Assessmentscorecode criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_ASSESSMENTSCORECODE ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
