package clinical.server.dao.oracle;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.ConfDatabase;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class ConfDatabaseDAO implements clinical.server.dao.ConfDatabaseDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public ConfDatabaseDAO() {}

	public void insert(Connection con, ConfDatabase bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_CONF_DATABASE ");
			buf
					.append(" (UNIQUE_ID,DB_ID,IS_DEFAULT,DB_URL,DB_TYPE,OWNER,MOD_TIME,MOD_USER,FORCE_SCHEMA_OWNER_CHECK,SITE_UNIQUE_ID) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 10; ++i) {
				buf.append('?');
				if (i < 9)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (java.math.BigDecimal) bean.getUniqueId(),
					Types.NUMERIC);
			ps.setObject(2, (String) bean.getDbId(), Types.VARCHAR);
			ps.setObject(3, boolean2Number((Boolean) bean.getIsDefault()),
					Types.NUMERIC);
			ps.setObject(4, (String) bean.getDbUrl(), Types.VARCHAR);
			ps.setObject(5, (String) bean.getDbType(), Types.VARCHAR);
			ps.setObject(6, (java.math.BigDecimal) bean.getOwner(), Types.NUMERIC);
			ps.setTimestamp(7, bean.getModTime() == null ? null
					: new java.sql.Timestamp(bean.getModTime().getTime()));
			ps.setObject(8, (java.math.BigDecimal) bean.getModUser(),
					Types.NUMERIC);
			ps.setObject(9, boolean2Number((Boolean) bean
					.getForceSchemaOwnerCheck()), Types.NUMERIC);
			ps.setObject(10, (java.math.BigDecimal) bean.getSiteUniqueId(),
					Types.NUMERIC);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(ConfDatabase bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("UNIQUE_ID");
		buf.append(',');
		buf.append("DB_ID");
		buf.append(',');
		buf.append("IS_DEFAULT");
		buf.append(',');
		buf.append("DB_URL");
		buf.append(',');
		buf.append("DB_TYPE");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MOD_TIME");
		buf.append(',');
		buf.append("MOD_USER");
		buf.append(',');
		buf.append("FORCE_SCHEMA_OWNER_CHECK");
		buf.append(',');
		buf.append("SITE_UNIQUE_ID");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(ConfDatabase bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getUniqueId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UNIQUE_ID=?");
			qi.values.add(bean.getUniqueId());
			valueSet = true;
		}
		if (bean.getDbId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("DB_ID=?");
			qi.values.add(bean.getDbId());
			valueSet = true;
		}
		if (bean.getIsDefault() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("IS_DEFAULT=?");
			qi.values.add(boolean2Number((Boolean) bean.getIsDefault()));
			valueSet = true;
		}
		if (bean.getDbUrl() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("DB_URL=?");
			qi.values.add(bean.getDbUrl());
			valueSet = true;
		}
		if (bean.getDbType() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("DB_TYPE=?");
			qi.values.add(bean.getDbType());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModTime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MOD_TIME=?");
			qi.values.add(new java.sql.Timestamp(bean.getModTime().getTime()));
			valueSet = true;
		}
		if (bean.getModUser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MOD_USER=?");
			qi.values.add(bean.getModUser());
			valueSet = true;
		}
		if (bean.getForceSchemaOwnerCheck() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("FORCE_SCHEMA_OWNER_CHECK=?");
			qi.values
					.add(boolean2Number((Boolean) bean.getForceSchemaOwnerCheck()));
			valueSet = true;
		}
		if (bean.getSiteUniqueId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("SITE_UNIQUE_ID=?");
			qi.values.add(bean.getSiteUniqueId());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(ConfDatabase bean,
			ConfDatabase criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_CONF_DATABASE SET ");

		if (bean.getUniqueId() != null || bean.isNull("uniqueId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UNIQUE_ID=? ");
			uqi.setValues.add(bean.getUniqueId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueId"), uqi);
			valueSet = true;
		}
		if (bean.getDbId() != null || bean.isNull("dbId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("DB_ID=? ");
			uqi.setValues.add(bean.getDbId());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("dbId"), uqi);
			valueSet = true;
		}
		if (bean.getIsDefault() != null || bean.isNull("isDefault")) {
			if (valueSet)
				buf.append(", ");
			buf.append("IS_DEFAULT=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean.getIsDefault()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("isDefault"), uqi);
			valueSet = true;
		}
		if (bean.getDbUrl() != null || bean.isNull("dbUrl")) {
			if (valueSet)
				buf.append(", ");
			buf.append("DB_URL=? ");
			uqi.setValues.add(bean.getDbUrl());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("dbUrl"), uqi);
			valueSet = true;
		}
		if (bean.getDbType() != null || bean.isNull("dbType")) {
			if (valueSet)
				buf.append(", ");
			buf.append("DB_TYPE=? ");
			uqi.setValues.add(bean.getDbType());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("dbType"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModTime() != null || bean.isNull("modTime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MOD_TIME=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModTime().getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("modTime"), uqi);
			valueSet = true;
		}
		if (bean.getModUser() != null || bean.isNull("modUser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MOD_USER=? ");
			uqi.setValues.add(bean.getModUser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("modUser"), uqi);
			valueSet = true;
		}
		if (bean.getForceSchemaOwnerCheck() != null
				|| bean.isNull("forceSchemaOwnerCheck")) {
			if (valueSet)
				buf.append(", ");
			buf.append("FORCE_SCHEMA_OWNER_CHECK=? ");
			uqi.setValues.add(boolean2Number((Boolean) bean
					.getForceSchemaOwnerCheck()));
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("forceSchemaOwnerCheck"), uqi);
			valueSet = true;
		}
		if (bean.getSiteUniqueId() != null || bean.isNull("siteUniqueId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("SITE_UNIQUE_ID=? ");
			uqi.setValues.add(bean.getSiteUniqueId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("siteUniqueId"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	protected Boolean convert2Boolean(Object columnValue) {
		if (columnValue == null)
			return null;
		return ((java.math.BigDecimal) columnValue).intValue() > 0 ? new Boolean(
				true) : new Boolean(false);
	}

	protected BigDecimal boolean2Number(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? new java.math.BigDecimal("1")
				: new java.math.BigDecimal("0");
	}

	protected String boolean2YN(Boolean value) {
		if (value == null)
			return null;
		return ((Boolean) value).booleanValue() ? "Y" : "N";
	}

	public ConfDatabase createObject(ResultSet rs) throws SQLException {
		ConfDatabase obj = new ConfDatabase();
		obj.setUniqueId((java.math.BigDecimal) rs.getObject(1));
		obj.setDbId((String) rs.getObject(2));
		obj.setIsDefault(convert2Boolean(rs.getObject(3)));
		obj.setDbUrl((String) rs.getObject(4));
		obj.setDbType((String) rs.getObject(5));
		obj.setOwner((java.math.BigDecimal) rs.getObject(6));
		if (rs.getTimestamp(7) != null) {
			obj.setModTime(new java.util.Date(rs.getTimestamp(7).getTime()));
		}
		obj.setModUser((java.math.BigDecimal) rs.getObject(8));
		obj.setForceSchemaOwnerCheck(convert2Boolean(rs.getObject(9)));
		obj.setSiteUniqueId((java.math.BigDecimal) rs.getObject(10));
		return obj;
	}

	public List<ConfDatabase> find(Connection con, ConfDatabase criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<ConfDatabase> results = new LinkedList<ConfDatabase>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_CONF_DATABASE ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				ConfDatabase item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, ConfDatabase bean, ConfDatabase criteria)
			throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, ConfDatabase criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_CONF_DATABASE ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
