package clinical.server.dao.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Tuplesubclass;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class TuplesubclassDAO implements clinical.server.dao.TuplesubclassDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public TuplesubclassDAO() {}

	public void insert(Connection con, Tuplesubclass bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_TUPLESUBCLASS ");
			buf
					.append(" (TUPLESUBCLASS,TUPLECLASS,UNIQUEID,TABLEID,OWNER,MODTIME,MODUSER) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 7; ++i) {
				buf.append('?');
				if (i < 6)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, (String) bean.getTuplesubclass(), Types.VARCHAR);
			ps.setObject(2, (String) bean.getTupleclass(), Types.VARCHAR);
			ps.setObject(3, (java.math.BigDecimal) bean.getUniqueid(),
					Types.NUMERIC);
			ps.setObject(4, (java.math.BigDecimal) bean.getTableid(),
					Types.NUMERIC);
			ps.setObject(5, (java.math.BigDecimal) bean.getOwner(), Types.NUMERIC);
			ps.setTimestamp(6, bean.getModtime() == null ? null
					: new java.sql.Timestamp(bean.getModtime().getTime()));
			ps.setObject(7, (java.math.BigDecimal) bean.getModuser(),
					Types.NUMERIC);
			ps.executeUpdate();

		} finally {
			if (ps != null)
				try {
					ps.close();
				} catch (Exception x) { /* ignore */
				}
		}
	}

	protected String prepareColList(Tuplesubclass bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("TUPLESUBCLASS");
		buf.append(',');
		buf.append("TUPLECLASS");
		buf.append(',');
		buf.append("UNIQUEID");
		buf.append(',');
		buf.append("TABLEID");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MODTIME");
		buf.append(',');
		buf.append("MODUSER");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Tuplesubclass bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");

		if (bean.getTuplesubclass() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TUPLESUBCLASS=?");
			qi.values.add(bean.getTuplesubclass());
			valueSet = true;
		}
		if (bean.getTupleclass() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TUPLECLASS=?");
			qi.values.add(bean.getTupleclass());
			valueSet = true;
		}
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UNIQUEID=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TABLEID=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODTIME=?");
			qi.values.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODUSER=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Tuplesubclass bean,
			Tuplesubclass criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_TUPLESUBCLASS SET ");

		if (bean.getTuplesubclass() != null || bean.isNull("tuplesubclass")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TUPLESUBCLASS=? ");
			uqi.setValues.add(bean.getTuplesubclass());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("tuplesubclass"), uqi);
			valueSet = true;
		}
		if (bean.getTupleclass() != null || bean.isNull("tupleclass")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TUPLECLASS=? ");
			uqi.setValues.add(bean.getTupleclass());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("tupleclass"), uqi);
			valueSet = true;
		}
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("UNIQUEID=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("TABLEID=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODTIME=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime().getTime()));
			uqi.sqlTypes.add(new Integer(Types.DATE));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODUSER=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public Tuplesubclass createObject(ResultSet rs) throws SQLException {
		Tuplesubclass obj = new Tuplesubclass();
		obj.setTuplesubclass((String) rs.getObject(1));
		obj.setTupleclass((String) rs.getObject(2));
		obj.setUniqueid((java.math.BigDecimal) rs.getObject(3));
		obj.setTableid((java.math.BigDecimal) rs.getObject(4));
		obj.setOwner((java.math.BigDecimal) rs.getObject(5));
		if (rs.getTimestamp(6) != null) {
			obj.setModtime(new java.util.Date(rs.getTimestamp(6).getTime()));
		}
		obj.setModuser((java.math.BigDecimal) rs.getObject(7));
		return obj;
	}

	public List<Tuplesubclass> find(Connection con, Tuplesubclass criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Tuplesubclass> results = new LinkedList<Tuplesubclass>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_TUPLESUBCLASS ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Tuplesubclass item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Tuplesubclass bean, Tuplesubclass criteria)
			throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Tuplesubclass criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_TUPLESUBCLASS ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
