














package clinical.server.dao.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.BugReport;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class BugReportDAO implements clinical.server.dao.BugReportDAO {
/*+++    */
  // Enter your declarations here
/*+++    */

public BugReportDAO () {}

	public void insert(Connection con, BugReport bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_bug_report VALUES ");
			buf.append('(');
			for (int i = 0; i < 7; ++i) {
				buf.append('?');
				if (i < 6)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(2, bean.getSubjectid(), Types.VARCHAR);

			ps.setObject(3, bean.getExpId(), Types.NUMERIC);

			ps.setObject(4, bean.getComponentId(), Types.NUMERIC);

			ps.setObject(5, bean.getWebuser(), Types.VARCHAR);

			ps.setObject(6,
					bean.getModtime() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getModtime()
									.getTime()));

			ps.setObject(7, bean.getComments(), Types.VARCHAR);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}


protected String prepareColList(BugReport bean) {
  StringBuffer buf = new StringBuffer(200);
    buf.append("uniqueid" );
   buf.append(',');     buf.append("subjectid" );
   buf.append(',');     buf.append("exp_id" );
   buf.append(',');     buf.append("component_id" );
   buf.append(',');     buf.append("webuser" );
   buf.append(',');     buf.append("modtime" );
   buf.append(',');     buf.append("comments" );
      buf.append(' ');
  return buf.toString();
}

protected QueryInfo prepareWhereClause(BugReport bean) {
  StringBuffer buf = new StringBuffer(200);
    QueryInfo qi = new QueryInfo();
  boolean valueSet = false;
  buf.append("WHERE ");
    if (bean.getUniqueid() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("uniqueid=?");
                   qi.values.add(bean.getUniqueid());
                 valueSet = true;
  }
    if (bean.getSubjectid() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("subjectid=?");
                   qi.values.add(bean.getSubjectid());
                 valueSet = true;
  }
    if (bean.getExpId() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("exp_id=?");
                   qi.values.add(bean.getExpId());
                 valueSet = true;
  }
    if (bean.getComponentId() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("component_id=?");
                   qi.values.add(bean.getComponentId());
                 valueSet = true;
  }
    if (bean.getWebuser() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("webuser=?");
                   qi.values.add(bean.getWebuser());
                 valueSet = true;
  }
    if (bean.getModtime() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("modtime=?");
                   qi.values.add( new java.sql.Date( bean.getModtime().getTime() ));
                 valueSet = true;
  }
    if (bean.getComments() != null) {
     if (valueSet)
       buf.append(" AND ");
     buf.append("comments=?");
                   qi.values.add(bean.getComments());
                 valueSet = true;
  }
    qi.whereClause = (!valueSet) ? "" : buf.toString();
  return qi;
}

protected UpdateQueryInfo prepareUpdateQuery(BugReport bean,BugReport criteria ) throws ValidationException
{
  StringBuffer buf = new StringBuffer(200);
    UpdateQueryInfo uqi = new UpdateQueryInfo();
  boolean valueSet = false;
  buf.append("UPDATE nc_bug_report SET ");
    if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
    if (valueSet)  buf.append(", ");
    buf.append("uniqueid=? ");
                    uqi.setValues.add(bean.getUniqueid()); 
                  uqi.sqlTypes.add(new Integer( Types.NUMERIC ) );
     prepareNullSetListValue( bean.isNull("uniqueid"), uqi);
     valueSet = true;
  }
    if (bean.getSubjectid() != null || bean.isNull("subjectid")) {
    if (valueSet)  buf.append(", ");
    buf.append("subjectid=? ");
                    uqi.setValues.add(bean.getSubjectid()); 
                  uqi.sqlTypes.add(new Integer( Types.VARCHAR ) );
     prepareNullSetListValue( bean.isNull("subjectid"), uqi);
     valueSet = true;
  }
    if (bean.getExpId() != null || bean.isNull("expId")) {
    if (valueSet)  buf.append(", ");
    buf.append("exp_id=? ");
                    uqi.setValues.add(bean.getExpId()); 
                  uqi.sqlTypes.add(new Integer( Types.NUMERIC ) );
     prepareNullSetListValue( bean.isNull("expId"), uqi);
     valueSet = true;
  }
    if (bean.getComponentId() != null || bean.isNull("componentId")) {
    if (valueSet)  buf.append(", ");
    buf.append("component_id=? ");
                    uqi.setValues.add(bean.getComponentId()); 
                  uqi.sqlTypes.add(new Integer( Types.NUMERIC ) );
     prepareNullSetListValue( bean.isNull("componentId"), uqi);
     valueSet = true;
  }
    if (bean.getWebuser() != null || bean.isNull("webuser")) {
    if (valueSet)  buf.append(", ");
    buf.append("webuser=? ");
                    uqi.setValues.add(bean.getWebuser()); 
                  uqi.sqlTypes.add(new Integer( Types.VARCHAR ) );
     prepareNullSetListValue( bean.isNull("webuser"), uqi);
     valueSet = true;
  }
    if (bean.getModtime() != null || bean.isNull("modtime")) {
    if (valueSet)  buf.append(", ");
    buf.append("modtime=? ");
                  uqi.setValues.add( new java.sql.Timestamp( bean.getModtime().getTime() ) );
                 uqi.sqlTypes.add(new Integer( Types.TIMESTAMP ) );
     prepareNullSetListValue( bean.isNull("modtime"), uqi);
     valueSet = true;
  }
    if (bean.getComments() != null || bean.isNull("comments")) {
    if (valueSet)  buf.append(", ");
    buf.append("comments=? ");
                    uqi.setValues.add(bean.getComments()); 
                  uqi.sqlTypes.add(new Integer( Types.VARCHAR ) );
     prepareNullSetListValue( bean.isNull("comments"), uqi);
     valueSet = true;
  }
    if (!valueSet)
    throw new ValidationException("At least one field needs to be set for update!");

  uqi.query = buf.toString();
  QueryInfo qi = prepareWhereClause(criteria);
  uqi.query += qi.whereClause;
  uqi.whereValues = qi.values;
  return uqi;
}

protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
     if ( wasNull ) {
       uqi.nullSetList.add( new Boolean(true) );
     } else {
       uqi.nullSetList.add( new Boolean(false) );
     }
}


public BugReport createObject(ResultSet rs) throws SQLException {
   BugReport obj = new BugReport();
                  obj.setUniqueid( ( rs.getObject(1) != null) ?
              new java.math.BigDecimal( rs.getObject(1).toString() ) : null );
                            obj.setSubjectid( (String ) rs.getObject(2) );
                               obj.setExpId( ( rs.getObject(3) != null) ?
              new java.math.BigDecimal( rs.getObject(3).toString() ) : null );
                        obj.setComponentId( ( rs.getObject(4) != null) ?
              new java.math.BigDecimal( rs.getObject(4).toString() ) : null );
                            obj.setWebuser( (String ) rs.getObject(5) );
                                                   obj.setModtime( ( rs.getObject(6) != null) ?
              new java.util.Date( ((java.sql.Timestamp) rs.getObject(6)).getTime() ) : null );
                                                obj.setComments( (String ) rs.getObject(7) );
                   return obj;
}

public List<BugReport> find(Connection con, BugReport criteria) throws Exception
{

   PreparedStatement ps = null;
   ResultSet rs = null;
   List<BugReport> results = new LinkedList<BugReport>();
   StringBuffer buf = new StringBuffer(200);

   if ( criteria  == null)
       return null;
   buf.append("SELECT ");
   buf.append( prepareColList( criteria) );
   buf.append(" FROM nc_bug_report ");
   QueryInfo qi = prepareWhereClause(criteria);
   buf.append( qi.whereClause );
   try {
      ps = con.prepareStatement( buf.toString() );
      ps.clearParameters();
      int i = 0;
      for(Iterator<?> it = qi.values.iterator(); it.hasNext(); ) {
         ps.setObject(++i, it.next() );
      }
      rs = ps.executeQuery();
      while(rs.next() ) {
          BugReport item = createObject(rs);
          results.add(item);
      }
   } finally {
      DBUtils.close(ps, rs);	
   }
   return results;
}

public void update(Connection con, BugReport bean, BugReport criteria) throws Exception
{
   PreparedStatement ps = null;

   if ( bean  == null)
       return;

   UpdateQueryInfo uqi =  prepareUpdateQuery(bean, criteria);
   try {
       ps = con.prepareStatement( uqi.query );
       ps.clearParameters();
       int i = 0;
       Iterator<Integer> it2 = uqi.sqlTypes.iterator();
       Iterator<Boolean> it3 = uqi.nullSetList.iterator();
       for(Iterator<?> it = uqi.setValues.iterator(); it.hasNext(); ) {
          Object value = it.next();
          Integer sqlType = (Integer) it2.next();
          boolean nullSet = ((Boolean) it3.next()).booleanValue();
          if ( nullSet) {
            ps.setNull(++i, sqlType.intValue() );
          } else {
             ps.setObject(++i, value);
          }
       }
       // for where part
       for(Iterator<?> it = uqi.whereValues.iterator(); it.hasNext(); ) {
          ps.setObject(++i, it.next() );
       }
       ps.executeUpdate();
   } finally {
      DBUtils.close(ps);	      
   }
}

public void delete(Connection con, BugReport criteria) throws Exception
{
    PreparedStatement ps = null;
    StringBuffer buf = new StringBuffer(200);
    buf.append("DELETE FROM nc_bug_report ");

    QueryInfo qi = prepareWhereClause(criteria);
    buf.append( qi.whereClause );
    try {
       ps = con.prepareStatement( buf.toString() );
       ps.clearParameters();
       int i = 0;
       for(Iterator<?> it = qi.values.iterator(); it.hasNext(); ) {
          ps.setObject(++i, it.next() );
       }
       ps.executeUpdate();

    } finally {
      DBUtils.close(ps);	
    }
}

  public static class QueryInfo {
    String whereClause;
    List<? super Object> values = new LinkedList<Object>();
    public QueryInfo() {}
    public QueryInfo(String whereClause) {
       this.whereClause = whereClause;
    }
  }

  public static class UpdateQueryInfo {
     String query;
     List<? super Object> setValues = new LinkedList<Object>();
	 List<Integer> sqlTypes = new LinkedList<Integer>();
	 List<Boolean> nullSetList = new LinkedList<Boolean>();
	 List<? super Object> whereValues = new LinkedList<Object>();
	 
     public UpdateQueryInfo() {}
  }

/*+++    */
  // Enter your code here
/*+++    */
}//;
