package clinical.server.dao.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.ExpcomponentView;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class ExpcomponentViewDAO implements
		clinical.server.dao.ExpcomponentViewDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public ExpcomponentViewDAO() {
	}

	public void insert(Connection con, ExpcomponentView bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO NC_EXPCOMPONENT_VIEW ");
			buf
					.append(" (COMPONENTID,NC_EXPERIMENT_UNIQUEID,SUBJECTID,UNIQUEID,TABLEID,OWNER,MODUSER,VISITTYPE) ");
			buf.append("VALUES ");

			buf.append('(');
			for (int i = 0; i < 8; ++i) {
				buf.append('?');
				if (i < 7)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getComponentid(), Types.NUMERIC);
			ps.setObject(2, bean.getNcExperimentUniqueid(), Types.NUMERIC);
			ps.setObject(3, bean.getSubjectid(), Types.VARCHAR);
			ps.setObject(4, bean.getUniqueid(), Types.NUMERIC);
			ps.setObject(5, bean.getTableid(), Types.NUMERIC);
			ps.setObject(6, bean.getOwner(), Types.NUMERIC);
			ps.setObject(7, bean.getModuser(), Types.NUMERIC);
			ps.setObject(8, bean.getVisittype(), Types.VARCHAR);
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(ExpcomponentView bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("COMPONENTID");
		buf.append(',');
		buf.append("NC_EXPERIMENT_UNIQUEID");
		buf.append(',');
		buf.append("SUBJECTID");
		buf.append(',');
		buf.append("UNIQUEID");
		buf.append(',');
		buf.append("TABLEID");
		buf.append(',');
		buf.append("OWNER");
		buf.append(',');
		buf.append("MODUSER");
		buf.append(',');
		buf.append("VISITTYPE");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(ExpcomponentView bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getComponentid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("COMPONENTID=?");
			qi.values.add(bean.getComponentid());
			valueSet = true;
		}
		if (bean.getNcExperimentUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("NC_EXPERIMENT_UNIQUEID=?");
			qi.values.add(bean.getNcExperimentUniqueid());
			valueSet = true;
		}
		if (bean.getSubjectid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("SUBJECTID=?");
			qi.values.add(bean.getSubjectid());
			valueSet = true;
		}
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("UNIQUEID=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("TABLEID=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("OWNER=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("MODUSER=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getVisittype() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("VISITTYPE=?");
			qi.values.add(bean.getVisittype());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(ExpcomponentView bean,
			ExpcomponentView criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE NC_EXPCOMPONENT_VIEW SET ");
		if (bean.getComponentid() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("COMPONENTID=? ");
			uqi.setValues.add(bean.getComponentid());
			valueSet = true;
		}
		if (bean.getNcExperimentUniqueid() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("NC_EXPERIMENT_UNIQUEID=? ");
			uqi.setValues.add(bean.getNcExperimentUniqueid());
			valueSet = true;
		}
		if (bean.getSubjectid() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("SUBJECTID=? ");
			uqi.setValues.add(bean.getSubjectid());
			valueSet = true;
		}
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("UNIQUEID=? ");
			uqi.setValues.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("TABLEID=? ");
			uqi.setValues.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("OWNER=? ");
			uqi.setValues.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("MODUSER=? ");
			uqi.setValues.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getVisittype() != null) {
			if (valueSet)
				buf.append(", ");
			buf.append("VISITTYPE=? ");
			uqi.setValues.add(bean.getVisittype());
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	public ExpcomponentView createObject(ResultSet rs) throws SQLException {
		ExpcomponentView obj = new ExpcomponentView();
		obj.setComponentid((java.math.BigDecimal) rs.getObject(1));
		obj.setNcExperimentUniqueid((java.math.BigDecimal) rs.getObject(2));
		obj.setSubjectid((String) rs.getObject(3));
		obj.setUniqueid((java.math.BigDecimal) rs.getObject(4));
		obj.setTableid((java.math.BigDecimal) rs.getObject(5));
		obj.setOwner((java.math.BigDecimal) rs.getObject(6));
		obj.setModuser((java.math.BigDecimal) rs.getObject(7));
		obj.setVisittype((String) rs.getObject(8));
		return obj;
	}

	public List<ExpcomponentView> find(Connection con, ExpcomponentView criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<ExpcomponentView> results = new LinkedList<ExpcomponentView>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM NC_EXPCOMPONENT_VIEW ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				ExpcomponentView item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, ExpcomponentView bean,
			ExpcomponentView criteria) throws Exception {

		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, ExpcomponentView criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM NC_EXPCOMPONENT_VIEW ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
