package clinical.server.dao.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.JobResult;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class JobResultDAO implements clinical.server.dao.JobResultDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public JobResultDAO() {
	}

	public void insert(Connection con, JobResult bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_job_result VALUES ");
			buf.append('(');
			for (int i = 0; i < 6; ++i) {
				buf.append('?');
				if (i < 5)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(2, bean.getName(), Types.VARCHAR);

			ps.setObject(3, bean.getValue(), Types.VARCHAR);

			ps.setObject(4, bean.getNumericValue(), Types.DOUBLE);

			ps.setObject(5, bean.getResultTypeId(), Types.NUMERIC);

			ps.setObject(6, bean.getStoredJobResultGroupId(), Types.NUMERIC);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(JobResult bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("uniqueid");
		buf.append(',');
		buf.append("name");
		buf.append(',');
		buf.append("value");
		buf.append(',');
		buf.append("numeric_value");
		buf.append(',');
		buf.append("result_type_id");
		buf.append(',');
		buf.append("stored_job_result_group_id");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(JobResult bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("uniqueid=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getName() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("name=?");
			qi.values.add(bean.getName());
			valueSet = true;
		}
		if (bean.getValue() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("value=?");
			qi.values.add(bean.getValue());
			valueSet = true;
		}
		if (bean.getNumericValue() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("numeric_value=?");
			qi.values.add(bean.getNumericValue());
			valueSet = true;
		}
		if (bean.getResultTypeId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("result_type_id=?");
			qi.values.add(bean.getResultTypeId());
			valueSet = true;
		}
		if (bean.getStoredJobResultGroupId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("stored_job_result_group_id=?");
			qi.values.add(bean.getStoredJobResultGroupId());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(JobResult bean,
			JobResult criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_job_result SET ");
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("uniqueid=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getName() != null || bean.isNull("name")) {
			if (valueSet)
				buf.append(", ");
			buf.append("name=? ");
			uqi.setValues.add(bean.getName());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("name"), uqi);
			valueSet = true;
		}
		if (bean.getValue() != null || bean.isNull("value")) {
			if (valueSet)
				buf.append(", ");
			buf.append("value=? ");
			uqi.setValues.add(bean.getValue());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("value"), uqi);
			valueSet = true;
		}
		if (bean.getNumericValue() != null || bean.isNull("numericValue")) {
			if (valueSet)
				buf.append(", ");
			buf.append("numeric_value=? ");
			uqi.setValues.add(bean.getNumericValue());
			uqi.sqlTypes.add(new Integer(Types.DOUBLE));
			prepareNullSetListValue(bean.isNull("numericValue"), uqi);
			valueSet = true;
		}
		if (bean.getResultTypeId() != null || bean.isNull("resultTypeId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("result_type_id=? ");
			uqi.setValues.add(bean.getResultTypeId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("resultTypeId"), uqi);
			valueSet = true;
		}
		if (bean.getStoredJobResultGroupId() != null
				|| bean.isNull("storedJobResultGroupId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("stored_job_result_group_id=? ");
			uqi.setValues.add(bean.getStoredJobResultGroupId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("storedJobResultGroupId"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public JobResult createObject(ResultSet rs) throws SQLException {
		JobResult obj = new JobResult();
		obj.setUniqueid((rs.getObject(1) != null) ? new java.math.BigDecimal(rs
				.getObject(1).toString()) : null);
		obj.setName((String) rs.getObject(2));
		obj.setValue((String) rs.getObject(3));
		obj.setNumericValue((Double) rs.getObject(4));
		obj
				.setResultTypeId((rs.getObject(5) != null) ? new java.math.BigDecimal(
						rs.getObject(5).toString())
						: null);
		obj
				.setStoredJobResultGroupId((rs.getObject(6) != null) ? new java.math.BigDecimal(
						rs.getObject(6).toString())
						: null);
		return obj;
	}

	public List<JobResult> find(Connection con, JobResult criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<JobResult> results = new LinkedList<JobResult>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_job_result ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				JobResult item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, JobResult bean, JobResult criteria)
			throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, JobResult criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_job_result ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
