package clinical.server.dao.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.JobResultGroupTypes;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class JobResultGroupTypesDAO implements
		clinical.server.dao.JobResultGroupTypesDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public JobResultGroupTypesDAO() {
	}

	public void insert(Connection con, JobResultGroupTypes bean)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_job_result_group_types VALUES ");
			buf.append('(');
			for (int i = 0; i < 2; ++i) {
				buf.append('?');
				if (i < 1)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getJobResultGroupId(), Types.NUMERIC);

			ps.setObject(2, bean.getJobResultTypeId(), Types.NUMERIC);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(JobResultGroupTypes bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("job_result_group_id");
		buf.append(',');
		buf.append("job_result_type_id");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(JobResultGroupTypes bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getJobResultGroupId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("job_result_group_id=?");
			qi.values.add(bean.getJobResultGroupId());
			valueSet = true;
		}
		if (bean.getJobResultTypeId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("job_result_type_id=?");
			qi.values.add(bean.getJobResultTypeId());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(JobResultGroupTypes bean,
			JobResultGroupTypes criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_job_result_group_types SET ");
		if (bean.getJobResultGroupId() != null
				|| bean.isNull("jobResultGroupId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("job_result_group_id=? ");
			uqi.setValues.add(bean.getJobResultGroupId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("jobResultGroupId"), uqi);
			valueSet = true;
		}
		if (bean.getJobResultTypeId() != null || bean.isNull("jobResultTypeId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("job_result_type_id=? ");
			uqi.setValues.add(bean.getJobResultTypeId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("jobResultTypeId"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public JobResultGroupTypes createObject(ResultSet rs) throws SQLException {
		JobResultGroupTypes obj = new JobResultGroupTypes();
		obj.setJobResultGroupId((rs.getObject(1) != null) ? new java.math.BigDecimal(
				rs.getObject(1).toString()) : null);
		obj.setJobResultTypeId((rs.getObject(2) != null) ? new java.math.BigDecimal(
				rs.getObject(2).toString()) : null);
		return obj;
	}

	public List<JobResultGroupTypes> find(Connection con,
			JobResultGroupTypes criteria) throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<JobResultGroupTypes> results = new LinkedList<JobResultGroupTypes>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_job_result_group_types ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				JobResultGroupTypes item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, JobResultGroupTypes bean,
			JobResultGroupTypes criteria) throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, JobResultGroupTypes criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_job_result_group_types ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
