package clinical.server.dao.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.Machine;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class MachineDAO implements clinical.server.dao.MachineDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public MachineDAO() {
	}

	public void insert(Connection con, Machine bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_machine VALUES ");
			buf.append('(');
			for (int i = 0; i < 10; ++i) {
				buf.append('?');
				if (i < 9)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(2, bean.getTableid(), Types.NUMERIC);

			ps.setObject(3, bean.getOwner(), Types.NUMERIC);

			ps.setObject(4,
					bean.getModtime() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getModtime()
									.getTime()));

			ps.setObject(5, bean.getModuser(), Types.NUMERIC);

			ps.setObject(6, bean.getArchitecture(), Types.VARCHAR);

			ps.setObject(7, bean.getOs(), Types.VARCHAR);

			ps.setObject(8, bean.getOsversion(), Types.VARCHAR);

			ps.setObject(9, bean.getDescription(), Types.VARCHAR);

			ps.setObject(10, bean.getAddress(), Types.VARCHAR);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(Machine bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("uniqueid");
		buf.append(',');
		buf.append("tableid");
		buf.append(',');
		buf.append("owner");
		buf.append(',');
		buf.append("modtime");
		buf.append(',');
		buf.append("moduser");
		buf.append(',');
		buf.append("architecture");
		buf.append(',');
		buf.append("os");
		buf.append(',');
		buf.append("osversion");
		buf.append(',');
		buf.append("description");
		buf.append(',');
		buf.append("address");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Machine bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("uniqueid=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("tableid=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("owner=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("modtime=?");
			qi.values.add(new java.sql.Date(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("moduser=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getArchitecture() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("architecture=?");
			qi.values.add(bean.getArchitecture());
			valueSet = true;
		}
		if (bean.getOs() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("os=?");
			qi.values.add(bean.getOs());
			valueSet = true;
		}
		if (bean.getOsversion() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("osversion=?");
			qi.values.add(bean.getOsversion());
			valueSet = true;
		}
		if (bean.getDescription() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("description=?");
			qi.values.add(bean.getDescription());
			valueSet = true;
		}
		if (bean.getAddress() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("address=?");
			qi.values.add(bean.getAddress());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Machine bean, Machine criteria)
			throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_machine SET ");
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("uniqueid=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("tableid=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("owner=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("modtime=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("moduser=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getArchitecture() != null || bean.isNull("architecture")) {
			if (valueSet)
				buf.append(", ");
			buf.append("architecture=? ");
			uqi.setValues.add(bean.getArchitecture());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("architecture"), uqi);
			valueSet = true;
		}
		if (bean.getOs() != null || bean.isNull("os")) {
			if (valueSet)
				buf.append(", ");
			buf.append("os=? ");
			uqi.setValues.add(bean.getOs());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("os"), uqi);
			valueSet = true;
		}
		if (bean.getOsversion() != null || bean.isNull("osversion")) {
			if (valueSet)
				buf.append(", ");
			buf.append("osversion=? ");
			uqi.setValues.add(bean.getOsversion());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("osversion"), uqi);
			valueSet = true;
		}
		if (bean.getDescription() != null || bean.isNull("description")) {
			if (valueSet)
				buf.append(", ");
			buf.append("description=? ");
			uqi.setValues.add(bean.getDescription());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("description"), uqi);
			valueSet = true;
		}
		if (bean.getAddress() != null || bean.isNull("address")) {
			if (valueSet)
				buf.append(", ");
			buf.append("address=? ");
			uqi.setValues.add(bean.getAddress());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("address"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public Machine createObject(ResultSet rs) throws SQLException {
		Machine obj = new Machine();
		obj.setUniqueid((rs.getObject(1) != null) ? new java.math.BigDecimal(rs
				.getObject(1).toString()) : null);
		obj.setTableid((rs.getObject(2) != null) ? new java.math.BigDecimal(rs
				.getObject(2).toString()) : null);
		obj.setOwner((rs.getObject(3) != null) ? new java.math.BigDecimal(rs
				.getObject(3).toString()) : null);
		obj.setModtime((rs.getObject(4) != null) ? new java.util.Date(
				((java.sql.Timestamp) rs.getObject(4)).getTime()) : null);
		obj.setModuser((rs.getObject(5) != null) ? new java.math.BigDecimal(rs
				.getObject(5).toString()) : null);
		obj.setArchitecture((String) rs.getObject(6));
		obj.setOs((String) rs.getObject(7));
		obj.setOsversion((String) rs.getObject(8));
		obj.setDescription((String) rs.getObject(9));
		obj.setAddress((String) rs.getObject(10));
		return obj;
	}

	public List<Machine> find(Connection con, Machine criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Machine> results = new LinkedList<Machine>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_machine ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Machine item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Machine bean, Machine criteria)
			throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Machine criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_machine ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
