package clinical.server.dao.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.utils.PostgresUtils;
import clinical.server.vo.Tupletimestamp;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class TupletimestampDAO implements clinical.server.dao.TupletimestampDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public TupletimestampDAO() {
	}

	public void insert(Connection con, Tupletimestamp bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_tupletimestamp VALUES ");
			buf.append('(');
			for (int i = 0; i < 12; ++i) {
				buf.append('?');
				if (i < 11)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getTableid(), Types.NUMERIC);

			ps.setObject(2, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(3, bean.getOwner(), Types.NUMERIC);

			ps.setObject(4,
					bean.getModtime() == null ? (java.sql.Timestamp) null
							: new java.sql.Timestamp(bean.getModtime()
									.getTime()));

			ps.setObject(5, bean.getModuser(), Types.NUMERIC);

			ps.setObject(6, bean.getExtendedtupleid(), Types.NUMERIC);

			ps.setObject(7, bean.getColumnname(), Types.VARCHAR);

			ps.setObject(8, bean.getColumntype(), Types.VARCHAR);

			ps.setObject(9, bean.getStoredtupleid(), Types.NUMERIC);

			ps.setObject(10, bean.getTextvalue(), Types.VARCHAR);

			ps.setObject(11, bean.getComments(), Types.VARCHAR);

			ps.setObject(12, bean.getDatavalue());

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(Tupletimestamp bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("tableid");
		buf.append(',');
		buf.append("uniqueid");
		buf.append(',');
		buf.append("owner");
		buf.append(',');
		buf.append("modtime");
		buf.append(',');
		buf.append("moduser");
		buf.append(',');
		buf.append("extendedtupleid");
		buf.append(',');
		buf.append("columnname");
		buf.append(',');
		buf.append("columntype");
		buf.append(',');
		buf.append("storedtupleid");
		buf.append(',');
		buf.append("textvalue");
		buf.append(',');
		buf.append("comments");
		buf.append(',');
		buf.append("datavalue");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(Tupletimestamp bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getTableid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("tableid=?");
			qi.values.add(bean.getTableid());
			valueSet = true;
		}
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("uniqueid=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getOwner() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("owner=?");
			qi.values.add(bean.getOwner());
			valueSet = true;
		}
		if (bean.getModtime() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("modtime=?");
			qi.values.add(new java.sql.Date(bean.getModtime().getTime()));
			valueSet = true;
		}
		if (bean.getModuser() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("moduser=?");
			qi.values.add(bean.getModuser());
			valueSet = true;
		}
		if (bean.getExtendedtupleid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("extendedtupleid=?");
			qi.values.add(bean.getExtendedtupleid());
			valueSet = true;
		}
		if (bean.getColumnname() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("columnname=?");
			qi.values.add(bean.getColumnname());
			valueSet = true;
		}
		if (bean.getColumntype() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("columntype=?");
			qi.values.add(bean.getColumntype());
			valueSet = true;
		}
		if (bean.getStoredtupleid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("storedtupleid=?");
			qi.values.add(bean.getStoredtupleid());
			valueSet = true;
		}
		if (bean.getTextvalue() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("textvalue=?");
			qi.values.add(bean.getTextvalue());
			valueSet = true;
		}
		if (bean.getComments() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("comments=?");
			qi.values.add(bean.getComments());
			valueSet = true;
		}
		if (bean.getDatavalue() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("datavalue=?");
			qi.values.add(bean.getDatavalue());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(Tupletimestamp bean,
			Tupletimestamp criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_tupletimestamp SET ");
		if (bean.getTableid() != null || bean.isNull("tableid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("tableid=? ");
			uqi.setValues.add(bean.getTableid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("tableid"), uqi);
			valueSet = true;
		}
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("uniqueid=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getOwner() != null || bean.isNull("owner")) {
			if (valueSet)
				buf.append(", ");
			buf.append("owner=? ");
			uqi.setValues.add(bean.getOwner());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("owner"), uqi);
			valueSet = true;
		}
		if (bean.getModtime() != null || bean.isNull("modtime")) {
			if (valueSet)
				buf.append(", ");
			buf.append("modtime=? ");
			uqi.setValues.add(new java.sql.Timestamp(bean.getModtime()
					.getTime()));
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("modtime"), uqi);
			valueSet = true;
		}
		if (bean.getModuser() != null || bean.isNull("moduser")) {
			if (valueSet)
				buf.append(", ");
			buf.append("moduser=? ");
			uqi.setValues.add(bean.getModuser());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("moduser"), uqi);
			valueSet = true;
		}
		if (bean.getExtendedtupleid() != null || bean.isNull("extendedtupleid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("extendedtupleid=? ");
			uqi.setValues.add(bean.getExtendedtupleid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("extendedtupleid"), uqi);
			valueSet = true;
		}
		if (bean.getColumnname() != null || bean.isNull("columnname")) {
			if (valueSet)
				buf.append(", ");
			buf.append("columnname=? ");
			uqi.setValues.add(bean.getColumnname());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("columnname"), uqi);
			valueSet = true;
		}
		if (bean.getColumntype() != null || bean.isNull("columntype")) {
			if (valueSet)
				buf.append(", ");
			buf.append("columntype=? ");
			uqi.setValues.add(bean.getColumntype());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("columntype"), uqi);
			valueSet = true;
		}
		if (bean.getStoredtupleid() != null || bean.isNull("storedtupleid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("storedtupleid=? ");
			uqi.setValues.add(bean.getStoredtupleid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("storedtupleid"), uqi);
			valueSet = true;
		}
		if (bean.getTextvalue() != null || bean.isNull("textvalue")) {
			if (valueSet)
				buf.append(", ");
			buf.append("textvalue=? ");
			uqi.setValues.add(bean.getTextvalue());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("textvalue"), uqi);
			valueSet = true;
		}
		if (bean.getComments() != null || bean.isNull("comments")) {
			if (valueSet)
				buf.append(", ");
			buf.append("comments=? ");
			uqi.setValues.add(bean.getComments());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("comments"), uqi);
			valueSet = true;
		}
		if (bean.getDatavalue() != null || bean.isNull("datavalue")) {
			if (valueSet)
				buf.append(", ");
			buf.append("datavalue=? ");
			uqi.setValues.add(bean.getDatavalue());
			uqi.sqlTypes.add(new Integer(Types.TIMESTAMP));
			prepareNullSetListValue(bean.isNull("datavalue"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public Tupletimestamp createObject(ResultSet rs) throws SQLException {
		Tupletimestamp obj = new Tupletimestamp();
		obj.setTableid((rs.getObject(1) != null) ? new java.math.BigDecimal(rs
				.getObject(1).toString()) : null);
		obj.setUniqueid((rs.getObject(2) != null) ? new java.math.BigDecimal(rs
				.getObject(2).toString()) : null);
		obj.setOwner((rs.getObject(3) != null) ? new java.math.BigDecimal(rs
				.getObject(3).toString()) : null);
		obj.setModtime((rs.getObject(4) != null) ? new java.util.Date(
				((java.sql.Timestamp) rs.getObject(4)).getTime()) : null);
		obj.setModuser((rs.getObject(5) != null) ? new java.math.BigDecimal(rs
				.getObject(5).toString()) : null);
		obj
				.setExtendedtupleid((rs.getObject(6) != null) ? new java.math.BigDecimal(
						rs.getObject(6).toString())
						: null);
		obj.setColumnname((String) rs.getObject(7));
		obj.setColumntype((String) rs.getObject(8));
		obj
				.setStoredtupleid((rs.getObject(9) != null) ? new java.math.BigDecimal(
						rs.getObject(9).toString())
						: null);
		obj.setTextvalue((String) rs.getObject(10));
		obj.setComments((String) rs.getObject(11));
		obj.setDatavalue(PostgresUtils.toTimestamp(rs.getObject(12)));
		return obj;
	}

	public List<Tupletimestamp> find(Connection con, Tupletimestamp criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<Tupletimestamp> results = new LinkedList<Tupletimestamp>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_tupletimestamp ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				Tupletimestamp item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, Tupletimestamp bean,
			Tupletimestamp criteria) throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, Tupletimestamp criteria)
			throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_tupletimestamp ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
