package clinical.server.dao.postgres;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import clinical.server.vo.UsageData;
import clinical.web.DBUtils;
import clinical.web.exception.ValidationException;

public class UsageDataDAO implements clinical.server.dao.UsageDataDAO {
	/* +++ */
	// Enter your declarations here
	/* +++ */

	public UsageDataDAO() {
	}

	public void insert(Connection con, UsageData bean) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);

		if (bean == null)
			return;
		try {
			buf.append("INSERT INTO nc_usage_data VALUES ");
			buf.append('(');
			for (int i = 0; i < 5; ++i) {
				buf.append('?');
				if (i < 4)
					buf.append(',');
			}
			buf.append(")");
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			ps.setObject(1, bean.getUniqueid(), Types.NUMERIC);

			ps.setObject(2, bean.getExpId(), Types.NUMERIC);

			ps.setObject(3, bean.getWebuserId(), Types.NUMERIC);

			ps.setObject(4, bean.getGrants(), Types.VARCHAR);

			ps.setObject(5, bean.getPapers(), Types.VARCHAR);

			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	protected String prepareColList(UsageData bean) {
		StringBuffer buf = new StringBuffer(200);
		buf.append("uniqueid");
		buf.append(',');
		buf.append("exp_id");
		buf.append(',');
		buf.append("webuser_id");
		buf.append(',');
		buf.append("grants");
		buf.append(',');
		buf.append("papers");
		buf.append(' ');
		return buf.toString();
	}

	protected QueryInfo prepareWhereClause(UsageData bean) {
		StringBuffer buf = new StringBuffer(200);
		QueryInfo qi = new QueryInfo();
		boolean valueSet = false;
		buf.append("WHERE ");
		if (bean.getUniqueid() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("uniqueid=?");
			qi.values.add(bean.getUniqueid());
			valueSet = true;
		}
		if (bean.getExpId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("exp_id=?");
			qi.values.add(bean.getExpId());
			valueSet = true;
		}
		if (bean.getWebuserId() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("webuser_id=?");
			qi.values.add(bean.getWebuserId());
			valueSet = true;
		}
		if (bean.getGrants() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("grants=?");
			qi.values.add(bean.getGrants());
			valueSet = true;
		}
		if (bean.getPapers() != null) {
			if (valueSet)
				buf.append(" AND ");
			buf.append("papers=?");
			qi.values.add(bean.getPapers());
			valueSet = true;
		}
		qi.whereClause = (!valueSet) ? "" : buf.toString();
		return qi;
	}

	protected UpdateQueryInfo prepareUpdateQuery(UsageData bean,
			UsageData criteria) throws ValidationException {
		StringBuffer buf = new StringBuffer(200);
		UpdateQueryInfo uqi = new UpdateQueryInfo();
		boolean valueSet = false;
		buf.append("UPDATE nc_usage_data SET ");
		if (bean.getUniqueid() != null || bean.isNull("uniqueid")) {
			if (valueSet)
				buf.append(", ");
			buf.append("uniqueid=? ");
			uqi.setValues.add(bean.getUniqueid());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("uniqueid"), uqi);
			valueSet = true;
		}
		if (bean.getExpId() != null || bean.isNull("expId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("exp_id=? ");
			uqi.setValues.add(bean.getExpId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("expId"), uqi);
			valueSet = true;
		}
		if (bean.getWebuserId() != null || bean.isNull("webuserId")) {
			if (valueSet)
				buf.append(", ");
			buf.append("webuser_id=? ");
			uqi.setValues.add(bean.getWebuserId());
			uqi.sqlTypes.add(new Integer(Types.NUMERIC));
			prepareNullSetListValue(bean.isNull("webuserId"), uqi);
			valueSet = true;
		}
		if (bean.getGrants() != null || bean.isNull("grants")) {
			if (valueSet)
				buf.append(", ");
			buf.append("grants=? ");
			uqi.setValues.add(bean.getGrants());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("grants"), uqi);
			valueSet = true;
		}
		if (bean.getPapers() != null || bean.isNull("papers")) {
			if (valueSet)
				buf.append(", ");
			buf.append("papers=? ");
			uqi.setValues.add(bean.getPapers());
			uqi.sqlTypes.add(new Integer(Types.VARCHAR));
			prepareNullSetListValue(bean.isNull("papers"), uqi);
			valueSet = true;
		}
		if (!valueSet)
			throw new ValidationException(
					"At least one field needs to be set for update!");

		uqi.query = buf.toString();
		QueryInfo qi = prepareWhereClause(criteria);
		uqi.query += qi.whereClause;
		uqi.whereValues = qi.values;
		return uqi;
	}

	protected void prepareNullSetListValue(boolean wasNull, UpdateQueryInfo uqi) {
		if (wasNull) {
			uqi.nullSetList.add(new Boolean(true));
		} else {
			uqi.nullSetList.add(new Boolean(false));
		}
	}

	public UsageData createObject(ResultSet rs) throws SQLException {
		UsageData obj = new UsageData();
		obj.setUniqueid((rs.getObject(1) != null) ? new java.math.BigDecimal(rs
				.getObject(1).toString()) : null);
		obj.setExpId((rs.getObject(2) != null) ? new java.math.BigDecimal(rs
				.getObject(2).toString()) : null);
		obj.setWebuserId((rs.getObject(3) != null) ? new java.math.BigDecimal(
				rs.getObject(3).toString()) : null);
		obj.setGrants((String) rs.getObject(4));
		obj.setPapers((String) rs.getObject(5));
		return obj;
	}

	public List<UsageData> find(Connection con, UsageData criteria)
			throws Exception {

		PreparedStatement ps = null;
		ResultSet rs = null;
		List<UsageData> results = new LinkedList<UsageData>();
		StringBuffer buf = new StringBuffer(200);

		if (criteria == null)
			return null;
		buf.append("SELECT ");
		buf.append(prepareColList(criteria));
		buf.append(" FROM nc_usage_data ");
		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			rs = ps.executeQuery();
			while (rs.next()) {
				UsageData item = createObject(rs);
				results.add(item);
			}
		} finally {
			DBUtils.close(ps, rs);
		}
		return results;
	}

	public void update(Connection con, UsageData bean, UsageData criteria)
			throws Exception {
		PreparedStatement ps = null;

		if (bean == null)
			return;

		UpdateQueryInfo uqi = prepareUpdateQuery(bean, criteria);
		try {
			ps = con.prepareStatement(uqi.query);
			ps.clearParameters();
			int i = 0;
			Iterator<Integer> it2 = uqi.sqlTypes.iterator();
			Iterator<Boolean> it3 = uqi.nullSetList.iterator();
			for (Iterator<?> it = uqi.setValues.iterator(); it.hasNext();) {
				Object value = it.next();
				Integer sqlType = (Integer) it2.next();
				boolean nullSet = ((Boolean) it3.next()).booleanValue();
				if (nullSet) {
					ps.setNull(++i, sqlType.intValue());
				} else {
					ps.setObject(++i, value);
				}
			}
			// for where part
			for (Iterator<?> it = uqi.whereValues.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();
		} finally {
			DBUtils.close(ps);
		}
	}

	public void delete(Connection con, UsageData criteria) throws Exception {
		PreparedStatement ps = null;
		StringBuffer buf = new StringBuffer(200);
		buf.append("DELETE FROM nc_usage_data ");

		QueryInfo qi = prepareWhereClause(criteria);
		buf.append(qi.whereClause);
		try {
			ps = con.prepareStatement(buf.toString());
			ps.clearParameters();
			int i = 0;
			for (Iterator<?> it = qi.values.iterator(); it.hasNext();) {
				ps.setObject(++i, it.next());
			}
			ps.executeUpdate();

		} finally {
			DBUtils.close(ps);
		}
	}

	public static class QueryInfo {
		String whereClause;
		List<? super Object> values = new LinkedList<Object>();

		public QueryInfo() {
		}

		public QueryInfo(String whereClause) {
			this.whereClause = whereClause;
		}
	}

	public static class UpdateQueryInfo {
		String query;
		List<? super Object> setValues = new LinkedList<Object>();
		List<Integer> sqlTypes = new LinkedList<Integer>();
		List<Boolean> nullSetList = new LinkedList<Boolean>();
		List<? super Object> whereValues = new LinkedList<Object>();

		public UpdateQueryInfo() {
		}
	}

	/* +++ */
	// Enter your code here
	/* +++ */
}// ;
