package clinical.storage.plugins;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import clinical.storage.IPlugin;
import clinical.utils.FileUtils;
import clinical.web.download.FileInfo;
import clinical.web.download.PathWrapper;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: LocalFSPlugin.java 91 2009-08-17 23:38:26Z bozyurt $
 */
public class LocalFSPlugin implements IPlugin {

	public LocalFSPlugin(Map<String, Object> paramMap) {}

	@Override
	public List<PathWrapper> load(FileInfo fi) throws Exception {
		String rootDir = "";
		List<PathWrapper> files = new ArrayList<PathWrapper>();
		if (fi.isDir()) {
			File dir = FileInfo.getFullPathFile(fi, fi.getSourceRootDir());
			List<File> fileList = FileUtils.getAllFilesUnderDir(dir
					.getAbsolutePath());
			for (File file : fileList) {
				FileInfo nfi = new FileInfo(file.getAbsolutePath(), fi
						.getFileType(), fi.getStorageType(), rootDir, false);

				files.add(new PathWrapper(nfi.getRelativePath(), rootDir));
			}

		} else {
			FileInfo nfi = new FileInfo(fi.getPath(), fi.getFileType(), fi
					.getStorageType(), rootDir, false);
			files.add(new PathWrapper(nfi.getRelativePath(), rootDir));
		}
		return files;
	}

	@Override
	public void shutdown() {
	// no op
	}

	@Override
	public void startup() throws Exception {
	// no op
	}

	public static String getSupportedType() {
		return "local";
	}

	@Override
	public boolean isSupported(String storageType) {
		if (storageType == null)
			return false;
		return storageType.equalsIgnoreCase("local");
	}

	@Override
	public void put(FileInfo localFi, FileInfo remoteFi) throws Exception {
		if (!remoteFi.isDir()) {
			FileUtils.copyFile(localFi.getPath(), remoteFi.getPath());
		} else {
			throw new Exception("target is not a file!:" + remoteFi.getPath());
		}
	}

}
