package clinical.test;

import java.io.IOException;

import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.PostMethod;
import org.json.JSONException;

import clinical.cache.DBChange;
import clinical.cache.TableChange;

/**
 *
 * @author I. Burak Ozyurt
 * @version $Id: CacheEventTests.java 365 2011-05-05 20:04:18Z bozyurt $
 */

public class CacheEventTests extends TestCase {

	public CacheEventTests(String testName) {
		super(testName);
	}

	@Override
	protected void setUp() throws Exception {
		super.setUp();

	}

	public void testRemoteDbChangeEventCall() throws JSONException,
			HttpException, IOException {
		String url = "http://localhost:8080/clinical/cacheevent.do?action=changed";
		PostMethod post = new PostMethod(url);

		String dbChangeJSON = null;
		DBChange dbChange = new DBChange("uci_fbirn");
		dbChange.add(new TableChange("experiment", TableChange.TABLE_CHANGED));
		dbChangeJSON = dbChange.toJSON().toString(2);
		System.out.println(dbChangeJSON);

		post.addParameter("dbChangeJSON", dbChangeJSON);
		HttpClient client = new HttpClient();
		client.getHttpConnectionManager().getParams()
				.setConnectionTimeout(5000);
		int status = client.executeMethod(post);

		assertEquals(HttpStatus.SC_OK, status);
	}

	public static TestSuite suite() throws Exception {
		TestSuite suite = new TestSuite();
		suite.addTest(new CacheEventTests("testRemoteDbChangeEventCall"));
		return suite;
	}

	public static void main(String[] args) throws Exception {
		junit.textui.TestRunner.run(suite());
	}
}
