package clinical.test;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.imageio.ImageIO;

import junit.framework.TestCase;
import junit.framework.TestSuite;

import org.json.JSONObject;

import clinical.utils.Executor;
import clinical.utils.FileUtils;
import clinical.utils.GenUtils;
import clinical.utils.JargonUtils;
import clinical.utils.SRBFileSystemAdapter;
import clinical.web.workflow.cbf.CBFWFContext;
import edu.sdsc.grid.io.GeneralFile;

/**
 * 
 * @author I. Burak Ozyurt
 * @version $Id: MiscTests.java 757 2012-12-12 01:12:45Z bozyurt $
 */

public class MiscTests extends TestCase {
	public MiscTests(String name) {
		super(name);
	}

	public void rangeCalcTest() {
		int curPage = 11;
		int totNumPages = 16;
		int maxNumPages = 5;
		// 0 based
		int curRange = (curPage - 1) / maxNumPages;
		int rangeStart = curRange * maxNumPages + 1;
		int rangeEnd = rangeStart + maxNumPages - 1;
		if (rangeEnd > totNumPages)
			rangeEnd = totNumPages;
		if ((rangeEnd - rangeStart + 1) < maxNumPages
				&& totNumPages > maxNumPages) {
			rangeStart = rangeEnd - maxNumPages + 1;
		}
		// both ends inclusive

		System.out.println("current Page=" + curPage + " rangeStart="
				+ rangeStart + " rangeEnd=" + rangeEnd);
		assertTrue(rangeStart <= curPage && rangeEnd >= rangeEnd);
	}

	public void numberFormatTest() {
		NumberFormat df = DecimalFormat.getInstance();
		df.setMaximumFractionDigits(2);

		String valueStr = "113.52000000000001";
		String value = null;
		if (GenUtils.isDecimalNumber(valueStr)) {
			value = df.format(GenUtils.toNumber(valueStr));
		}
		System.out.println("value=" + value);
	}

	public void testGetAllFilesUnderDir() {
		String rootDir = "/home/bozyurt/dev/java/branch/BIRN/clinical/conf";
		List<File> files = FileUtils.getAllFilesUnderDir(rootDir);

		assertTrue(!files.isEmpty());
		for (Object element : files) {
			File f = (File) element;
			System.out.println(f);
		}
	}

	public void testGetAllFilesUnderCollection() throws Exception {
		String rootCol = "/home/Projects/fBIRNPhaseII__0010/Data/001200635031/scanVisit__0012__0002/MRI__0001/sm2/Native/Original__0001/ANALYZE_7.5";
		SRBFileSystemAdapter sfsAdapter = null;
		try {
			sfsAdapter = new SRBFileSystemAdapter();
			long start = System.currentTimeMillis();
			List<GeneralFile> files = JargonUtils.getAllFilesUnderCollection(
					rootCol, sfsAdapter);
			long end = System.currentTimeMillis() - start;
			System.out.println("Elapsed time (msecs):" + end);
			assertTrue(!files.isEmpty());
			for (GeneralFile f : files) {
				System.out.println(f);
			}
		} finally {
			if (sfsAdapter != null)
				sfsAdapter.shutdown();

		}
	}

	public void testGetAllFilesUnderCollection2() throws Exception {
		String rootCol = "/home/Projects/fBIRNPhaseII__0010/Data/001200635031/scanVisit__0012__0002/MRI__0001/sm2/Native/Original__0001/ANALYZE_7.5";
		SRBFileSystemAdapter sfsAdapter = null;
		try {
			sfsAdapter = new SRBFileSystemAdapter();
			long start = System.currentTimeMillis();
			List<String> files = JargonUtils.getAllFilesUnderCollection2(
					rootCol, sfsAdapter);
			long end = System.currentTimeMillis() - start;
			System.out.println("Elapsed time (msecs):" + end);
			assertTrue(!files.isEmpty());
			for (String f : files) {
				System.out.println(f);
			}
		} finally {
			if (sfsAdapter != null)
				sfsAdapter.shutdown();

		}
	}

	public void testCollectionCopy() throws Exception {
		String srbPath = "/home/Projects/fBIRNPhaseII__0010/Data/000900369824/scanVisit__0009__0002/MRI__0001/bh1/Native/Original__0001/ANALYZE_7.5";
		SRBFileSystemAdapter sfsAdapter = null;
		try {
			sfsAdapter = new SRBFileSystemAdapter();
			long start = System.currentTimeMillis();
			JargonUtils.copyFromSRB(srbPath, "/tmp", sfsAdapter);
			long end = System.currentTimeMillis() - start;
			System.out.println("Elapsed time (msecs):" + end);
		} finally {
			if (sfsAdapter != null)
				sfsAdapter.shutdown();
		}
	}

	public void testIndividualFilesCopy() throws Exception {
		String rootCol = "/home/Projects/fBIRNPhaseII__0010/Data/000900369824/scanVisit__0009__0002/MRI__0001/bh1/Native/Original__0001/ANALYZE_7.5";
		SRBFileSystemAdapter sfsAdapter = null;
		try {
			sfsAdapter = new SRBFileSystemAdapter();
			List<String> files = JargonUtils.getAllFilesUnderCollection2(
					rootCol, sfsAdapter);
			long start = System.currentTimeMillis();
			for (String srbPath : files) {
				int idx = srbPath.lastIndexOf('/');
				String filename = srbPath.substring(idx + 1);
				JargonUtils.copyFromSRB(srbPath,
						"/tmp/ANALYZE_7.5/" + filename, sfsAdapter);
			}
			long end = System.currentTimeMillis() - start;
			System.out.println("Elapsed time (msecs):" + end);
		} finally {
			if (sfsAdapter != null)
				sfsAdapter.shutdown();
		}
	}

	public void testDeleteRecursively() {
		String dir = "/home/bozyurt/download_cache/1210011660327";
		dir = "/home/bozyurt/download_cache/000838972841_1_1284413668372";
		FileUtils.deleteRecursively(new File(dir));
	}

	public void testSortNumerically() {
		File[] jpegFiles = new File[] { new File("128.jpeg"),
				new File("2.jpeg"), new File("8.jpeg") };
		Arrays.sort(jpegFiles, new Comparator<File>() {
			public int compare(File o1, File o2) {
				String prefix1 = o1.getName();
				prefix1 = prefix1.replaceFirst("\\..+$", "");
				String prefix2 = o2.getName();
				prefix2 = prefix2.replaceFirst("\\..+$", "");
				int num1 = GenUtils.toInt(prefix1, -1);
				int num2 = GenUtils.toInt(prefix2, -1);
				return num1 - num2;
			}
		});
	}

	public void testInitializeFromJSON() throws Exception {
		File jsonFile = new File(System.getProperty("user.home"),
				"job_context.json");
		String jsonStr = FileUtils.loadTextFile(jsonFile.getAbsolutePath());
		JSONObject json = new JSONObject(jsonStr);
		CBFWFContext ctx = CBFWFContext.fromJSON(json);
		assertNotNull(ctx.getCacheDir());
		assertTrue(new File(ctx.getCacheDir()).isDirectory());
	}

	URLConnection getConnection(String urlStr, boolean hasOutput)
			throws IOException {
		URL serviceURL = new URL(urlStr);

		URLConnection con = serviceURL.openConnection();
		con.setDoInput(true);
		con.setDoOutput(hasOutput);
		con.setUseCaches(false);

		con.setRequestProperty("Content-Type", "text/plain");
		return con;

	}

	public void testURLConnection() throws Exception {
		String sessionID = FileUtils.loadTextFile(new File(System
				.getProperty("user.home"), "sessionid.txt").getAbsolutePath());

		String url = "http://localhost:8080/cbfbirn/cbfroi.do?action=getImages&jsessionid="
				+ sessionID;
		System.out.println("url=" + url);
		URLConnection con = getConnection(url, false);
		BufferedReader in = null;
		try {
			in = new BufferedReader(new InputStreamReader(con.getInputStream()));
			String line = null;
			while ((line = in.readLine()) != null) {
				System.out.println("line:" + line);

			}
			/*
			 * 
			 * int numImages = GenUtils.toInt(line, 0); for(int i = 0; i <
			 * numImages; i++) { line = in.readLine(); System.out.println(line);
			 * }
			 */

		} finally {
			FileUtils.close(in);
		}
	}

	public void testTiff2PngConversion() throws Exception {
		File dir = new File(System.getProperty("user.home")
				+ "/download_cache/000838972841_1_1270674019975/matlab_out");
		File destDir = new File(System.getProperty("user.home") + "/tmp");
		File[] files = dir.listFiles();
		for (String s : ImageIO.getReaderFormatNames()) {
			System.out.println(s);
		}
		for (File f : files) {
			if (f.getName().toLowerCase().endsWith(".tif")) {
				BufferedImage tif = ImageIO.read(f);
				int len = f.getName().length();
				File destImg = new File(destDir, f.getName().substring(0,
						len - 4)
						+ ".png");
				ImageIO.write(tif, "png", destImg);
			}
		}
	}

	public void testFileMove() {
		File src = new File(
				"/home/bozyurt/download_cache/upload/upload_1271249315491.tgz_1271249316058/P20992.7");
		File dest = new File(
				"/home/bozyurt/data/ASL/000838972841/Visit_09_24_2009/P20922.7");
		dest = new File("/data/share/P20922.7");
		dest = src = new File(
				"/home/bozyurt/download_cache/upload/upload_1271249315491.tgz_1271249316058/xx");
		boolean ok = src.renameTo(dest);
		assertTrue(ok);
	}

	public void testExecutor() throws Exception {
		for (int i = 0; i < 20; i++) {
			Executor exec = new Executor("ls", false);
			exec.execute(System.getProperty("user.home"));

			String out = exec.getOutput();
			System.out.println(out);
			System.out.println("----------------------");
		}
	}

	public void testPatternInPathMatch() throws Exception {
		String path = "/home/bozyurt/data/Tom_EEG_Caffeine/000804687028/Visit_08_04_2010/derived.1/07_rest_EO_optPCASL+dbl+orig";

		List<File> allFiles = FileUtils
				.getAllUnderDir("/home/bozyurt/data/Tom_EEG_Caffeine/000804687028/Visit_08_04_2010");

		Pattern derivedPattern = Pattern.compile("\\/derived(\\.\\d+)?");
		for (File f : allFiles) {
			if (f.isDirectory()) {
				System.out.println(f);
				Matcher m = derivedPattern.matcher(f.getAbsolutePath());
				if (m.find()) {
					String derivedDir = path.substring(0, m.end());
					if (new File(derivedDir).isDirectory()) {
						System.out.println(">> " + derivedDir);
					}
				}
			}
		}

		Matcher m = derivedPattern.matcher(path);
		if (m.find()) {
			String derivedDir = path.substring(0, m.end());
			System.out.println("");
			System.out.println(derivedDir);
		}
	}

	public static TestSuite suite() {
		TestSuite suite = new TestSuite();
		// suite.addTest(new MiscTests("rangeCalcTest"));
		// suite.addTest(new MiscTests("numberFormatTest"));
		// suite.addTest(new MiscTests("testGetAllFilesUnderDir"));
		// suite.addTest(new MiscTests("testGetAllFilesUnderCollection"));
		// suite.addTest( new MiscTests("testCollectionCopy"));
		// suite.addTest( new MiscTests("testIndividualFilesCopy"));
		// suite.addTest( new MiscTests("testDeleteRecursively"));
		// suite.addTest( new MiscTests("testInitializeFromJSON"));
		// suite.addTest( new MiscTests("testURLConnection"));
		// suite.addTest( new MiscTests("testTiff2PngConversion"));
		// suite.addTest(new MiscTests("testFileMove"));
		// suite.addTest(new MiscTests("testExecutor"));
		suite.addTest(new MiscTests("testPatternInPathMatch"));
		return suite;
	}

	public static void main(String[] args) {
		junit.textui.TestRunner.run(suite());
	}

}